/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.httpClient.examples.server.GetCommentsWithFunction;
import com.intellij.httpClient.examples.server.GetUserFunction;
import com.intellij.httpClient.examples.server.GraphQLExecutor;
import com.intellij.httpClient.examples.server.GraphQLQuery;
import com.intellij.httpClient.examples.server.GraphQLRequest;
import com.intellij.httpClient.examples.server.GraphQLResponse;
import com.intellij.httpClient.examples.server.HttpClientExamplesServerKt;
import com.intellij.httpClient.examples.server.NewCommentFunction;
import com.intellij.httpClient.examples.server.NewCommentsFunction;
import com.intellij.httpClient.http.request.HttpClientCoroutinesService;
import com.intellij.httpClient.http.request.HttpClientCoroutinesServiceKt;
import com.intellij.openapi.util.Key;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u001c\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/httpClient/examples/server/GraphQLClientWebSocketHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "<init>", "()V", "JOB_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlinx/coroutines/Job;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "executor", "Lcom/intellij/httpClient/examples/server/GraphQLExecutor;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "disconnected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "getMessageServer", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "message", "", "type", "payload", "GraphQLWsMessage", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLClientWebSocketHandler\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,611:1\n306#2:612\n1#3:613\n1#3:627\n1#3:642\n430#4,2:614\n433#4,2:629\n116#5:616\n54#5:617\n117#5:618\n61#5,8:619\n71#5:628\n80#5:631\n54#5:632\n81#5:633\n61#5,8:634\n71#5:643\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLClientWebSocketHandler\n*L\n175#1:612\n201#1:627\n216#1:642\n201#1:614,2\n201#1:629,2\n201#1:616\n201#1:617\n201#1:618\n201#1:619,8\n201#1:628\n216#1:631\n216#1:632\n216#1:633\n216#1:634,8\n216#1:643\n*E\n"})
final class GraphQLClientWebSocketHandler
extends WebSocketHandshakeHandler {
    @NotNull
    private final Key<Job> JOB_KEY;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final GraphQLExecutor executor;

    /*
     * WARNING - void declaration
     */
    public GraphQLClientWebSocketHandler() {
        void $this$executor_u24lambda_u240;
        Map map2;
        Key key = Key.create((String)"http.client.examples.server.subscription.job");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.JOB_KEY = key;
        this.mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        boolean $i$f$enumMapOf = false;
        Map map3 = map2 = (Map)new EnumMap(GraphQLQuery.Operation.class);
        GraphQLClientWebSocketHandler graphQLClientWebSocketHandler = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"getUser", (Object)GetUserFunction.INSTANCE), TuplesKt.to((Object)"getCommentsWith", (Object)GetCommentsWithFunction.INSTANCE)};
        $this$executor_u24lambda_u240.put(GraphQLQuery.Operation.QUERY, MapsKt.mapOf((Pair[])pairArray));
        $this$executor_u24lambda_u240.put(GraphQLQuery.Operation.MUTATION, MapsKt.mapOf((Pair)TuplesKt.to((Object)"newComment", (Object)NewCommentFunction.INSTANCE)));
        $this$executor_u24lambda_u240.put(GraphQLQuery.Operation.SUBSCRIPTION, MapsKt.mapOf((Pair)TuplesKt.to((Object)"newComments", (Object)NewCommentsFunction.INSTANCE)));
        Map map4 = map2;
        graphQLClientWebSocketHandler.executor = new GraphQLExecutor(map4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples/graphql-ws", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public void disconnected(@NotNull Client client) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Job job2 = (Job)client.getUserData(this.JOB_KEY);
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
    }

    @NotNull
    protected MessageServer getMessageServer() {
        return (arg_0, arg_1) -> GraphQLClientWebSocketHandler.getMessageServer$lambda$0(this, arg_0, arg_1);
    }

    private final String message(String type, @Language(value="JSON") String payload) {
        String string;
        Object[] objectArray = new String[2];
        objectArray[0] = "\"type\": \"" + type + "\"";
        Object[] objectArray2 = objectArray;
        int n = 1;
        String string2 = payload;
        if (string2 != null) {
            String string3 = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            String string4 = "\"payload\": " + payload;
            objectArray2 = objectArray3;
            n = n2;
            string = string4;
        } else {
            string = null;
        }
        objectArray2[n] = string;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
    }

    static /* synthetic */ String message$default(GraphQLClientWebSocketHandler graphQLClientWebSocketHandler, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return graphQLClientWebSocketHandler.message(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMessageServer$lambda$0(GraphQLClientWebSocketHandler this$0, Client client, CharSequence message) {
        void v3;
        boolean $i$f$checkTypeMismatch;
        ObjectMapper $this$readValue$iv$iv;
        boolean $i$f$readValue;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(client instanceof WebSocketClient)) {
            return;
        }
        Object object = this$0.mapper;
        CharSequence json$iv = message;
        boolean $i$f$fromJson = false;
        try {
            void $this$checkTypeMismatch$iv$iv$iv;
            void $this$fromJson$iv;
            void var7_7 = $this$fromJson$iv;
            String content$iv$iv = ((Object)json$iv).toString();
            $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<GraphQLWsMessage>(){});
            $i$f$checkTypeMismatch = false;
            if (!($this$checkTypeMismatch$iv$iv$iv instanceof GraphQLWsMessage)) {
                String string;
                String nullability$iv$iv$iv = "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(GraphQLWsMessage.class).getQualifiedName()).append(nullability$iv$iv$iv).append(" but was ");
                void v1 = $this$checkTypeMismatch$iv$iv$iv;
                if (v1 != null) {
                    void it$iv$iv$iv;
                    void var13_20 = v1;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv$iv.getClass()).getQualifiedName();
                    stringBuilder = stringBuilder2;
                } else {
                    string = null;
                }
                String string2 = stringBuilder.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            v3 = $this$checkTypeMismatch$iv$iv$iv;
        }
        catch (JacksonException e$iv) {
            JacksonException it = e$iv;
            boolean bl = false;
            HttpClientExamplesServerKt.access$send((WebSocketClient)client, this$0.message("error", "{\"error\": \"malformed JSON\"}"));
            ((WebSocketClient)client).disconnect(new CloseWebSocketFrame());
            return;
        }
        GraphQLWsMessage clientMessage = (GraphQLWsMessage)v3;
        switch (clientMessage.getType()) {
            case "ping": {
                HttpClientExamplesServerKt.access$send((WebSocketClient)client, GraphQLClientWebSocketHandler.message$default(this$0, "pong", null, 2, null));
                break;
            }
            case "connection_init": {
                HttpClientExamplesServerKt.access$send((WebSocketClient)client, GraphQLClientWebSocketHandler.message$default(this$0, "connection_ack", null, 2, null));
                break;
            }
            case "subscribe": {
                void $this$checkTypeMismatch$iv$iv;
                void $this$readValue$iv;
                JsonNode payload = clientMessage.getPayload();
                if (payload == null) {
                    HttpClientExamplesServerKt.access$send((WebSocketClient)client, this$0.message("error", "{\"error\": \"payload expected\"}"));
                    ((WebSocketClient)client).disconnect(new CloseWebSocketFrame());
                    return;
                }
                $this$readValue$iv$iv = this$0.mapper;
                JsonParser jsonParser = payload.traverse();
                Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"traverse(...)");
                JsonParser jp$iv = jsonParser;
                $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef32 = false;
                Object $i$f$jacksonTypeRef32 = $this$readValue$iv.readValue(jp$iv, (TypeReference)new TypeReference<GraphQLRequest>(){});
                $i$f$checkTypeMismatch = false;
                if (!($this$checkTypeMismatch$iv$iv instanceof GraphQLRequest)) {
                    String string;
                    String nullability$iv$iv = "(non-null)";
                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(GraphQLRequest.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                    void v6 = $this$checkTypeMismatch$iv$iv;
                    if (v6 != null) {
                        void it$iv$iv;
                        void it$iv$iv$iv = v6;
                        StringBuilder stringBuilder3 = stringBuilder;
                        boolean bl = false;
                        string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                        stringBuilder = stringBuilder3;
                    } else {
                        string = null;
                    }
                    String string3 = stringBuilder.append(string).toString();
                    throw new RuntimeJsonMappingException(string3);
                }
                GraphQLRequest jsonPayload = (GraphQLRequest)$this$checkTypeMismatch$iv$iv;
                GraphQLQuery parsedQuery = HttpClientExamplesServerKt.access$parseQuery(jsonPayload);
                if (parsedQuery == null) {
                    HttpClientExamplesServerKt.access$send((WebSocketClient)client, this$0.message("error", "{\"error\": \"malformed GraphQL request\"}"));
                    ((WebSocketClient)client).disconnect(new CloseWebSocketFrame());
                    return;
                }
                GraphQLResponse result2 = this$0.executor.execute(parsedQuery, jsonPayload.getVariables());
                if (result2 instanceof GraphQLResponse.Single) {
                    String jsonResult = this$0.mapper.writeValueAsString((Object)result2);
                    HttpClientExamplesServerKt.access$send((WebSocketClient)client, this$0.message("next", jsonResult));
                    HttpClientExamplesServerKt.access$send((WebSocketClient)client, GraphQLClientWebSocketHandler.message$default(this$0, "complete", null, 2, null));
                    break;
                }
                if (result2 instanceof GraphQLResponse.SubscriptionStream) {
                    Job job2 = BuildersKt.launch$default((CoroutineScope)HttpClientCoroutinesService.Companion.getInstance$default(HttpClientCoroutinesService.Companion, null, 1, null).scope((CoroutineContext)HttpClientCoroutinesServiceKt.getHttpClientTasks(Dispatchers.INSTANCE)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result2, this$0, client, null){
                        int label;
                        final /* synthetic */ GraphQLResponse $result;
                        final /* synthetic */ GraphQLClientWebSocketHandler this$0;
                        final /* synthetic */ Client $client;
                        {
                            this.$result = $result;
                            this.this$0 = $receiver;
                            this.$client = $client;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = ((GraphQLResponse.SubscriptionStream)this.$result).getStream().collect(new FlowCollector(this.this$0, this.$client){
                                        final /* synthetic */ GraphQLClientWebSocketHandler this$0;
                                        final /* synthetic */ Client $client;
                                        {
                                            this.this$0 = $receiver;
                                            this.$client = $client;
                                        }

                                        public final Object emit(Map<String, ? extends Object> it, Continuation<? super Unit> $completion) {
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"data", it)};
                                            String jsonResult = GraphQLClientWebSocketHandler.access$getMapper$p(this.this$0).writeValueAsString((Object)MapsKt.mutableMapOf((Pair[])pairArray));
                                            HttpClientExamplesServerKt.access$send((WebSocketClient)this.$client, GraphQLClientWebSocketHandler.access$message(this.this$0, "next", jsonResult));
                                            return Unit.INSTANCE;
                                        }
                                    }, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    client.putUserData(this$0.JOB_KEY, (Object)job2);
                    break;
                }
                if (result2 == null) {
                    HttpClientExamplesServerKt.access$send((WebSocketClient)client, this$0.message("error", "{\"error\": \"malformed GraphQL request\"}"));
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(GraphQLClientWebSocketHandler $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ String access$message(GraphQLClientWebSocketHandler $this, String type, String payload) {
        return $this.message(type, payload);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/examples/server/GraphQLClientWebSocketHandler$GraphQLWsMessage;", "", "type", "", "payload", "Lcom/fasterxml/jackson/databind/JsonNode;", "<init>", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/JsonNode;)V", "getType", "()Ljava/lang/String;", "getPayload", "()Lcom/fasterxml/jackson/databind/JsonNode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class GraphQLWsMessage {
        @NotNull
        private final String type;
        @Nullable
        private final JsonNode payload;

        public GraphQLWsMessage(@NotNull String type, @Nullable JsonNode payload) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.payload = payload;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final JsonNode getPayload() {
            return this.payload;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @Nullable
        public final JsonNode component2() {
            return this.payload;
        }

        @NotNull
        public final GraphQLWsMessage copy(@NotNull String type, @Nullable JsonNode payload) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new GraphQLWsMessage(type, payload);
        }

        public static /* synthetic */ GraphQLWsMessage copy$default(GraphQLWsMessage graphQLWsMessage, String string, JsonNode jsonNode, int n, Object object) {
            if ((n & 1) != 0) {
                string = graphQLWsMessage.type;
            }
            if ((n & 2) != 0) {
                jsonNode = graphQLWsMessage.payload;
            }
            return graphQLWsMessage.copy(string, jsonNode);
        }

        @NotNull
        public String toString() {
            return "GraphQLWsMessage(type=" + this.type + ", payload=" + this.payload + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.payload == null ? 0 : this.payload.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GraphQLWsMessage)) {
                return false;
            }
            GraphQLWsMessage graphQLWsMessage = (GraphQLWsMessage)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)graphQLWsMessage.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.payload, (Object)graphQLWsMessage.payload);
        }
    }
}

