/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.adapters.DefaultParsedHeader;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientResponseHeader;
import com.intellij.httpClient.execution.adapters.HttpClientResponseStatusLine;
import com.intellij.httpClient.execution.impl.engineV2.NettyAdaptersKt;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.netty.http.client.HttpClientResponse;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/NettyHttpResponseAdapter;", "Lcom/intellij/httpClient/execution/adapters/HttpClientResponse;", "response", "Lreactor/netty/http/client/HttpClientResponse;", "protocolPresentation", "", "<init>", "(Lreactor/netty/http/client/HttpClientResponse;Ljava/lang/String;)V", "headers", "", "Lcom/intellij/httpClient/execution/adapters/HttpClientResponseHeader;", "getHeaders", "()Ljava/util/List;", "getHeader", "name", "contentType", "Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "getContentType", "()Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "contentType$delegate", "Lkotlin/Lazy;", "statusLine", "Lcom/intellij/httpClient/execution/adapters/HttpClientResponseStatusLine;", "getStatusLine", "()Lcom/intellij/httpClient/execution/adapters/HttpClientResponseStatusLine;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nnettyAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpResponseAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1586#2:144\n1661#2,3:145\n1#3:148\n*S KotlinDebug\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpResponseAdapter\n*L\n32#1:144\n32#1:145,3\n*E\n"})
public final class NettyHttpResponseAdapter
implements com.intellij.httpClient.execution.adapters.HttpClientResponse {
    @NotNull
    private final HttpClientResponse response;
    @NotNull
    private final String protocolPresentation;
    @NotNull
    private final Lazy contentType$delegate;

    public NettyHttpResponseAdapter(@NotNull HttpClientResponse response2, @NotNull String protocolPresentation) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)protocolPresentation, (String)"protocolPresentation");
        this.response = response2;
        this.protocolPresentation = protocolPresentation;
        this.contentType$delegate = LazyKt.lazy(() -> NettyHttpResponseAdapter.contentType_delegate$lambda$0(this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpClientResponseHeader> getHeaders() {
        void $this$mapTo$iv$iv;
        HttpHeaders httpHeaders = this.response.responseHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"responseHeaders(...)");
        Iterable $this$map$iv = (Iterable)httpHeaders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            String name = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)value2);
            collection.add(new DefaultParsedHeader(name, value2));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public HttpClientResponseHeader getHeader(@NotNull String name) {
        DefaultParsedHeader defaultParsedHeader;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.response.responseHeaders().get(name);
        if (string != null) {
            String it = string;
            boolean bl = false;
            defaultParsedHeader = new DefaultParsedHeader(name, it);
        } else {
            defaultParsedHeader = null;
        }
        return defaultParsedHeader;
    }

    @Override
    @NotNull
    public HttpClientContentType getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (HttpClientContentType)lazy.getValue();
    }

    @Override
    @NotNull
    public HttpClientResponseStatusLine getStatusLine() {
        return new HttpClientResponseStatusLine(this.protocolPresentation, this.response.status().code(), this.response.status().reasonPhrase());
    }

    private static final HttpClientContentType contentType_delegate$lambda$0(NettyHttpResponseAdapter this$0) {
        return NettyAdaptersKt.access$extractContentType(this$0.response);
    }
}

