/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.security;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/http/security/Http2HttpsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.restClient"})
public class Http2HttpsQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("intention.family.name.change.prefix.to.https", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator == null) {
            Logger.getInstance(Http2HttpsQuickFix.class).warn("No Manipulator for " + psiElement + ", language:" + psiElement.getLanguage());
            return;
        }
        TextRange textRange = descriptor.getTextRangeInElement();
        if (textRange != null) {
            v0 = ElementManipulators.handleContentChange((PsiElement)psiElement, (TextRange)descriptor.getTextRangeInElement(), (String)"https://");
        } else {
            Logger.getInstance(Http2HttpsQuickFix.class).warn("No provided textRange for schema in " + psiElement);
            String string = psiElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String replace2 = StringsKt.replaceFirst$default((String)string, (String)"http://", (String)"https://", (boolean)false, (int)4, null);
            v0 = ElementManipulators.handleContentChange((PsiElement)psiElement, (String)replace2);
        }
    }
}

