/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.injection.http.request;

import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestContentDescriptor;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.injection.http.request.HttpClientCustomBodyInjector;
import com.intellij.httpClient.injection.http.request.ImplicitMimeTypeProvider;
import com.intellij.httpClient.injection.http.request.InjectionsKt;
import com.intellij.httpClient.injection.http.request.Place;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HttpRequestBodyInjector
implements MultiHostInjector {
    private static final List<Class<? extends HttpRequestMessagesGroup>> INJECTION_CONTEXT = Collections.singletonList(HttpRequestMessagesGroup.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context2) {
        if (registrar == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(1);
        }
        if (context2 instanceof HttpRequestMessagesGroup) {
            Language language;
            HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)context2, HttpRequest.class);
            if (httpRequest != null) {
                List<HttpClientCustomBodyInjector> bodyInjectors = HttpClientCustomBodyInjector.Companion.findAllApplicable(httpRequest);
                for (HttpClientCustomBodyInjector bodyInjector : bodyInjectors) {
                    bodyInjector.provideInjection(registrar, (HttpRequestMessagesGroup)context2);
                }
            }
            if ((language = HttpRequestBodyInjector.getInjectedLanguage(context2)) == null) {
                return;
            }
            HttpRequestBodyInjector.injectHttpMessages(registrar, (HttpRequestMessagesGroup)context2, language);
        }
    }

    private static void injectHttpMessages(@NotNull MultiHostRegistrar registrar, HttpRequestMessagesGroup context2, Language language) {
        if (registrar == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(2);
        }
        List<HttpMessageBody> messages = context2.getRequestMessageList().stream().filter(message -> message instanceof HttpMessageBody && message.getTextLength() > 0).map(message -> (HttpMessageBody)message).toList();
        for (int i = 0; i < messages.size(); ++i) {
            HttpMessageBody message2 = messages.get(i);
            String messageBody = message2.getContentRange().substring(message2.getText());
            int messageOffset = message2.getContentRange().getStartOffset();
            List<Place> injectionPlaces = HttpRequestBodyInjector.injectBody(message2, messageBody, null, messageOffset);
            InjectionsKt.inject(registrar, language, injectionPlaces);
        }
    }

    public static List<Place> injectBody(@NotNull HttpMessageBody message, @NotNull String messageText, @NonNls @Nullable String suffix, int messageOffset) {
        if (message == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(3);
        }
        if (messageText == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(4);
        }
        ArrayList<Place> injectionPlaces = new ArrayList<Place>();
        int lastVariableRangeEndOffset = 0;
        List<TextRange> textRanges = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageText);
        for (TextRange variableRange : textRanges) {
            TextRange range = TextRange.create((int)lastVariableRangeEndOffset, (int)variableRange.getStartOffset());
            String placeHolder = new StringBuilder(variableRange.getLength()).repeat(97, variableRange.getLength()).toString();
            Place place = new Place(null, placeHolder, message, range.shiftRight(messageOffset));
            injectionPlaces.add(place);
            lastVariableRangeEndOffset = variableRange.getEndOffset();
        }
        TextRange range = TextRange.create((int)lastVariableRangeEndOffset, (int)messageText.length());
        Place lastPlace = new Place(null, suffix, message, range.shiftRight(messageOffset));
        injectionPlaces.add(lastPlace);
        return injectionPlaces;
    }

    @Nullable
    private static Language getInjectedLanguage(@NotNull PsiElement context2) {
        if (context2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(5);
        }
        HttpRequestContentDescriptor descriptor = (HttpRequestContentDescriptor)PsiTreeUtil.getParentOfType((PsiElement)context2, HttpRequestContentDescriptor.class);
        String mimeType = null;
        if (descriptor != null) {
            mimeType = descriptor.getMimeType();
        }
        if (mimeType == null) {
            HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)context2, HttpRequest.class);
            if (httpRequest == null) {
                return null;
            }
            for (ImplicitMimeTypeProvider provider : ImplicitMimeTypeProvider.EP_NAME.getExtensionList()) {
                String providedType = provider.getRequestPayloadMimeType(httpRequest);
                if (providedType == null) continue;
                mimeType = providedType;
                break;
            }
        }
        return HttpRequestBodyInjector.getLanguageByMimeType(mimeType);
    }

    @Nullable
    static Language getLanguageByMimeType(@Nullable String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        return (Language)ContainerUtil.getFirstItem((Collection)Language.findInstancesByMimeType((String)mimeType));
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends HttpRequestMessagesGroup>> list2 = INJECTION_CONTEXT;
        if (list2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/injection/http/request/HttpRequestBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/injection/http/request/HttpRequestBodyInjector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "injectHttpMessages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "injectBody";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

