/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.converter.FileType;
import com.intellij.httpClient.postman.converter.PostmanCollectionConverterKt;
import com.intellij.httpClient.postman.converter.PostmanFileDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u001a\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"COLLECTION_SUFFIX", "", "ENVIRONMENT_SUFFIX", "POSTMAN_CONVERTER_GIST_KEY", "GIST_VERSION", "", "isPostmanCollectionFile", "", "tree", "Lcom/fasterxml/jackson/databind/JsonNode;", "isPostmanCollectionFileName", "fileName", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isPostmanEnvironmentFile", "parseToTree", "virtualFile", "isPostmanFile", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanFileChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanFileChecker.kt\ncom/intellij/httpClient/postman/converter/PostmanFileCheckerKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,104:1\n42#2,3:105\n42#2,3:108\n*S KotlinDebug\n*F\n+ 1 PostmanFileChecker.kt\ncom/intellij/httpClient/postman/converter/PostmanFileCheckerKt\n*L\n79#1:105,3\n85#1:108,3\n*E\n"})
public final class PostmanFileCheckerKt {
    @NotNull
    public static final String COLLECTION_SUFFIX = ".postman_collection";
    @NotNull
    public static final String ENVIRONMENT_SUFFIX = ".postman_environment";
    @NotNull
    private static final String POSTMAN_CONVERTER_GIST_KEY = "com.intellij.httpClient.postman.converter.gist.key";
    private static final int GIST_VERSION = 2;

    private static final boolean isPostmanCollectionFile(JsonNode tree) {
        JsonNode jsonNode = tree.get("info");
        if (jsonNode == null) {
            return false;
        }
        JsonNode info = jsonNode;
        if (info.get("_postman_id") != null) {
            return true;
        }
        Object object = info.get("schema");
        if (object == null || (object = object.textValue()) == null) {
            return false;
        }
        Object schema = object;
        return StringsKt.contains((CharSequence)((CharSequence)schema), (CharSequence)"postman", (boolean)true);
    }

    public static final boolean isPostmanCollectionFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return StringsKt.contains$default((CharSequence)fileName, (CharSequence)COLLECTION_SUFFIX, (boolean)false, (int)2, null);
    }

    @RequiresReadLock
    public static final boolean isPostmanCollectionFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (PostmanFileCheckerKt.isPostmanCollectionFileName(string)) {
            return true;
        }
        boolean $i$f$service = false;
        Class<PostmanFileDetector> serviceClass$iv = PostmanFileDetector.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((PostmanFileDetector)object).getPostmanFileType(project, file) == FileType.POSTMAN_COLLECTION;
    }

    public static final boolean isPostmanEnvironmentFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)ENVIRONMENT_SUFFIX, (boolean)false, (int)2, null)) {
            return true;
        }
        boolean $i$f$service = false;
        Class<PostmanFileDetector> serviceClass$iv = PostmanFileDetector.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((PostmanFileDetector)object).getPostmanFileType(project, file) == FileType.POSTMAN_ENVIRONMENT;
    }

    private static final JsonNode parseToTree(VirtualFile virtualFile) {
        JsonNode jsonNode;
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile)) {
            PostmanCollectionConverterKt.getPostmanConverterLogger().warning("File size is too big " + virtualFile.getName() + ", could not parse to json");
            return null;
        }
        try {
            jsonNode = PostmanMapperKt.getPostmanMapper().readTree(VfsUtil.loadText((VirtualFile)virtualFile));
        }
        catch (Exception e) {
            PostmanCollectionConverterKt.getPostmanConverterLogger().warning("Could not parse file " + virtualFile.getName() + " to tree: " + e);
            jsonNode = null;
        }
        return jsonNode;
    }

    public static final boolean isPostmanFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return PostmanFileCheckerKt.isPostmanCollectionFile(project, file) || PostmanFileCheckerKt.isPostmanEnvironmentFile(project, file);
    }

    public static final /* synthetic */ JsonNode access$parseToTree(VirtualFile virtualFile) {
        return PostmanFileCheckerKt.parseToTree(virtualFile);
    }

    public static final /* synthetic */ boolean access$isPostmanCollectionFile(JsonNode tree) {
        return PostmanFileCheckerKt.isPostmanCollectionFile(tree);
    }
}

