/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.auth.digest;

import com.intellij.httpClient.postman.converter.auth.digest.DigestAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.DigestScriptProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.HeaderAttribute;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\tJ$\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0007JH\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001dH\u0002J\t\u0010\u001e\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020\u0007H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/httpClient/postman/converter/auth/digest/DigestCalculator;", "", "messageDigest", "Ljava/security/MessageDigest;", "<init>", "(Ljava/security/MessageDigest;)V", "calculateHA1", "", "userName", "Lcom/intellij/httpClient/postman/converter/auth/digest/HeaderAttribute;", "realm", "password", "isSess", "", "nonce", "clientNonce", "calculateHA2", "method", "digestUrl", "entityBody", "calculateResponse", "ha1", "ha2", "nonceCount", "qop", "digest", "value", "isNullOrFromEnv", "attributes", "", "component1", "copy", "equals", "other", "hashCode", "", "toString", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nDigestScriptProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestScriptProvider.kt\ncom/intellij/httpClient/postman/converter/auth/digest/DigestCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1807#2,3:236\n*S KotlinDebug\n*F\n+ 1 DigestScriptProvider.kt\ncom/intellij/httpClient/postman/converter/auth/digest/DigestCalculator\n*L\n231#1:236,3\n*E\n"})
final class DigestCalculator {
    @NotNull
    private final MessageDigest messageDigest;

    public DigestCalculator(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        this.messageDigest = messageDigest;
    }

    @Nullable
    public final String calculateHA1(@NotNull HeaderAttribute userName, @NotNull HeaderAttribute realm, @NotNull HeaderAttribute password, boolean isSess, @Nullable HeaderAttribute nonce, @Nullable HeaderAttribute clientNonce) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Object[] objectArray = new HeaderAttribute[]{userName, realm, password};
        if (this.isNullOrFromEnv(CollectionsKt.listOf((Object[])objectArray))) {
            return null;
        }
        String initial = userName.getValue() + ":" + realm.getValue() + ":" + password.getValue();
        if (isSess) {
            Object[] objectArray2 = new HeaderAttribute[]{nonce, clientNonce};
            if (this.isNullOrFromEnv(CollectionsKt.listOf((Object[])objectArray2))) {
                return null;
            }
            String firstPart = this.digest(initial);
            HeaderAttribute headerAttribute = nonce;
            Intrinsics.checkNotNull((Object)headerAttribute);
            String string = headerAttribute.getValue();
            HeaderAttribute headerAttribute2 = clientNonce;
            Intrinsics.checkNotNull((Object)headerAttribute2);
            return this.digest(firstPart + ":" + string + ":" + headerAttribute2.getValue());
        }
        return this.digest(initial);
    }

    public static /* synthetic */ String calculateHA1$default(DigestCalculator digestCalculator, HeaderAttribute headerAttribute, HeaderAttribute headerAttribute2, HeaderAttribute headerAttribute3, boolean bl, HeaderAttribute headerAttribute4, HeaderAttribute headerAttribute5, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            headerAttribute4 = null;
        }
        if ((n & 0x20) != 0) {
            headerAttribute5 = null;
        }
        return digestCalculator.calculateHA1(headerAttribute, headerAttribute2, headerAttribute3, bl, headerAttribute4, headerAttribute5);
    }

    @Nullable
    public final String calculateHA2(@NotNull HeaderAttribute method, @NotNull HeaderAttribute digestUrl, @Nullable String entityBody) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)digestUrl, (String)"digestUrl");
        Object[] objectArray = new HeaderAttribute[]{method, digestUrl};
        if (this.isNullOrFromEnv(CollectionsKt.listOf((Object[])objectArray))) {
            return null;
        }
        String initial = method.getValue() + ":" + digestUrl.getValue();
        return entityBody == null ? this.digest(initial) : this.digest(initial + ":" + this.digest(entityBody));
    }

    public static /* synthetic */ String calculateHA2$default(DigestCalculator digestCalculator, HeaderAttribute headerAttribute, HeaderAttribute headerAttribute2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return digestCalculator.calculateHA2(headerAttribute, headerAttribute2, string);
    }

    @Nullable
    public final String calculateResponse(@Nullable String ha1, @Nullable String ha2, @NotNull HeaderAttribute nonce, @Nullable HeaderAttribute nonceCount, @Nullable HeaderAttribute clientNonce, @Nullable HeaderAttribute qop) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        if (ha1 == null || ha2 == null) {
            return null;
        }
        if (this.isNullOrFromEnv(CollectionsKt.listOf((Object)nonce))) {
            return null;
        }
        Object object = qop;
        if (object == null || (object = DigestAuthProviderKt.toQopType(object)) == null) {
            return this.digest(ha1 + ":" + nonce.getValue() + ":" + ha2);
        }
        Object[] objectArray = new HeaderAttribute[]{nonceCount, clientNonce, qop};
        if (this.isNullOrFromEnv(CollectionsKt.listOf((Object[])objectArray))) {
            return null;
        }
        String string = nonce.getValue();
        HeaderAttribute headerAttribute = nonceCount;
        Intrinsics.checkNotNull((Object)headerAttribute);
        String string2 = headerAttribute.getValue();
        HeaderAttribute headerAttribute2 = clientNonce;
        Intrinsics.checkNotNull((Object)headerAttribute2);
        return this.digest(ha1 + ":" + string + ":" + string2 + ":" + headerAttribute2.getValue() + ":" + qop.getValue() + ":" + ha2);
    }

    public static /* synthetic */ String calculateResponse$default(DigestCalculator digestCalculator, String string, String string2, HeaderAttribute headerAttribute, HeaderAttribute headerAttribute2, HeaderAttribute headerAttribute3, HeaderAttribute headerAttribute4, int n, Object object) {
        if ((n & 8) != 0) {
            headerAttribute2 = null;
        }
        if ((n & 0x10) != 0) {
            headerAttribute3 = null;
        }
        if ((n & 0x20) != 0) {
            headerAttribute4 = null;
        }
        return digestCalculator.calculateResponse(string, string2, headerAttribute, headerAttribute2, headerAttribute3, headerAttribute4);
    }

    private final String digest(String value2) {
        byte[] byArray = value2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = this.messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return DigestScriptProviderKt.access$toHex(byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullOrFromEnv(List<HeaderAttribute> attributes) {
        HeaderAttribute headerAttribute;
        HeaderAttribute it;
        boolean bl;
        Iterable $this$any$iv = attributes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (HeaderAttribute)element$iv;
                boolean bl2 = false;
                if (it == null) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = attributes;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (HeaderAttribute)element$iv;
            boolean bl4 = false;
            headerAttribute = it;
            Intrinsics.checkNotNull((Object)headerAttribute);
        } while (!headerAttribute.isFromEnv());
        return true;
    }

    private final MessageDigest component1() {
        return this.messageDigest;
    }

    @NotNull
    public final DigestCalculator copy(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        return new DigestCalculator(messageDigest);
    }

    public static /* synthetic */ DigestCalculator copy$default(DigestCalculator digestCalculator, MessageDigest messageDigest, int n, Object object) {
        if ((n & 1) != 0) {
            messageDigest = digestCalculator.messageDigest;
        }
        return digestCalculator.copy(messageDigest);
    }

    @NotNull
    public String toString() {
        return "DigestCalculator(messageDigest=" + this.messageDigest + ")";
    }

    public int hashCode() {
        return this.messageDigest.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DigestCalculator)) {
            return false;
        }
        DigestCalculator digestCalculator = (DigestCalculator)other;
        return Intrinsics.areEqual((Object)this.messageDigest, (Object)digestCalculator.messageDigest);
    }
}

