/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface CompileContext
extends UserDataHolder {
    default public void addMessage(@NotNull CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable String url, int lineNum, int columnNum) {
        if (category == null) {
            CompileContext.$$$reportNull$$$0(0);
        }
        this.addMessage(category, message, url, lineNum, columnNum, null);
    }

    default public void addMessage(@NotNull CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable String url, int lineNum, int columnNum, @Nullable Navigatable navigatable) {
        if (category == null) {
            CompileContext.$$$reportNull$$$0(1);
        }
        this.addMessage(category, message, url, lineNum, columnNum, navigatable, Collections.emptyList());
    }

    public void addMessage(@NotNull CompilerMessageCategory var1, @Nls(capitalization=Nls.Capitalization.Sentence) String var2, @Nullable String var3, int var4, int var5, @Nullable Navigatable var6, Collection<String> var7);

    public CompilerMessage @NotNull [] getMessages(@NotNull CompilerMessageCategory var1);

    public int getMessageCount(@Nullable CompilerMessageCategory var1);

    @NotNull
    public ProgressIndicator getProgressIndicator();

    public CompileScope getCompileScope();

    public CompileScope getProjectCompileScope();

    @Deprecated(forRemoval=true)
    default public void requestRebuildNextTime(String message) {
    }

    @Deprecated(forRemoval=true)
    default public boolean isRebuildRequested() {
        return false;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public String getRebuildReason() {
        return null;
    }

    public Module getModuleByFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getModuleOutputDirectory(@NotNull Module var1);

    @Nullable
    public VirtualFile getModuleOutputDirectoryForTests(Module var1);

    public boolean isMake();

    public boolean isAutomake();

    public boolean isRebuild();

    @NotNull
    public Project getProject();

    public boolean isAnnotationProcessorsEnabled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/compiler/CompileContext", "addMessage"));
    }
}

