/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionValidator {
    public static final ProjectExtensionPointName<InspectionValidator> EP_NAME = new ProjectExtensionPointName("com.intellij.compiler.inspectionValidator");
    private final String myId;
    @Nls
    private final String myDescription;
    private final @NlsContexts.ProgressText String myProgressIndicatorText;
    private final Class<? extends LocalInspectionTool> @Nullable [] myInspectionToolClasses;
    @Nullable
    private final InspectionToolProvider myInspectionToolProvider;

    protected InspectionValidator(@NotNull @NonNls String id, @NotNull @Nls String description, @NotNull @Nls String progressIndicatorText) {
        if (id == null) {
            InspectionValidator.$$$reportNull$$$0(0);
        }
        if (description == null) {
            InspectionValidator.$$$reportNull$$$0(1);
        }
        if (progressIndicatorText == null) {
            InspectionValidator.$$$reportNull$$$0(2);
        }
        this.myId = id;
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = null;
        this.myInspectionToolProvider = null;
    }

    public abstract boolean isAvailableOnScope(@NotNull CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        List list = Collections.emptyList();
        if (list == null) {
            InspectionValidator.$$$reportNull$$$0(3);
        }
        return list;
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        if (this.myInspectionToolClasses != null) {
            if (this.myInspectionToolClasses == null) {
                InspectionValidator.$$$reportNull$$$0(4);
            }
            return this.myInspectionToolClasses;
        }
        assert (this.myInspectionToolProvider != null) : "getInspectionToolClasses() must be overridden";
        Class[] classArray = this.myInspectionToolProvider.getInspectionClasses();
        if (classArray == null) {
            InspectionValidator.$$$reportNull$$$0(5);
        }
        return classArray;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            InspectionValidator.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public final String getDescription() {
        return this.myDescription;
    }

    @NlsContexts.ProgressText
    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        if (severity == null) {
            InspectionValidator.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            InspectionValidator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            InspectionValidator.$$$reportNull$$$0(9);
        }
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile file) {
        Map<ProblemDescriptor, HighlightDisplayLevel> map = Collections.emptyMap();
        if (map == null) {
            InspectionValidator.$$$reportNull$$$0(10);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAdditionally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryByHighlightDisplayLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

