/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactType {
    public static final ExtensionPointName<ArtifactType> EP_NAME = new ExtensionPointName("com.intellij.packaging.artifactType");
    private final String myId;
    private final Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> myTitle;

    protected ArtifactType(@NonNls String id, Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> title) {
        this.myId = id;
        this.myTitle = title;
    }

    @NonNls
    public final String getId() {
        return this.myId;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getPresentableName() {
        return this.myTitle.get();
    }

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            ArtifactType.$$$reportNull$$$0(0);
        }
        return this.getDefaultPathFor(sourceItem.getKindOfProducedElements());
    }

    @Nullable
    @NlsSafe
    public abstract String getDefaultPathFor(@NotNull PackagingElementOutputKind var1);

    public boolean isSuitableItem(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            ArtifactType.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    public static List<ArtifactType> getAllTypes() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            ArtifactType.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static ArtifactType findById(@NotNull @NonNls String id) {
        if (id == null) {
            ArtifactType.$$$reportNull$$$0(3);
        }
        for (ArtifactType type : EP_NAME.getIterable()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public abstract CompositePackagingElement<?> createRootElement(@NotNull String var1);

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            ArtifactType.$$$reportNull$$$0(4);
        }
        List list = Collections.emptyList();
        if (list == null) {
            ArtifactType.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            ArtifactType.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            ArtifactType.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            ArtifactType.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public List<? extends PackagingElement<?>> getSubstitution(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType parentType) {
        if (artifact == null) {
            ArtifactType.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ArtifactType.$$$reportNull$$$0(10);
        }
        if (parentType == null) {
            ArtifactType.$$$reportNull$$$0(11);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceItem";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/artifacts/ArtifactType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/artifacts/ArtifactType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewArtifactTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableItem";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNewArtifactTemplates";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRootElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

