/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.fix;

import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/fix/GradleWrapperVersionFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "newGradleVersion", "Lorg/gradle/util/GradleVersion;", "versionTextRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lorg/gradle/util/GradleVersion;Lcom/intellij/openapi/util/TextRange;)V", "getName", "", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.gradle.java"})
public final class GradleWrapperVersionFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final GradleVersion newGradleVersion;
    @NotNull
    private final TextRange versionTextRange;

    public GradleWrapperVersionFix(@NotNull GradleVersion newGradleVersion, @NotNull TextRange versionTextRange) {
        Intrinsics.checkNotNullParameter((Object)newGradleVersion, (String)"newGradleVersion");
        Intrinsics.checkNotNullParameter((Object)versionTextRange, (String)"versionTextRange");
        this.newGradleVersion = newGradleVersion;
        this.versionTextRange = versionTextRange;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.newGradleVersion.getVersion()};
        String string = GradleInspectionBundle.message("intention.name.upgrade.gradle.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GradleInspectionBundle.message("intention.family.name.upgrade", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Property property = (Property)element;
        String string = property.getValue();
        if (string == null) {
            return;
        }
        String oldDistributionUrl = string;
        String string2 = property.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        int offset = StringsKt.indexOf$default((CharSequence)string2, (String)oldDistributionUrl, (int)0, (boolean)false, (int)6, null);
        String string3 = oldDistributionUrl;
        int n = this.versionTextRange.getStartOffset() - offset;
        int n2 = this.versionTextRange.getEndOffset() - offset;
        String string4 = this.newGradleVersion.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getVersion(...)");
        CharSequence charSequence = string4;
        String newDistributionUrl = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        property.setValue(newDistributionUrl, PropertyKeyValueFormat.FILE);
    }
}

