/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectMembersContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "<init>", "()V", "unwrapMultiprocessor", "", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.gradle.java"})
public final class GradleProjectMembersContributor
extends NonCodeMembersContributor {
    protected boolean unwrapMultiprocessor() {
        return false;
    }

    @NotNull
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PsiClassType psiClassType = TypesUtil.createType((String)"org.gradle.api.tasks.TaskContainer", (PsiElement)place);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
        PsiClassType taskContainer = psiClassType;
        PsiClassType delegate = qualifierType instanceof GradleProjectAwareType ? (PsiClassType)((GradleProjectAwareType)qualifierType).setType(taskContainer) : taskContainer;
        PsiType psiType = (PsiType)delegate;
        ResolveState resolveState = state.put(UtilKt.getDELEGATED_TYPE(), (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"put(...)");
        if (!ReceiverKt.processReceiverType((PsiType)psiType, (PsiScopeProcessor)processor, (ResolveState)resolveState, (PsiElement)place)) {
            return;
        }
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        PsiFile psiFile = place.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)file);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData extensionsData = gradleExtensionsData;
        for (GradleExtensionsSettings.GradleConvention convention : extensionsData.conventions) {
            if (ReceiverKt.processReceiverType((PsiType)((PsiType)TypesUtil.createType((String)convention.getTypeFqn(), (PsiElement)((PsiElement)file))), (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)place)) continue;
            return;
        }
    }
}

