/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.toml;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.jetbrains.plugins.gradle.service.resolve.VersionCatalogsLocator;
import org.jetbrains.plugins.gradle.toml.DependencyCoordinates;
import org.jetbrains.plugins.gradle.toml.PluginCoordinates;
import org.jetbrains.plugins.gradle.toml.TomlHeaderKind;
import org.jetbrains.plugins.gradle.toml.TomlVersionCatalogVisitor;
import org.jetbrains.plugins.gradle.util.VersionCatalogsKt;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlHeaderOwner;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlKeyValueOwner;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.ext.TomlKeyKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\u0006H\u0000\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u001a\f\u0010\u001f\u001a\u00020 *\u00020 H\u0002\u001a\f\u0010!\u001a\u00020 *\u00020 H\u0002\u001a\u0018\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020'\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0018\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u00100\u001a\u00020'H\u0002\u001a\f\u00101\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u000e\u00102\u001a\u0004\u0018\u000103*\u00020*H\u0002\u001a\u000e\u00102\u001a\u0004\u0018\u000103*\u00020\u0006H\u0002\"\u000e\u00104\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00105\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00106\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00107\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00108\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00109\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010:\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"getTableEntries", "", "Lorg/toml/lang/psi/TomlKeySegment;", "context", "Lcom/intellij/psi/PsiElement;", "tableName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getVersions", "getLibraries", "getVersionCatalogParts", "findTomlFile", "Lorg/toml/lang/psi/TomlFile;", "name", "findTomlFileDynamically", "Lcom/intellij/openapi/vfs/VirtualFile;", "findTomlCatalogKey", "tomlFile", "declarationPath", "findAlias", "valueOwner", "Lorg/toml/lang/psi/TomlKeyValueOwner;", "target", "keysMatch", "", "keyText", "reference", "isAfterDelimiter", "index", "", "s", "normalizeIgnoreCase", "", "normalize", "findOriginInTomlFile", "method", "Lcom/intellij/psi/PsiMethod;", "getTomlParentSectionName", "tomlKeyValue", "Lorg/toml/lang/psi/TomlKeyValue;", "getVersionCatalogName", "psiClass", "Lcom/intellij/psi/PsiClass;", "getResolvedDependency", "Lorg/jetbrains/plugins/gradle/toml/DependencyCoordinates;", "getResolvedPlugin", "Lorg/jetbrains/plugins/gradle/toml/PluginCoordinates;", "getResolvedVersion", "entry", "cleanRawString", "getTomlHeaderKind", "Lorg/jetbrains/plugins/gradle/toml/TomlHeaderKind;", "TOML_TABLE_VERSIONS", "TOML_TABLE_LIBRARIES", "TOML_TABLE_BUNDLES", "TOML_TABLE_PLUGINS", "METHOD_GET_PLUGINS", "METHOD_GET_VERSIONS", "METHOD_GET_BUNDLES", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/plugins/gradle/toml/UtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,390:1\n18#2:391\n18#2:409\n18#2:417\n18#2:418\n18#2:421\n18#2:422\n455#3:392\n455#3:394\n455#3:419\n455#3:420\n1#4:393\n1#4:406\n1642#5,10:395\n1915#5:405\n1916#5:407\n1652#5:408\n2792#5,3:412\n30#6,2:410\n14060#7,2:415\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/jetbrains/plugins/gradle/toml/UtilKt\n*L\n42#1:391\n56#1:409\n184#1:417\n290#1:418\n293#1:421\n301#1:422\n43#1:392\n44#1:394\n291#1:419\n292#1:420\n44#1:406\n44#1:395,10\n44#1:405\n44#1:407\n44#1:408\n77#1:412,3\n63#1:410,2\n87#1:415,2\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final String TOML_TABLE_VERSIONS = "versions";
    @NotNull
    private static final String TOML_TABLE_LIBRARIES = "libraries";
    @NotNull
    private static final String TOML_TABLE_BUNDLES = "bundles";
    @NotNull
    private static final String TOML_TABLE_PLUGINS = "plugins";
    @NotNull
    private static final String METHOD_GET_PLUGINS = "getPlugins";
    @NotNull
    private static final String METHOD_GET_VERSIONS = "getVersions";
    @NotNull
    private static final String METHOD_GET_BUNDLES = "getBundles";

    /*
     * WARNING - void declaration
     */
    private static final List<TomlKeySegment> getTableEntries(PsiElement context, String tableName) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object v4;
        Iterable $i$f$childrenOfType22;
        block5: {
            PsiFile $this$asSafely$iv = context.getContainingFile();
            boolean $i$f$asSafely = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof TomlFile)) {
                psiFile = null;
            }
            TomlFile tomlFile = (TomlFile)psiFile;
            if (tomlFile == null) {
                return CollectionsKt.emptyList();
            }
            TomlFile file = tomlFile;
            PsiElement $this$childrenOfType$iv = (PsiElement)file;
            boolean $i$f$childrenOfType22 = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlTable.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            $i$f$childrenOfType22 = list;
            for (Object t : $i$f$childrenOfType22) {
                TomlTable it = (TomlTable)t;
                boolean bl = false;
                TomlKey tomlKey = it.getHeader().getKey();
                if (!Intrinsics.areEqual((Object)(tomlKey != null ? TomlKeyKt.getName((TomlKey)tomlKey) : null), (Object)tableName)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        TomlTable tomlTable = v4;
        if (tomlTable == null) {
            return CollectionsKt.emptyList();
        }
        TomlTable targetTable = tomlTable;
        Object $this$childrenOfType$iv = (PsiElement)targetTable;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlKeyValue.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        $this$childrenOfType$iv = list;
        boolean $i$f$mapNotNull = false;
        $i$f$childrenOfType22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TomlKeySegment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TomlKeyValue it = (TomlKeyValue)element$iv$iv;
            boolean bl2 = false;
            if ((TomlKeySegment)CollectionsKt.singleOrNull((List)it.getKey().getSegments()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<TomlKeySegment> getVersions(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UtilKt.getTableEntries(context, TOML_TABLE_VERSIONS);
    }

    @NotNull
    public static final List<TomlKeySegment> getLibraries(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UtilKt.getTableEntries(context, TOML_TABLE_LIBRARIES);
    }

    @NotNull
    public static final List<String> getVersionCatalogParts(@NotNull String $this$getVersionCatalogParts) {
        Intrinsics.checkNotNullParameter((Object)$this$getVersionCatalogParts, (String)"<this>");
        String[] stringArray = new String[]{"_", "-"};
        return StringsKt.split$default((CharSequence)$this$getVersionCatalogParts, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @Nullable
    public static final TomlFile findTomlFile(@NotNull PsiElement context, @NotNull String name) {
        TomlFile tomlFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        VirtualFile virtualFile = GradleVersionCatalogHandlerKt.getVersionCatalogFiles(module2).get(name);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = context.getManager().findFile(file);
        if (psiFile != null) {
            PsiFile $this$asSafely$iv = psiFile;
            boolean $i$f$asSafely = false;
            PsiFile psiFile2 = $this$asSafely$iv;
            if (!(psiFile2 instanceof TomlFile)) {
                psiFile2 = null;
            }
            tomlFile = (TomlFile)psiFile2;
        } else {
            tomlFile = null;
        }
        return tomlFile;
    }

    private static final VirtualFile findTomlFileDynamically(PsiElement context, String name) {
        PsiFile psiFile;
        block6: {
            block5: {
                psiFile = context.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) break block5;
                PsiFile it = psiFile;
                boolean bl = false;
                Module module = ProjectFileIndex.getInstance((Project)context.getProject()).getModuleForFile((VirtualFile)it);
                psiFile = module;
                if (module != null) break block6;
            }
            return null;
        }
        PsiFile module = psiFile;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VersionCatalogsLocator> serviceClass$iv = VersionCatalogsLocator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Path path = (Path)((VersionCatalogsLocator)object).getVersionCatalogsForModule((Module)module).get(name);
        if (path == null) {
            return null;
        }
        Path tomlPath = path;
        return VfsUtil.findFile((Path)tomlPath, (boolean)false);
    }

    @Nullable
    public static final PsiElement findTomlCatalogKey(@NotNull TomlFile tomlFile, @NotNull String declarationPath) {
        boolean bl;
        String target;
        String section;
        block9: {
            Intrinsics.checkNotNullParameter((Object)tomlFile, (String)"tomlFile");
            Intrinsics.checkNotNullParameter((Object)declarationPath, (String)"declarationPath");
            Object[] objectArray = new String[]{"versions.", "bundles.", "plugins."};
            List prefix = CollectionsKt.listOf((Object[])objectArray);
            section = null;
            target = null;
            Iterable $this$none$iv = prefix;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)declarationPath, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            section = TOML_TABLE_LIBRARIES;
            target = declarationPath;
        } else {
            section = StringsKt.substringBefore$default((String)declarationPath, (char)'.', null, (int)2, null);
            target = StringsKt.substringAfter$default((String)declarationPath, (char)'.', null, (int)2, null);
        }
        PsiElement[] psiElementArray = tomlFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$forEach$iv = psiElementArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String keyText;
            PsiElement element = (PsiElement)element$iv;
            boolean bl3 = false;
            if (element instanceof TomlHeaderOwner) {
                TomlKey tomlKey = ((TomlHeaderOwner)element).getHeader().getKey();
                String string = keyText = tomlKey != null ? tomlKey.getText() : null;
                if (UtilKt.keysMatch(keyText, section) && element instanceof TomlKeyValueOwner) {
                    return UtilKt.findAlias((TomlKeyValueOwner)element, target);
                }
            }
            if (!(element instanceof TomlKeyValue)) continue;
            keyText = ((TomlKeyValue)element).getKey().getText();
            if (UtilKt.keysMatch(keyText, section + "." + target)) {
                return element;
            }
            if (!(((TomlKeyValue)element).getValue() instanceof TomlInlineTable) || !UtilKt.keysMatch(keyText, section)) continue;
            TomlValue tomlValue = ((TomlKeyValue)element).getValue();
            Intrinsics.checkNotNull((Object)tomlValue, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlInlineTable");
            return UtilKt.findAlias((TomlKeyValueOwner)((TomlInlineTable)tomlValue), target);
        }
        return null;
    }

    private static final PsiElement findAlias(TomlKeyValueOwner valueOwner, String target) {
        for (TomlKeyValue entry : valueOwner.getEntries()) {
            String entryKeyText = entry.getKey().getText();
            if (!UtilKt.keysMatch(entryKeyText, target)) continue;
            return (PsiElement)entry;
        }
        return null;
    }

    public static final boolean keysMatch(@Nullable String keyText, @NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (keyText == null) {
            return false;
        }
        if (keyText.length() != reference.length()) {
            return false;
        }
        int n = ((CharSequence)keyText).length();
        for (int i = 0; i < n; ++i) {
            if (!(UtilKt.isAfterDelimiter(i, keyText) ? UtilKt.normalizeIgnoreCase(keyText.charAt(i)) != UtilKt.normalize(reference.charAt(i)) : UtilKt.normalize(keyText.charAt(i)) != UtilKt.normalize(reference.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isAfterDelimiter(int index, String s) {
        return index > 0 && UtilKt.normalize(s.charAt(index - 1)) == '.';
    }

    private static final char normalizeIgnoreCase(char $this$normalizeIgnoreCase) {
        switch ($this$normalizeIgnoreCase) {
            case '-': 
            case '_': {
                return '.';
            }
        }
        return Character.toLowerCase($this$normalizeIgnoreCase);
    }

    private static final char normalize(char $this$normalize) {
        switch ($this$normalize) {
            case '-': 
            case '_': {
                return '.';
            }
        }
        return $this$normalize;
    }

    @Nullable
    public static final PsiElement findOriginInTomlFile(@NotNull PsiMethod method, @NotNull PsiElement context) {
        TomlFile tomlFile;
        List containingClasses;
        block5: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object[] objectArray = new PsiClass[1];
            if (method.getContainingClass() == null) {
                PsiClass cfr_ignored_0 = objectArray[0];
                return null;
            }
            containingClasses = CollectionsKt.mutableListOf((Object[])objectArray);
            while (((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass() != null) {
                PsiClass psiClass = ((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass);
                containingClasses.add(psiClass);
            }
            CollectionsKt.reverse((List)containingClasses);
            String string = UtilKt.getVersionCatalogName((PsiClass)CollectionsKt.first((List)containingClasses));
            if (string == null) {
                return null;
            }
            String name = string;
            Object[] objectArray2 = new String[]{StringUtil.decapitalize((String)name), name};
            for (String it : (Iterable)CollectionsKt.listOf((Object[])objectArray2)) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                TomlFile tomlFile2 = UtilKt.findTomlFile(context, it);
                if (tomlFile2 == null) continue;
                tomlFile = tomlFile2;
                break block5;
            }
            tomlFile = null;
        }
        if (tomlFile == null) {
            return null;
        }
        TomlFile toml = tomlFile;
        TomlVersionCatalogVisitor tomlVisitor = new TomlVersionCatalogVisitor(com.intellij.util.containers.UtilKt.tail((List)containingClasses), method);
        toml.accept((PsiElementVisitor)tomlVisitor);
        return tomlVisitor.getResolveTarget();
    }

    @Nullable
    public static final String getTomlParentSectionName(@NotNull TomlKeyValue tomlKeyValue) {
        PsiElement psiElement;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tomlKeyValue, (String)"tomlKeyValue");
                psiElement = tomlKeyValue.getParent();
                if (psiElement == null) break block4;
                PsiElement $this$asSafely$iv = psiElement;
                boolean $i$f$asSafely = false;
                PsiElement psiElement2 = $this$asSafely$iv;
                if (!(psiElement2 instanceof TomlTable)) {
                    psiElement2 = null;
                }
                if ((psiElement = (TomlTable)psiElement2) != null) break block5;
            }
            return null;
        }
        PsiElement parentTable = psiElement;
        TomlKey tomlKey = parentTable.getHeader().getKey();
        return tomlKey != null ? TomlKeyKt.getName((TomlKey)tomlKey) : null;
    }

    private static final String getVersionCatalogName(PsiClass psiClass) {
        String string = psiClass.getName();
        if (string == null || (string = StringsKt.substringAfter$default((String)string, (String)"LibrariesFor", null, (int)2, null)) == null) {
            return null;
        }
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)"InPluginsBlock", (boolean)false, (int)2, null)) {
            return StringsKt.substringBefore$default((String)name, (String)"InPluginsBlock", null, (int)2, null);
        }
        return name;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Nullable
    public static final DependencyCoordinates getResolvedDependency(@NotNull PsiMethod method, @NotNull PsiElement context) {
        block23: {
            block24: {
                block21: {
                    block26: {
                        block20: {
                            block19: {
                                block25: {
                                    block18: {
                                        block22: {
                                            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                            if (!VersionCatalogsKt.isInVersionCatalogAccessor(method)) {
                                                return null;
                                            }
                                            var4_2 = UtilKt.findOriginInTomlFile(method, context);
                                            v0 = var4_2 instanceof TomlKeyValue != false ? (TomlKeyValue)var4_2 : null;
                                            if (v0 == null) {
                                                return null;
                                            }
                                            origin = v0;
                                            originValue = origin.getValue();
                                            if (!(originValue instanceof TomlLiteral)) break block22;
                                            v1 = ((TomlLiteral)originValue).getText();
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                                            v2 = DependencyCoordinates.Companion.from(UtilKt.cleanRawString(v1));
                                            break block23;
                                        }
                                        if (!(originValue instanceof TomlInlineTable)) break block24;
                                        var7_5 = ((TomlInlineTable)originValue).getEntries();
                                        for (T var9_7 : var7_5) {
                                            it = (TomlKeyValue)var9_7;
                                            $i$a$-find-UtilKt$getResolvedDependency$module$1 = false;
                                            if (it.getKey().getSegments().size() != 1) ** GOTO lbl-1000
                                            v3 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                                            if (Intrinsics.areEqual((Object)(v3 != null ? v3.getName() : null), (Object)"module")) {
                                                v4 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v4 = false;
                                            }
                                            if (!v4) continue;
                                            v5 = var9_7;
                                            break block18;
                                        }
                                        v5 = null;
                                    }
                                    v6 = v5;
                                    v7 /* !! */  = module = v6 != null ? v6.getValue() : null;
                                    if (module == null) break block25;
                                    if (!(module instanceof TomlLiteral)) {
                                        return null;
                                    }
                                    v8 = ((TomlLiteral)module).getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getText(...)");
                                    var7_5 = new char[1];
                                    var7_5[0] = 58;
                                    it = var7_5 = StringsKt.split$default((CharSequence)UtilKt.cleanRawString(v8), (char[])var7_5, (boolean)false, (int)0, (int)6, null);
                                    $i$a$-takeIf-UtilKt$getResolvedDependency$1 = false;
                                    v9 /* !! */  = it.size() == 2 != false ? var7_5 : null;
                                    if (v9 /* !! */  == null) {
                                        return null;
                                    }
                                    break block26;
                                }
                                $i$a$-takeIf-UtilKt$getResolvedDependency$1 = ((TomlInlineTable)originValue).getEntries();
                                for (T var11_12 : $i$a$-takeIf-UtilKt$getResolvedDependency$1) {
                                    it = (TomlKeyValue)var11_12;
                                    $i$a$-find-UtilKt$getResolvedDependency$group$1 = false;
                                    if (it.getKey().getSegments().size() != 1) ** GOTO lbl-1000
                                    v10 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                                    if (Intrinsics.areEqual((Object)(v10 != null ? v10.getName() : null), (Object)"group")) {
                                        v11 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v11 = false;
                                    }
                                    if (!v11) continue;
                                    v12 = var11_12;
                                    break block19;
                                }
                                v12 = null;
                            }
                            v13 = v12;
                            group = v13 != null ? v13.getValue() : null;
                            var10_10 = ((TomlInlineTable)originValue).getEntries();
                            var11_13 = var10_10.iterator();
                            while (var11_13.hasNext()) {
                                var12_15 = var11_13.next();
                                it = (TomlKeyValue)var12_15;
                                $i$a$-find-UtilKt$getResolvedDependency$name$1 = false;
                                if (it.getKey().getSegments().size() != 1) ** GOTO lbl-1000
                                v14 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                                if (Intrinsics.areEqual((Object)(v14 != null ? v14.getName() : null), (Object)"name")) {
                                    v15 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v15 = false;
                                }
                                if (!v15) continue;
                                v16 = var12_15;
                                break block20;
                            }
                            v16 = null;
                        }
                        v17 = v16;
                        v18 /* !! */  = name = v17 != null ? v17.getValue() : null;
                        if (group == null || name == null) {
                            return null;
                        }
                        if (!(group instanceof TomlLiteral) || !(name instanceof TomlLiteral)) {
                            return null;
                        }
                        it = new String[2];
                        v19 = ((TomlLiteral)group).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getText(...)");
                        it[0] = UtilKt.cleanRawString(v19);
                        v20 = ((TomlLiteral)name).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"getText(...)");
                        it[1] = UtilKt.cleanRawString(v20);
                        v9 /* !! */  = CollectionsKt.listOf((Object[])it);
                    }
                    var5_22 = v9 /* !! */ ;
                    groupText = (String)var5_22.get(0);
                    nameText = (String)var5_22.get(1);
                    var11_14 = ((TomlInlineTable)originValue).getEntries();
                    for (E var13_18 : var11_14) {
                        it = (TomlKeyValue)var13_18;
                        $i$a$-find-UtilKt$getResolvedDependency$versionEntry$1 = false;
                        v21 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                        if (!Intrinsics.areEqual((Object)(v21 != null ? v21.getName() : null), (Object)"version")) continue;
                        v22 = var13_18;
                        break block21;
                    }
                    v22 = null;
                }
                v23 = v22;
                if (v23 == null) {
                    return new DependencyCoordinates(groupText, nameText, null);
                }
                versionEntry = v23;
                v24 = UtilKt.getResolvedVersion(versionEntry);
                if (v24 == null) {
                    return new DependencyCoordinates(groupText, nameText, null);
                }
                versionText = v24;
                v2 = new DependencyCoordinates(groupText, nameText, versionText);
                break block23;
            }
            return null;
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final PluginCoordinates getResolvedPlugin(@NotNull PsiMethod method, @NotNull PsiElement context) {
        block13: {
            block14: {
                block11: {
                    block10: {
                        block12: {
                            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            if (!VersionCatalogsKt.isInVersionCatalogAccessor(method)) {
                                return null;
                            }
                            var4_2 = UtilKt.findOriginInTomlFile(method, context);
                            v0 = var4_2 instanceof TomlKeyValue != false ? (TomlKeyValue)var4_2 : null;
                            if (v0 == null) {
                                return null;
                            }
                            origin = v0;
                            originValue = origin.getValue();
                            if (!(originValue instanceof TomlLiteral)) break block12;
                            v1 = ((TomlLiteral)originValue).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                            v2 = PluginCoordinates.Companion.from(UtilKt.cleanRawString(v1));
                            break block13;
                        }
                        if (!(originValue instanceof TomlInlineTable)) break block14;
                        var7_5 = ((TomlInlineTable)originValue).getEntries();
                        for (Object var9_7 : var7_5) {
                            it = (TomlKeyValue)var9_7;
                            $i$a$-find-UtilKt$getResolvedPlugin$id$1 = false;
                            if (it.getKey().getSegments().size() != 1) ** GOTO lbl-1000
                            v3 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                            if (Intrinsics.areEqual((Object)(v3 != null ? v3.getName() : null), (Object)"id")) {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            v5 = var9_7;
                            break block10;
                        }
                        v5 = null;
                    }
                    v6 = v5;
                    v7 /* !! */  = id = v6 != null ? v6.getValue() : null;
                    if (id == null) {
                        return null;
                    }
                    if (!(id instanceof TomlLiteral)) {
                        return null;
                    }
                    v8 = ((TomlLiteral)id).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getText(...)");
                    idText = UtilKt.cleanRawString(v8);
                    var9_7 = ((TomlInlineTable)originValue).getEntries();
                    var10_8 = var9_7.iterator();
                    while (var10_8.hasNext()) {
                        var11_10 = var10_8.next();
                        it = (TomlKeyValue)var11_10;
                        $i$a$-find-UtilKt$getResolvedPlugin$versionEntry$1 = false;
                        v9 = (TomlKeySegment)CollectionsKt.firstOrNull((List)it.getKey().getSegments());
                        if (!Intrinsics.areEqual((Object)(v9 != null ? v9.getName() : null), (Object)"version")) continue;
                        v10 = var11_10;
                        break block11;
                    }
                    v10 = null;
                }
                v11 = v10;
                if (v11 == null) {
                    return new PluginCoordinates(idText, null);
                }
                versionEntry = v11;
                v12 = UtilKt.getResolvedVersion(versionEntry);
                if (v12 == null) {
                    return new PluginCoordinates(idText, null);
                }
                versionText = v12;
                v2 = new PluginCoordinates(idText, versionText);
                break block13;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getResolvedVersion(TomlKeyValue entry) {
        TomlKeyValue finalVersionKeyValue;
        TomlKeyValue tomlKeyValue;
        TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.firstOrNull((List)entry.getKey().getSegments());
        if (!Intrinsics.areEqual((Object)(tomlKeySegment != null ? tomlKeySegment.getName() : null), (Object)"version")) {
            return null;
        }
        int n = entry.getKey().getSegments().size();
        if (n == 1) {
            tomlKeyValue = entry;
        } else {
            Object v14;
            block12: {
                Object v6;
                Object object2;
                block11: {
                    if (n != 2) return null;
                    if (!Intrinsics.areEqual((Object)((TomlKeySegment)entry.getKey().getSegments().get(1)).getName(), (Object)"ref")) return null;
                    PsiFile $this$asSafely$iv = entry.getContainingFile();
                    boolean bl = false;
                    PsiFile psiFile = $this$asSafely$iv;
                    if (!(psiFile instanceof TomlFile)) {
                        psiFile = null;
                    }
                    TomlFile tomlFile = (TomlFile)psiFile;
                    if (tomlFile == null) {
                        return null;
                    }
                    TomlFile file = tomlFile;
                    PsiElement psiElement = (PsiElement)file;
                    boolean $i$f$childrenOfType22 = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiElement, TomlTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    Iterable $i$f$childrenOfType22 = list;
                    for (Object object2 : $i$f$childrenOfType22) {
                        TomlTable it = (TomlTable)object2;
                        boolean bl2 = false;
                        TomlKey tomlKey = it.getHeader().getKey();
                        if (!Intrinsics.areEqual((Object)(tomlKey != null ? TomlKeyKt.getName((TomlKey)tomlKey) : null), (Object)TOML_TABLE_VERSIONS)) continue;
                        v6 = object2;
                        break block11;
                    }
                    v6 = null;
                }
                TomlTable tomlTable = v6;
                if (tomlTable == null) {
                    return null;
                }
                TomlTable versionTable = tomlTable;
                PsiElement psiElement = (PsiElement)versionTable;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiElement, TomlKeyValue.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                List entries = list;
                TomlValue tomlValue = entry.getValue();
                Object object3 = tomlValue;
                if (tomlValue == null) return null;
                TomlValue $this$asSafely$iv = object3;
                boolean $i$f$asSafely = false;
                TomlValue tomlValue2 = $this$asSafely$iv;
                if (!(tomlValue2 instanceof TomlLiteral)) {
                    tomlValue2 = null;
                }
                TomlLiteral tomlLiteral = (TomlLiteral)tomlValue2;
                object3 = tomlLiteral;
                if (tomlLiteral == null) return null;
                String string = object3.getText();
                object3 = string;
                if (string == null) return null;
                if ((object3 = UtilKt.cleanRawString((String)object3)) == null) {
                    return null;
                }
                Object object4 = object3;
                Iterable iterable = entries;
                object2 = iterable.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    TomlKeyValue it = (TomlKeyValue)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey().getText(), (Object)object4)) continue;
                    v14 = e;
                    break block12;
                }
                v14 = null;
            }
            tomlKeyValue = v14;
        }
        TomlKeyValue tomlKeyValue2 = finalVersionKeyValue = tomlKeyValue;
        Object object = tomlKeyValue2;
        if (tomlKeyValue2 == null) return null;
        TomlValue tomlValue = object.getValue();
        object = tomlValue;
        if (tomlValue == null) return null;
        TomlKeyValue $this$asSafely$iv = object;
        boolean $i$f$asSafely = false;
        TomlKeyValue tomlKeyValue3 = $this$asSafely$iv;
        if (!(tomlKeyValue3 instanceof TomlLiteral)) {
            tomlKeyValue3 = null;
        }
        TomlLiteral tomlLiteral = (TomlLiteral)tomlKeyValue3;
        object = tomlLiteral;
        if (tomlLiteral == null) return null;
        String string = object.getText();
        object = string;
        if (string == null) return null;
        String string2 = UtilKt.cleanRawString((String)object);
        return string2;
    }

    private static final String cleanRawString(String $this$cleanRawString) {
        char[] cArray = new char[]{'\"', '\''};
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.trim((String)$this$cleanRawString, (char[])cArray), (String)"\r", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private static final TomlHeaderKind getTomlHeaderKind(PsiClass $this$getTomlHeaderKind) {
        String string = $this$getTomlHeaderKind.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"VersionAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.VERSIONS : (StringsKt.endsWith$default((String)name, (String)"BundleAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.BUNDLES : (StringsKt.endsWith$default((String)name, (String)"PluginAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.PLUGINS : (StringsKt.endsWith$default((String)name, (String)"LibraryAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.LIBRARIES : null)));
    }

    private static final TomlHeaderKind getTomlHeaderKind(String $this$getTomlHeaderKind) {
        return switch ($this$getTomlHeaderKind) {
            case TOML_TABLE_VERSIONS -> TomlHeaderKind.VERSIONS;
            case TOML_TABLE_LIBRARIES -> TomlHeaderKind.LIBRARIES;
            case TOML_TABLE_BUNDLES -> TomlHeaderKind.BUNDLES;
            case TOML_TABLE_PLUGINS -> TomlHeaderKind.PLUGINS;
            default -> null;
        };
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(String $receiver) {
        return UtilKt.getTomlHeaderKind($receiver);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(PsiClass $receiver) {
        return UtilKt.getTomlHeaderKind($receiver);
    }
}

