/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.yaml.structure.logical;

import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.liquibase.core.structure.model.LiquibaseFileLogicalModel;
import com.intellij.liquibase.core.structure.model.LiquibaseTagLogicalModel;
import com.intellij.liquibase.yaml.structure.logical.LiquibaseYamlTagLogicalModel;
import com.intellij.liquibase.yaml.structure.logical.LiquibaseYamlUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/liquibase/yaml/structure/logical/LiquibaseYamlFileLogicalModel;", "Lcom/intellij/liquibase/core/structure/model/LiquibaseFileLogicalModel;", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "<init>", "(Lorg/jetbrains/yaml/psi/YAMLFile;)V", "getYamlFile", "()Lorg/jetbrains/yaml/psi/YAMLFile;", "getElements", "", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getProperties", "", "Lcom/intellij/liquibase/core/structure/model/LiquibaseTagLogicalModel;", "getIncludes", "Lcom/intellij/liquibase/core/structure/model/LiquibaseFileLogicalModel$IncludeInfo;", "getChanges", "getAbsolutePath", "", "pathString", "yamlPsiElement", "intellij.liquibase.yaml"})
@SourceDebugExtension(value={"SMAP\nLiquibaseYamlFileLogicalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseYamlFileLogicalModel.kt\ncom/intellij/liquibase/yaml/structure/logical/LiquibaseYamlFileLogicalModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class LiquibaseYamlFileLogicalModel
extends LiquibaseFileLogicalModel {
    public LiquibaseYamlFileLogicalModel(@NotNull YAMLFile yamlFile) {
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        super((PsiFile)yamlFile);
    }

    private final YAMLFile getYamlFile() {
        PsiElement psiElement = this.getNavigationElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLFile");
        return (YAMLFile)psiElement;
    }

    private final Collection<YAMLPsiElement> getElements() {
        YAMLPsiElement yAMLPsiElement;
        List list = this.getYamlFile().getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
        YAMLDocument yAMLDocument = (YAMLDocument)CollectionsKt.firstOrNull((List)list);
        if (yAMLDocument != null) {
            YAMLDocument it = yAMLDocument;
            boolean bl = false;
            yAMLPsiElement = LiquibaseYamlUtilsKt.getKeyValue((YAMLPsiElement)it, "databaseChangeLog");
        } else {
            yAMLPsiElement = null;
        }
        YAMLPsiElement yAMLPsiElement2 = yAMLPsiElement;
        YAMLSequence yAMLSequence = yAMLPsiElement2 instanceof YAMLSequence ? (YAMLSequence)yAMLPsiElement2 : null;
        if (yAMLSequence == null) {
            return CollectionsKt.emptyList();
        }
        YAMLSequence changeLogValue = yAMLSequence;
        return LiquibaseYamlUtilsKt.getSequenceElements(changeLogValue);
    }

    @NotNull
    public List<LiquibaseTagLogicalModel> getProperties() {
        List result = new ArrayList();
        for (YAMLPsiElement element : this.getElements()) {
            if (!Intrinsics.areEqual((Object)element.getName(), (Object)"property")) continue;
            result.add(new LiquibaseYamlTagLogicalModel(element, null));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<LiquibaseFileLogicalModel.IncludeInfo> getIncludes() {
        List result = new ArrayList();
        Project project = this.getYamlFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SearchHelper searchHelper = SearchHelper.getInstance((Project)project2);
        for (YAMLPsiElement element : this.getElements()) {
            Object object;
            String string;
            PsiElement psiElement;
            List list;
            block7: {
                block6: {
                    void it;
                    String path;
                    String pathValue;
                    String tagName = element.getName();
                    if (Intrinsics.areEqual((Object)"includeAll", (Object)tagName)) {
                        PsiFile[] directory;
                        if (LiquibaseYamlUtilsKt.getKeyValueText(element, "path") == null) continue;
                        path = this.getAbsolutePath(pathValue, element);
                        Object object2 = directory = searchHelper.findDirectory(path, GlobalSearchScope.allScope((Project)project2));
                        if (directory == null || (object2 = object2.getFiles()) == null || (object2 = ArraysKt.toList((Object[])object2)) == null) {
                            object2 = CollectionsKt.emptyList();
                        }
                        Object[] files = object2;
                        result.add(new LiquibaseFileLogicalModel.IncludeInfo((PsiElement)element, pathValue, (List)files, true));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)"include", (Object)tagName) || LiquibaseYamlUtilsKt.getKeyValueText(element, "file") == null) continue;
                    path = this.getAbsolutePath(pathValue, element);
                    PsiFile file = searchHelper.findFile(path, PsiFile.class, false);
                    list = result;
                    psiElement = (PsiElement)element;
                    string = pathValue;
                    object = file;
                    if (object == null) break block6;
                    PsiFile psiFile = object;
                    String string2 = string;
                    PsiElement psiElement2 = psiElement;
                    List list2 = list;
                    boolean bl = false;
                    List list3 = CollectionsKt.listOf((Object)it);
                    list = list2;
                    psiElement = psiElement2;
                    string = string2;
                    List list4 = list3;
                    object = list4;
                    if (list4 != null) break block7;
                }
                object = CollectionsKt.emptyList();
            }
            boolean bl = false;
            Object object3 = object;
            String string3 = string;
            PsiElement psiElement3 = psiElement;
            list.add(new LiquibaseFileLogicalModel.IncludeInfo(psiElement3, string3, (List)object3, bl));
        }
        return result;
    }

    @NotNull
    public List<LiquibaseTagLogicalModel> getChanges() {
        List result = new ArrayList();
        Iterator<YAMLPsiElement> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = new String[]{"includeAll", "include", "property"};
            YAMLPsiElement element = iterator.next();
            String tagName = element.getName();
            if (ArraysKt.contains((Object[])objectArray, (Object)tagName)) continue;
            if (Intrinsics.areEqual((Object)"changeSet", (Object)tagName)) {
                YAMLSequence changesSequence;
                String changeSetId = LiquibaseYamlUtilsKt.getKeyValueText(element, "id");
                YAMLPsiElement yAMLPsiElement = LiquibaseYamlUtilsKt.getKeyValue(element, "changes");
                if ((yAMLPsiElement instanceof YAMLSequence ? (YAMLSequence)yAMLPsiElement : null) == null) continue;
                changesSequence = changesSequence;
                for (YAMLPsiElement subElement : LiquibaseYamlUtilsKt.getSequenceElements(changesSequence)) {
                    result.add(new LiquibaseYamlTagLogicalModel(subElement, changeSetId));
                }
                continue;
            }
            result.add(new LiquibaseYamlTagLogicalModel(element, null));
        }
        return result;
    }

    private final String getAbsolutePath(String pathString, YAMLPsiElement yamlPsiElement) {
        if (Intrinsics.areEqual((Object)LiquibaseYamlUtilsKt.getKeyValueText(yamlPsiElement, "relativeToChangelogFile"), (Object)"true")) {
            PsiFile psiFile = yamlPsiElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            String string = HPsiUtil.getClassPathRelativePath$default((PsiFileSystemItem)((PsiFileSystemItem)psiFile), (char)'\u0000', (int)1, null);
            if (string != null) {
                Object it = string;
                boolean bl = false;
                Path path = Paths.get((String)it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path path2 = path;
                if (path2 != null) {
                    it = path2;
                    boolean bl2 = false;
                    return ((Object)it.resolveSibling(Path.of(pathString, new String[0])).normalize()).toString();
                }
            }
        }
        return pathString;
    }
}

