/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SMTRunnerRunDashboardCustomizer
extends RunDashboardCustomizer {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED_TEXT);

    SMTRunnerRunDashboardCustomizer() {
    }

    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return descriptor != null && descriptor.getExecutionConsole() instanceof SMTRunnerConsoleView;
    }

    public boolean updatePresentation(@NotNull RunDashboardCustomizationBuilder customizationBuilder, @NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (customizationBuilder == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            return false;
        }
        ExecutionConsole executionConsole = descriptor.getExecutionConsole();
        if (!(executionConsole instanceof SMTRunnerConsoleView)) {
            return false;
        }
        SMTestRunnerResultsForm resultsViewer = ((SMTRunnerConsoleView)executionConsole).getResultsViewer();
        SMTestProxy.SMRootTestProxy rootNode = resultsViewer.getTestsRootNode();
        TestTreeRenderer renderer = new TestTreeRenderer(resultsViewer.getProperties());
        if (rootNode.isLeaf()) {
            TestsPresentationUtil.formatRootNodeWithoutChildren(rootNode, renderer);
        } else {
            TestsPresentationUtil.formatRootNodeWithChildren(rootNode, renderer);
        }
        if (renderer.getIcon() != null) {
            customizationBuilder.setIcon(renderer.getIcon());
        }
        SMTRunnerRunDashboardCustomizer.addTestSummary(customizationBuilder, rootNode);
        return true;
    }

    private static void addTestSummary(@NotNull RunDashboardCustomizationBuilder presentation, @NotNull SMTestProxy.SMRootTestProxy rootNode) {
        if (presentation == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(3);
        }
        if (rootNode == null) {
            SMTRunnerRunDashboardCustomizer.$$$reportNull$$$0(4);
        }
        if (rootNode.isLeaf()) {
            return;
        }
        TestsUIUtil.TestResultPresentation testResultPresentation = new TestsUIUtil.TestResultPresentation((AbstractTestProxy)rootNode).getPresentation();
        int failed = testResultPresentation.getFailedCount();
        int ignored = testResultPresentation.getIgnoredCount();
        int passed = testResultPresentation.getPassedCount();
        int total = passed + failed + testResultPresentation.getNotStartedCount();
        if (total == 0) {
            return;
        }
        presentation.addText(" [", SimpleTextAttributes.GRAY_ATTRIBUTES);
        boolean addSeparator = false;
        if (failed > 0) {
            presentation.addText(TestRunnerBundle.message((String)"tests.result.failed.count", (Object[])new Object[]{failed}), ERROR_ATTRIBUTES);
            addSeparator = true;
        }
        if (passed > 0 || ignored + failed == 0) {
            if (addSeparator) {
                presentation.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation.addText(TestRunnerBundle.message((String)"tests.result.passed.count", (Object[])new Object[]{passed}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            addSeparator = true;
        }
        if (ignored > 0) {
            if (addSeparator) {
                presentation.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation.addText(TestRunnerBundle.message((String)"tests.result.ignored.count", (Object[])new Object[]{ignored}), IGNORE_ATTRIBUTES);
        }
        presentation.addText(TestRunnerBundle.message((String)"tests.result.total.count", (Object[])new Object[]{total}) + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizationBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTRunnerRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestSummary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

