/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/testframework/sm/runner/Shortener;", "", "attributes", "", "", "currentLength", "", "margin", "minValueLengthToCut", "<init>", "(Ljava/util/Map;III)V", "getCurrentLength", "()I", "setCurrentLength", "(I)V", "shortened", "", "shortenAttribute", "", "attribute", "intellij.platform.smRunner"})
final class Shortener {
    @NotNull
    private final Map<String, String> attributes;
    private int currentLength;
    private final int margin;
    private final int minValueLengthToCut;
    @NotNull
    private final Set<String> shortened;

    public Shortener(@NotNull Map<String, String> attributes, int currentLength, int margin, int minValueLengthToCut) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.attributes = attributes;
        this.currentLength = currentLength;
        this.margin = margin;
        this.minValueLengthToCut = minValueLengthToCut;
        this.shortened = new LinkedHashSet();
    }

    public final int getCurrentLength() {
        return this.currentLength;
    }

    public final void setCurrentLength(int n) {
        this.currentLength = n;
    }

    public final void shortenAttribute(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (this.shortened.contains(attribute)) {
            return;
        }
        String string = this.attributes.get(attribute);
        if (string == null) {
            return;
        }
        String value = string;
        if (value.length() <= this.minValueLengthToCut) {
            return;
        }
        int lenBefore = value.length();
        String string2 = new StringBuilder(value).replace(this.margin, value.length() - this.margin, "<...>").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String newValue = string2;
        this.currentLength -= lenBefore - newValue.length();
        this.attributes.put(attribute, newValue);
        this.shortened.add(attribute);
    }
}

