/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import javax.swing.Icon;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractImportTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AbstractImportTestsAction.class);
    public static final String TEST_HISTORY_SIZE = "test_history_size";
    private final Executor myExecutor;

    public AbstractImportTestsAction() {
        this.myExecutor = null;
    }

    public AbstractImportTestsAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        this(text, description, icon, null);
    }

    public AbstractImportTestsAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon, @Nullable Executor executor) {
        super(text, description, icon);
        this.myExecutor = executor;
    }

    public static int getHistorySize() {
        int historySize;
        try {
            historySize = Math.max(0, Integer.parseInt(PropertiesComponent.getInstance().getValue(TEST_HISTORY_SIZE, "10")));
        }
        catch (NumberFormatException e) {
            historySize = 10;
        }
        return historySize;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractImportTestsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractImportTestsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @Nullable
    protected abstract VirtualFile getFile(@NotNull Project var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractImportTestsAction.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        VirtualFile file = this.getFile(project);
        if (file == null) {
            return;
        }
        AbstractImportTestsAction.doImport(project, file, null, this.myExecutor != null ? this.myExecutor : DefaultRunExecutor.getRunExecutorInstance());
    }

    public static void doImport(Project project, VirtualFile file, Long executionId) {
        AbstractImportTestsAction.doImport(project, file, executionId, DefaultRunExecutor.getRunExecutorInstance());
    }

    private static void doImport(Project project, VirtualFile file, Long executionId, Executor executor) {
        try {
            ImportRunProfile profile = new ImportRunProfile(file, project, executor);
            Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Project)project, (Executor)defaultExecutor, (RunProfile)profile);
            builder.executor(executor);
            builder.target(profile.getTarget());
            if (executionId != null) {
                builder.executionId(executionId.longValue());
            }
            builder.buildAndExecute();
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)SmRunnerBundle.message("sm.test.runner.abstract.import.test.error.title", new Object[0]));
        }
    }

    public static void adjustHistory(Project project) {
        int historySize = AbstractImportTestsAction.getHistorySize();
        File[] files = TestStateStorage.getTestHistoryRoot((Project)project).listFiles((dir, name) -> name.endsWith(".xml"));
        if (files != null && files.length >= historySize + 1) {
            Arrays.sort(files, (o1, o2) -> {
                long l2;
                long l1 = o1.lastModified();
                if (l1 == (l2 = o2.lastModified())) {
                    return FileUtil.compareFiles((File)o1, (File)o2);
                }
                return l1 < l2 ? -1 : 1;
            });
            FileUtil.delete((File)files[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class ImportRunProfile
    implements RunProfile {
        private final VirtualFile myFile;
        private final Project myProject;
        private RunConfiguration myConfiguration;
        private boolean myImported;
        private String myTargetId;
        private final Executor myExecutor;

        public ImportRunProfile(VirtualFile file, Project project) {
            this(file, project, DefaultRunExecutor.getRunExecutorInstance());
        }

        public ImportRunProfile(VirtualFile file, final Project project, Executor executor) {
            class TerminateParsingException
            extends SAXException {
                TerminateParsingException() {
                }
            }
            this.myFile = file;
            this.myProject = project;
            this.myExecutor = executor;
            try (BufferedInputStream inputStream2 = new BufferedInputStream(new FileInputStream(VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile)));){
                SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.newSAXParser().parse((InputStream)inputStream2, new DefaultHandler(){
                    boolean isConfigContent = false;
                    final StringBuilder builder = new StringBuilder();

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName.equals("root")) {
                            throw new TerminateParsingException();
                        }
                        if (qName.equals("config")) {
                            this.isConfigContent = true;
                        }
                        if (this.isConfigContent) {
                            this.builder.append("<").append(qName);
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                this.builder.append(" ").append(attributes.getQName(i)).append("=\"").append(JDOMUtil.escapeText((String)attributes.getValue(i))).append("\"");
                            }
                            this.builder.append(">");
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) {
                        if (this.isConfigContent) {
                            this.builder.append(ch, start, length);
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.isConfigContent) {
                            this.builder.append("</").append(qName).append(">");
                        }
                        if (qName.equals("config")) {
                            this.isConfigContent = false;
                            try {
                                ConfigurationType configurationType;
                                Element config = JDOMUtil.load((Reader)new StringReader(this.builder.toString()));
                                String configTypeId = config.getAttributeValue("configId");
                                if (configTypeId != null && (configurationType = ConfigurationTypeUtil.findConfigurationType((String)configTypeId)) != null) {
                                    myConfiguration = configurationType.getConfigurationFactories()[0].createTemplateConfiguration(project);
                                    myConfiguration.setName(config.getAttributeValue("name"));
                                    myConfiguration.readExternal(config);
                                    RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)myProject);
                                    runManager.readBeforeRunTasks(config.getChild("method"), (RunnerAndConfigurationSettings)new RunnerAndConfigurationSettingsImpl(runManager), myConfiguration);
                                }
                                myTargetId = config.getAttributeValue("target");
                            }
                            catch (Exception e) {
                                LOG.debug((Throwable)e);
                            }
                            throw new TerminateParsingException();
                        }
                    }
                });
            }
            catch (TerminateParsingException inputStream2) {
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }

        public ExecutionTarget getTarget() {
            if (this.myTargetId != null) {
                if (DefaultExecutionTarget.INSTANCE.getId().equals(this.myTargetId)) {
                    return DefaultExecutionTarget.INSTANCE;
                }
                for (ExecutionTargetProvider provider : ExecutionTargetProvider.EXTENSION_NAME.getExtensionList()) {
                    for (ExecutionTarget target : provider.getTargets(this.myProject, this.myConfiguration)) {
                        if (!this.myTargetId.equals(target.getId())) continue;
                        return target;
                    }
                }
                return null;
            }
            return DefaultExecutionTarget.INSTANCE;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                ImportRunProfile.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                ImportRunProfile.$$$reportNull$$$0(1);
            }
            if (!this.myImported) {
                this.myImported = true;
                return new ImportedTestRunnableState(this, VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            }
            if (this.myConfiguration != null) {
                try {
                    if (!executor.equals(this.myExecutor)) {
                        ExecutionEnvironmentBuilder.create((Executor)this.myExecutor, (RunConfiguration)this.myConfiguration).target(this.getTarget()).buildAndExecute();
                        return null;
                    }
                    return this.myConfiguration.getState(executor, environment);
                }
                catch (Throwable e) {
                    if (this.myTargetId != null && this.getTarget() == null) {
                        throw new ExecutionException(SmRunnerBundle.message("dialog.message.target.does.not.exist", this.myTargetId));
                    }
                    LOG.info(e);
                    throw new ExecutionException(SmRunnerBundle.message("dialog.message.unable.to.run.configuration.settings.are.corrupted", new Object[0]));
                }
            }
            throw new ExecutionException(SmRunnerBundle.message("dialog.message.unable.to.run.configuration.failed.to.detect.test.framework", new Object[0]));
        }

        @NotNull
        public String getName() {
            String string = this.myImported && this.myConfiguration != null ? this.myConfiguration.getName() : this.myFile.getNameWithoutExtension();
            if (string == null) {
                ImportRunProfile.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myConfiguration != null ? this.myConfiguration.getIcon() : null;
        }

        public RunConfiguration getInitialConfiguration() {
            return this.myConfiguration;
        }

        public Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

