/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization.server;

import com.jetbrains.fus.reporting.anonymization.server.AnonymizedFieldsInfo;
import com.jetbrains.fus.reporting.anonymization.server.MultipleProductsGroupAnonymizationInfo;
import com.jetbrains.fus.reporting.anonymization.server.MultipleProductsGroupsAnonymizationInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage;", "", "initialMetadata", "Lcom/jetbrains/fus/reporting/anonymization/server/MultipleProductsGroupsAnonymizationInfo;", "skipAnonymizationIds", "", "", "(Lcom/jetbrains/fus/reporting/anonymization/server/MultipleProductsGroupsAnonymizationInfo;Ljava/util/Set;)V", "fieldsToAnonymize", "", "Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage$Event;", "getFieldsToAnonymize", "groupId", "eventId", "recorderId", "getSkipAnonymizationIds", "updateAnonymizedFields", "", "descriptors", "Event", "anonymization"})
public final class LambdaFieldsToAnonymizeStorage {
    @NotNull
    private final Set<String> skipAnonymizationIds;
    @NotNull
    private final Map<Event, Set<String>> fieldsToAnonymize;

    public LambdaFieldsToAnonymizeStorage(@NotNull MultipleProductsGroupsAnonymizationInfo initialMetadata, @NotNull Set<String> skipAnonymizationIds) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(skipAnonymizationIds, (String)"skipAnonymizationIds");
        this.skipAnonymizationIds = skipAnonymizationIds;
        this.fieldsToAnonymize = new HashMap();
        this.updateAnonymizedFields(initialMetadata);
    }

    public /* synthetic */ LambdaFieldsToAnonymizeStorage(MultipleProductsGroupsAnonymizationInfo multipleProductsGroupsAnonymizationInfo, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(multipleProductsGroupsAnonymizationInfo, set);
    }

    @NotNull
    public final Set<String> getSkipAnonymizationIds() {
        return this.skipAnonymizationIds;
    }

    @NotNull
    public final Set<String> getFieldsToAnonymize(@NotNull String groupId, @NotNull String eventId, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Set set = this.fieldsToAnonymize.get(new Event(groupId, eventId, recorderId));
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void updateAnonymizedFields(MultipleProductsGroupsAnonymizationInfo descriptors) {
        this.fieldsToAnonymize.clear();
        for (MultipleProductsGroupAnonymizationInfo group : descriptors.getGroups()) {
            String groupId = group.getId();
            String recorderId = group.getRecorder();
            List list = group.getAnonymized_fields();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (AnonymizedFieldsInfo anonymizedField : list) {
                Set<String> fields = anonymizedField.getFields();
                if (!(!((Collection)fields).isEmpty())) continue;
                this.fieldsToAnonymize.put(new Event(groupId, anonymizedField.getEvent(), recorderId), fields);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage$Event;", "", "groupId", "", "eventId", "recorderId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getGroupId", "getRecorderId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "anonymization"})
    private static final class Event {
        @NotNull
        private final String groupId;
        @NotNull
        private final String eventId;
        @NotNull
        private final String recorderId;

        public Event(@NotNull String groupId, @NotNull String eventId, @NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            this.groupId = groupId;
            this.eventId = eventId;
            this.recorderId = recorderId;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final String getEventId() {
            return this.eventId;
        }

        @NotNull
        public final String getRecorderId() {
            return this.recorderId;
        }

        @NotNull
        public final String component1() {
            return this.groupId;
        }

        @NotNull
        public final String component2() {
            return this.eventId;
        }

        @NotNull
        public final String component3() {
            return this.recorderId;
        }

        @NotNull
        public final Event copy(@NotNull String groupId, @NotNull String eventId, @NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            return new Event(groupId, eventId, recorderId);
        }

        public static /* synthetic */ Event copy$default(Event event, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = event.groupId;
            }
            if ((n & 2) != 0) {
                string2 = event.eventId;
            }
            if ((n & 4) != 0) {
                string3 = event.recorderId;
            }
            return event.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Event(groupId=" + this.groupId + ", eventId=" + this.eventId + ", recorderId=" + this.recorderId + ")";
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = result * 31 + this.eventId.hashCode();
            result = result * 31 + this.recorderId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)event.groupId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.eventId, (Object)event.eventId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.recorderId, (Object)event.recorderId);
        }
    }
}

