/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database;

import com.intellij.openapi.module.Module;
import com.intellij.persistence.database.ConfigDataSource;
import com.intellij.persistence.database.ConfigDataSourceLineMarkerInfo;
import com.intellij.persistence.database.ConfigDataSourceProcessor;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceService;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\tB\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00030\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u0004\u0018\u00010\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u0012J1\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00030\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/persistence/database/ConfigFileProcessor;", "T", "Lcom/intellij/persistence/database/DataSourceConfigType;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "F", "Lcom/intellij/psi/PsiFile;", "P", "Lcom/intellij/psi/NavigatablePsiElement;", "Lcom/intellij/persistence/database/ConfigDataSourceProcessor;", "<init>", "()V", "processAllInFile", "", "Lcom/intellij/persistence/database/ConfigDataSource;", "module", "Lcom/intellij/openapi/module/Module;", "file", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;)Ljava/util/List;", "processAllVisible", "Lcom/intellij/persistence/database/ConfigDataSourceLineMarkerInfo;", "processingProperties", "(Ljava/util/List;Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;)Ljava/util/List;", "convertToInfo", "sources", "gutter", "Lcom/intellij/psi/PsiElement;", "processInFile", "processVisible", "intellij.javaee.persistence"})
public abstract class ConfigFileProcessor<T extends DataSourceConfigType, I extends ConfigDataSourcePropertyInfo, F extends PsiFile, P extends NavigatablePsiElement>
implements ConfigDataSourceProcessor<T, I> {
    @NotNull
    public final List<ConfigDataSource> processAllInFile(@NotNull Module module, @NotNull F file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(file, (String)"file");
        if (!ConfigDataSourceProcessor.isApplicable$default(this, module, null, 2, null)) {
            return CollectionsKt.emptyList();
        }
        return this.processInFile(module, file);
    }

    @NotNull
    public final List<ConfigDataSourceLineMarkerInfo> processAllVisible(@NotNull List<? extends P> processingProperties, @NotNull Module module, @NotNull F file) {
        Intrinsics.checkNotNullParameter(processingProperties, (String)"processingProperties");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(file, (String)"file");
        if (!ConfigDataSourceProcessor.isApplicable$default(this, module, null, 2, null)) {
            return CollectionsKt.emptyList();
        }
        return this.processVisible(processingProperties, module, file);
    }

    @Nullable
    protected final ConfigDataSourceLineMarkerInfo convertToInfo(@NotNull List<? extends ConfigDataSource> sources, @NotNull PsiElement gutter) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)gutter, (String)"gutter");
        return ConfigDataSourceService.Companion.getInstance().dataSourcesToLineMarkerInfo(sources, gutter);
    }

    @NotNull
    protected abstract List<ConfigDataSource> processInFile(@NotNull Module var1, @NotNull F var2);

    @NotNull
    protected abstract List<ConfigDataSourceLineMarkerInfo> processVisible(@NotNull List<? extends P> var1, @NotNull Module var2, @NotNull F var3);
}

