/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.util.containers.VarHandleWrapper;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class VarHandleWrapperImpl
extends VarHandleWrapper
implements VarHandleWrapper.VarHandleWrapperFactory {
    private final VarHandle myVarHandle;
    private final boolean isArray;

    private VarHandleWrapperImpl(VarHandle varHandle, boolean isArray) {
        this.myVarHandle = varHandle;
        this.isArray = isArray;
    }

    @NotNull
    public VarHandleWrapper create(@NotNull Class<?> containingClass, @NotNull String name, @NotNull Class<?> type) {
        if (containingClass == null) {
            VarHandleWrapperImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VarHandleWrapperImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            VarHandleWrapperImpl.$$$reportNull$$$0(2);
        }
        try {
            VarHandle handle = MethodHandles.privateLookupIn(containingClass, MethodHandles.lookup()).findVarHandle(containingClass, name, type);
            return new VarHandleWrapperImpl(handle, false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public VarHandleWrapper createForArrayElement(@NotNull Class<?> arrayClass) {
        if (arrayClass == null) {
            VarHandleWrapperImpl.$$$reportNull$$$0(3);
        }
        assert (arrayClass.isArray());
        return new VarHandleWrapperImpl(MethodHandles.arrayElementVarHandle(arrayClass), true);
    }

    public boolean compareAndSet(Object thisObject, Object expected, Object actual) {
        assert (!this.isArray);
        return this.myVarHandle.compareAndSet(thisObject, expected, actual);
    }

    public boolean compareAndSetInt(Object thisObject, int expected, int actual) {
        assert (!this.isArray);
        return this.myVarHandle.compareAndSet(thisObject, expected, actual);
    }

    public boolean compareAndSetByte(Object thisObject, byte expected, byte actual) {
        assert (!this.isArray);
        return this.myVarHandle.compareAndSet(thisObject, expected, actual);
    }

    public boolean compareAndSetLong(Object thisObject, long expected, long actual) {
        assert (!this.isArray);
        return this.myVarHandle.compareAndSet(thisObject, expected, actual);
    }

    public Object getVolatileArrayElement(Object thisObject, int index) {
        assert (this.isArray);
        return this.myVarHandle.getVolatile(thisObject, index);
    }

    public void setVolatileArrayElement(Object thisObject, int index, Object value) {
        assert (this.isArray);
        this.myVarHandle.setVolatile(thisObject, index, value);
    }

    public boolean compareAndSetArrayElement(Object thisObject, int index, Object expected, Object value) {
        assert (this.isArray);
        return this.myVarHandle.compareAndSet(thisObject, index, expected, value);
    }

    public int getAndAdd(Object thisObject, int value) {
        assert (!this.isArray);
        return this.myVarHandle.getAndAdd(thisObject, value);
    }

    public static void useVarHandlesInConcurrentCollections() {
        FACTORY = new VarHandleWrapperImpl(null, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/concurrency/VarHandleWrapperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createForArrayElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

