/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.DefiniteLightVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.security.el.SpringSecuritySpElAccessInjector;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.util.Plow;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringSecurityELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = List.of("org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.prepost.PostAuthorize", "org.springframework.security.access.prepost.PostFilter", "org.springframework.data.jpa.repository.Query");
    private static final UExpressionPattern[] UAST_PATTERNS = new UExpressionPattern[]{UastPatterns.literalExpression().inCall((ElementPattern)UastPatterns.callExpression().withMethodName("access").withReceiver((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer.AuthorizedUrl", "org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl"})))), UastPatterns.literalExpression().callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor("org.springframework.security.web.access.expression.WebExpressionAuthorizationManager"))};

    SpringSecurityELContextVariables() {
    }

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(0);
        }
        if ((context = element.getContext()) == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                SpringSecurityELContextVariables.$$$reportNull$$$0(1);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        Set set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods((Module)module, (String)(SpringSecurityELContextVariables.isUsedInSecurityAnnotation(context) ? "org.springframework.security.access.expression.method.MethodSecurityExpressionRoot" : "org.springframework.security.web.access.expression.WebSecurityExpressionRoot"));
        if (set == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        PsiMethod method;
        PsiElement context;
        if (psiElement == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(3);
        }
        if ((context = psiElement.getContext()) == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringSecurityELContextVariables.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList variables = new SmartList();
        UMethod uMethod = (UMethod)UastUtils.findContaining((PsiElement)context, UMethod.class);
        PsiMethod psiMethod = method = uMethod != null ? uMethod.getJavaPsi() : null;
        if (method != null) {
            Pair annotationEntry;
            List parameters = uMethod.getUastParameters();
            for (UParameter parameter : parameters) {
                UAnnotation annotation = SpringSecurityELContextVariables.findAnnotation(parameter, "org.springframework.security.core.parameters.P", "org.springframework.security.access.method.P", "org.springframework.data.repository.query.Param");
                if (annotation != null) {
                    String value;
                    UExpression expression;
                    PsiElement navigationElement = annotation.getSourcePsi();
                    if (navigationElement == null || (expression = annotation.findAttributeValue("value")) == null || !StringUtil.isNotEmpty((String)(value = UastUtils.evaluateString((UExpression)expression)))) continue;
                    variables.add(new DefiniteLightVariable(value, parameter.getType(), navigationElement));
                    continue;
                }
                PsiElement psiParameter = parameter.getJavaPsi();
                if (!(psiParameter instanceof PsiParameter)) continue;
                variables.add(parameter);
            }
            UElement element = UastContextKt.toUElement((PsiElement)context);
            if (element != null && (annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)element)) != null) {
                UAnnotation uAnnotation = (UAnnotation)annotationEntry.getFirst();
                SpringSecurityELContextVariables.addPostAuthorizeVariables(uAnnotation, (Collection<PsiVariable>)variables, uMethod);
                SpringSecurityELContextVariables.addPreFilterAnnotationVariables(uAnnotation, (Collection<PsiVariable>)variables, uMethod);
                SpringSecurityELContextVariables.addPostFilterAnnotationVariables(uAnnotation, (Collection<PsiVariable>)variables, uMethod);
            }
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Nullable
    private static UAnnotation findAnnotation(UParameter parameter, String ... annotations) {
        for (String annotation : annotations) {
            UAnnotation uAnnotation = parameter.findAnnotation(annotation);
            if (uAnnotation == null) continue;
            return uAnnotation;
        }
        return null;
    }

    private static boolean acceptContext(@NotNull PsiElement context) {
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(6);
        }
        return SpringSecurityELContextVariables.isUsedInSecurityAnnotation(context) || SpringSecurityELContextVariables.isXmlAccess(context) || SpringSecurityELContextVariables.isSecuritySpElPatternAccepted(context);
    }

    private static boolean isUsedInSecurityAnnotation(@NotNull PsiElement context) {
        UElement element;
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(7);
        }
        if ((element = UastContextKt.toUElement((PsiElement)context)) == null) {
            return false;
        }
        Pair annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)element);
        if (annotationEntry != null && ANNOTATIONS.contains(((UAnnotation)annotationEntry.component1()).getQualifiedName())) {
            return true;
        }
        UElement parent = element.getUastParent();
        return parent instanceof UField && SpringSecurityELContextVariables.isUsedInSecurityAnnotation((UField)parent);
    }

    private static Plow<PsiElement> findLocalUsages(UField constantDeclaration) {
        String declarationName = constantDeclaration.getName();
        if (declarationName == null) {
            return Plow.empty();
        }
        PsiElement psi = constantDeclaration.getSourcePsi();
        if (psi == null) {
            return Plow.empty();
        }
        PsiFile containingFile = psi.getContainingFile();
        if (containingFile == null) {
            return Plow.empty();
        }
        return Plow.of(processor -> PsiSearchHelper.getInstance((Project)psi.getProject()).processElementsWithWord((element, offsetInElement) -> offsetInElement != 0 || processor.process((Object)element), (SearchScope)GlobalSearchScope.fileScope((PsiFile)containingFile), declarationName, (short)1, true, false)).filter(element -> ContainerUtil.exists((Object[])element.getReferences(), reference -> reference.isReferenceTo(psi)));
    }

    private static boolean isUsedInSecurityAnnotation(UField constantDeclaration) {
        return SpringSecurityELContextVariables.findLocalUsages(constantDeclaration).find(element -> {
            UElement usageUElement = UastContextKt.toUElement((PsiElement)element);
            if (usageUElement == null) {
                return false;
            }
            Pair annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)usageUElement);
            if (annotationEntry != null && ANNOTATIONS.contains(((UAnnotation)annotationEntry.component1()).getQualifiedName())) {
                return true;
            }
            return false;
        }) != null;
    }

    private static boolean isXmlAccess(@NotNull PsiElement context) {
        if (context == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(8);
        }
        return context instanceof XmlAttributeValue && SpringSecuritySpElAccessInjector.ACCESS_ATTR_PATTERN.accepts((Object)context);
    }

    private static void addPostAuthorizeVariables(@NotNull UAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull UMethod method) {
        if (annotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(9);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(10);
        }
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(11);
        }
        if ("org.springframework.security.access.prepost.PostAuthorize".equals(annotation.getQualifiedName())) {
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiElement navigationElement = SpringSecurityELContextVariables.getReturnTypeNavigationElement(method);
            if (navigationElement != null) {
                variables.add((PsiVariable)new DefiniteLightVariable("returnObject", returnType, navigationElement));
            }
        }
    }

    @Nullable
    private static PsiElement getReturnTypeNavigationElement(@NotNull UMethod method) {
        UTypeReferenceExpression uElement;
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(12);
        }
        return (uElement = method.getReturnTypeReference()) == null ? null : uElement.getSourcePsi();
    }

    private static void addPostFilterAnnotationVariables(@NotNull UAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull UMethod method) {
        if (annotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(13);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(14);
        }
        if (method == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(15);
        }
        if ("org.springframework.security.access.prepost.PostFilter".equals(annotation.getQualifiedName())) {
            PsiElement navigationElement;
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiType iterableTypeParameter = SpringSecurityELContextVariables.getIterableType(returnType, (UElement)method);
            if (iterableTypeParameter != null && (navigationElement = SpringSecurityELContextVariables.getReturnTypeNavigationElement(method)) != null) {
                variables.add((PsiVariable)new DefiniteLightVariable("filterObject", iterableTypeParameter, navigationElement));
            }
        }
    }

    @Nullable
    private static PsiType getIterableType(@NotNull PsiType type, @NotNull UElement element) {
        PsiType collectionType;
        if (type == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(16);
        }
        if (element == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(17);
        }
        if ((collectionType = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)true)) != null) {
            return collectionType;
        }
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        PsiType streamType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (streamType != null) {
            return streamType;
        }
        return SpringSecurityELContextVariables.getMapEntryType(type, element);
    }

    @Nullable
    private static PsiClassType getMapEntryType(@NotNull PsiType type, @NotNull UElement element) {
        if (type == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(18);
        }
        if (element == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(19);
        }
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            PsiElement sourcePsi = element.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            PsiType[] typeParams = ((PsiClassType)type).getParameters();
            PsiClass entryClass = JavaPsiFacade.getInstance((Project)sourcePsi.getProject()).findClass("java.util.Map.Entry", sourcePsi.getResolveScope());
            if (entryClass != null) {
                return JavaPsiFacade.getElementFactory((Project)sourcePsi.getProject()).createType(entryClass, typeParams);
            }
        }
        return null;
    }

    private static void addPreFilterAnnotationVariables(@NotNull UAnnotation uAnnotation, @NotNull Collection<PsiVariable> variables, @NotNull UMethod uMethod) {
        if (uAnnotation == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(20);
        }
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(21);
        }
        if (uMethod == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(22);
        }
        if ("org.springframework.security.access.prepost.PreFilter".equals(uAnnotation.getQualifiedName())) {
            UExpression expression = uAnnotation.findAttributeValue("filterTarget");
            String filterTarget = expression != null ? UastUtils.evaluateString((UExpression)expression) : null;
            List parameters = uMethod.getUastParameters();
            if (StringUtil.isEmptyOrSpaces((String)filterTarget)) {
                if (parameters.size() == 1) {
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, (UParameter)parameters.get(0));
                }
            } else {
                for (UParameter parameter : parameters) {
                    if (!filterTarget.equals(parameter.getName())) continue;
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, parameter);
                    return;
                }
            }
        }
    }

    private static void addFilterObjectParameter(@NotNull Collection<PsiVariable> variables, @NotNull UParameter parameter) {
        PsiElement navigationElement;
        if (variables == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(23);
        }
        if (parameter == null) {
            SpringSecurityELContextVariables.$$$reportNull$$$0(24);
        }
        if ((navigationElement = parameter.getJavaPsi()) == null) {
            return;
        }
        PsiType iterableTypeParameter = SpringSecurityELContextVariables.getIterableType(parameter.getType(), (UElement)parameter);
        if (iterableTypeParameter != null) {
            variables.add((PsiVariable)new DefiniteLightVariable("filterObject", iterableTypeParameter, navigationElement));
        }
    }

    public static boolean isSecuritySpElPatternAccepted(PsiElement context) {
        UElement uElement = UastContextKt.toUElement((PsiElement)context);
        if (uElement == null) {
            return false;
        }
        for (UExpressionPattern pattern : UAST_PATTERNS) {
            if (!pattern.accepts((Object)uElement)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/el/SpringSecurityELContextVariables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uAnnotation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/el/SpringSecurityELContextVariables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootMethods";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUsedInSecurityAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isXmlAccess";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPostAuthorizeVariables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeNavigationElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPostFilterAnnotationVariables";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIterableType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMapEntryType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPreFilterAnnotationVariables";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addFilterObjectParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

