/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CallTreeFilterProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/api/NameBasedFilterProvider;", "Lcom/intellij/profiler/api/CallTreeFilterProvider;", "<init>", "()V", "getPatterns", "", "Ljava/util/regex/Pattern;", "getExclusions", "toString", "", "element", "Lcom/intellij/profiler/api/BaseCallStackElement;", "isFiltered", "", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallTreeFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeFilters.kt\ncom/intellij/profiler/api/NameBasedFilterProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1807#2,3:77\n1807#2,3:80\n*S KotlinDebug\n*F\n+ 1 CallTreeFilters.kt\ncom/intellij/profiler/api/NameBasedFilterProvider\n*L\n63#1:77,3\n64#1:80,3\n*E\n"})
public abstract class NameBasedFilterProvider
implements CallTreeFilterProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract List<Pattern> getPatterns();

    @NotNull
    public List<Pattern> getExclusions() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public abstract String toString(@NotNull BaseCallStackElement var1);

    @Override
    public boolean isFiltered(@NotNull BaseCallStackElement element) {
        boolean bl;
        Pattern it;
        boolean bl2;
        boolean $i$f$any;
        Iterable $this$any$iv;
        String string;
        block8: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            string = this.toString(element);
            $this$any$iv = this.getExclusions();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Pattern)element$iv;
                    boolean bl3 = false;
                    if (!it.matcher(string).matches()) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            bl = false;
        } else {
            boolean bl4;
            block9: {
                $this$any$iv = this.getPatterns();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Pattern)element$iv;
                        boolean bl5 = false;
                        if (!it.matcher(string).matches()) continue;
                        bl4 = true;
                        break block9;
                    }
                    bl4 = false;
                }
            }
            bl = bl4;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Pattern compile(@NotNull String rule) {
        return Companion.compile(rule);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/api/NameBasedFilterProvider$Companion;", "", "<init>", "()V", "compile", "Ljava/util/regex/Pattern;", "rule", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Pattern compile(@NotNull String rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            char[] cArray = "\\<([{^-=$!|]})?*+.>".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] cArray2 = cArray;
            String string = StringUtil.escapeChars((String)rule, (char[])Arrays.copyOf(cArray2, cArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
            String string2 = StringsKt.replace$default((String)string, (String)"\\*", (String)".*?", (boolean)false, (int)4, null);
            int n = 0;
            Pattern pattern = Pattern.compile(string2, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            return pattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

