/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="ProfileHistory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\u0002H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/api/ProfileHistoryConfiguration;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/profiler/api/ProfileHistoryConfiguration$State;", "<init>", "()V", "_state", "project", "Lcom/intellij/openapi/project/Project;", "getState", "loadState", "", "state", "history", "", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "register", "file", "Ljava/io/File;", "prettyName", "", "remove", "State", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfileHistoryConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileHistoryConfiguration.kt\ncom/intellij/profiler/api/ProfileHistoryConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n540#2:73\n525#2,6:74\n139#3,10:80\n221#3:90\n222#3:92\n149#3:93\n1#4:91\n*S KotlinDebug\n*F\n+ 1 ProfileHistoryConfiguration.kt\ncom/intellij/profiler/api/ProfileHistoryConfiguration\n*L\n31#1:73\n31#1:74,6\n36#1:80,10\n36#1:90\n36#1:92\n36#1:93\n36#1:91\n*E\n"})
public final class ProfileHistoryConfiguration
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State _state = new State();
    @Nullable
    private Project project;

    @Deprecated(message="Please, use ProfileHistoryConfiguration.history")
    @NotNull
    public State getState() {
        return this._state;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull State state) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$loadState_u24lambda_u240;
        State state2;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        State state3 = state2 = new State();
        ProfileHistoryConfiguration profileHistoryConfiguration = this;
        boolean bl = false;
        Map<String, String> map = state.getHistory();
        void var6_7 = $this$loadState_u24lambda_u240;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Path path;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get((String)it.getKey(), new String[0]), (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        var6_7.setHistory(MapsKt.toMutableMap((Map)destination$iv$iv));
        profileHistoryConfiguration._state = state2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final List<ProfilerDumpDescriptor> history() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> $this$mapNotNull$iv = this._state.getHistory();
        boolean $i$f$mapNotNull = false;
        Map<String, String> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ProfilerDumpDescriptor profilerDumpDescriptor;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            Project project = this.project;
            if (project == null) {
                return CollectionsKt.emptyList();
            }
            Path path = Paths.get((String)it.getKey(), new String[0]);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                profilerDumpDescriptor = ProfilerDumpDescriptor.Companion.fromFile(file, project, (String)it.getValue());
            } else {
                profilerDumpDescriptor = null;
            }
            if (profilerDumpDescriptor == null) continue;
            ProfilerDumpDescriptor it$iv$iv = profilerDumpDescriptor;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    public final void register(@NotNull File file, @NotNull String prettyName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)prettyName, (String)"prettyName");
        ApplicationManager.getApplication().invokeLater(() -> ProfileHistoryConfiguration.register$lambda$0(this, file, prettyName));
    }

    public static /* synthetic */ void register$default(ProfileHistoryConfiguration profileHistoryConfiguration, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = string2;
        }
        profileHistoryConfiguration.register(file, string);
    }

    @RequiresEdt
    public final void remove(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this._state.getHistory().remove(file.getAbsolutePath());
    }

    private static final void register$lambda$0(ProfileHistoryConfiguration this$0, File $file, String $prettyName) {
        this$0._state.getHistory().remove($file.getAbsolutePath());
        this$0._state.getHistory().put($file.getAbsolutePath(), $prettyName);
        while (this$0._state.getHistory().size() > 10) {
            this$0._state.getHistory().remove(CollectionsKt.first((Iterable)this$0._state.getHistory().keySet()));
        }
    }

    @JvmStatic
    @NotNull
    public static final ProfileHistoryConfiguration getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/api/ProfileHistoryConfiguration$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/profiler/api/ProfileHistoryConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProfileHistoryConfiguration getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProfileHistoryConfiguration.class);
            ProfileHistoryConfiguration $this$getInstance_u24lambda_u240 = (ProfileHistoryConfiguration)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$getInstance_u24lambda_u240);
            $this$getInstance_u24lambda_u240.project = project;
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
            return (ProfileHistoryConfiguration)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R(\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/api/ProfileHistoryConfiguration$State;", "", "<init>", "()V", "history", "", "", "getHistory", "()Ljava/util/Map;", "setHistory", "(Ljava/util/Map;)V", "intellij.profiler.common"})
    public static final class State {
        @NotNull
        private Map<String, String> history = new LinkedHashMap();

        @Property(surroundWithTag=false)
        @XMap(entryTagName="history-entry", keyAttributeName="file")
        @NotNull
        public final Map<String, String> getHistory() {
            return this.history;
        }

        public final void setHistory(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.history = map;
        }
    }
}

