/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.monitor.CpuAndMemoryError;
import com.intellij.profiler.api.monitor.CpuAndMemoryInfo;
import com.intellij.profiler.api.monitor.JMXProcessMonitor;
import com.intellij.profiler.api.monitor.ValueDisplay;
import com.intellij.profiler.ui.concurrency.EdtWorker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.charts.ChartUtils;
import com.intellij.ui.charts.ChartWrapper;
import com.intellij.ui.charts.ChartWrapperKt;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Dataset;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.LineDataset;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.intellij.ui.charts.XYChartComponent;
import com.intellij.ui.charts.XYDataHolder;
import com.intellij.ui.charts.XYLineChart;
import com.intellij.ui.charts.XYLineDataset;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001NB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010,\u001a\u00020\u000b*\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u00030-2\u0010\u0010/\u001a\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u000300H\u0002J\u0006\u00106\u001a\u00020\u000bJ\u0006\u00107\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\u000bJ\u0006\u00109\u001a\u00020\u000bJ\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0016J6\u0010=\u001a\u00020\u000b2,\u0010>\u001a(\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u000300\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020\u000b0\bH\u0002J&\u0010?\u001a\u00020\u000b2\u001c\u0010>\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u000300\u0012\u0004\u0012\u00020\u000b0@H\u0002J\b\u0010A\u001a\u00020\u000bH\u0002J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020CH\u0002J\"\u0010D\u001a\u00020\u000b2\u0010\u0010/\u001a\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u0003002\u0006\u0010E\u001a\u00020.H\u0002J\b\u0010F\u001a\u00020\u000bH\u0016J$\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001b2\b\b\u0002\u0010J\u001a\u00020\u00042\b\b\u0002\u0010K\u001a\u00020\u0004H\u0007J\u0010\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020.H\u0002R.\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0006R$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0006R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u001eR\u00020\u00000\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030)\u0012\u0006\u0012\u0004\u0018\u00010*0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030)\u0012\u0006\u0012\u0004\u0018\u00010*0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.00X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.00X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000400X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "processId", "", "<init>", "(I)V", "errorHandler", "Lkotlin/Function2;", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryError;", "", "", "getErrorHandler", "()Lkotlin/jvm/functions/Function2;", "setErrorHandler", "(Lkotlin/jvm/functions/Function2;)V", "<set-?>", "getProcessId", "()I", "setProcessId", "processId$delegate", "Lkotlin/properties/ReadWriteProperty;", "value", "seconds", "getSeconds", "setSeconds", "processDescriptor", "Lcom/sun/tools/attach/VirtualMachineDescriptor;", "dotPainters", "", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel$ValueDotPainter;", "javaProcessMonitor", "Lcom/intellij/profiler/api/monitor/JMXProcessMonitor;", "edtWorker", "Lcom/intellij/profiler/ui/concurrency/EdtWorker;", "alarm", "Lcom/intellij/util/SingleAlarm;", "chartInsets", "Ljava/awt/Insets;", "lineColors", "", "Lcom/intellij/ui/charts/LineDataset;", "Ljava/awt/Paint;", "fillColors", "xLines", "Lcom/intellij/ui/charts/Grid;", "", "chart", "Lcom/intellij/ui/charts/XYLineChart;", "cpu", "", "mem", "nonheap", "thread", "clear", "start", "cancel", "restart", "setEnabled", "enabled", "", "forEachDataset", "action", "forEachChart", "Lkotlin/Function1;", "updateChart", "info", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryInfo;", "updateChartAxis", "currentTime", "dispose", "getDisplayName", "", "vmd", "maxLength", "suffixLength", "time", "v", "ValueDotPainter", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCpuAndMemoryPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuAndMemoryPanel.kt\ncom/intellij/profiler/api/monitor/CpuAndMemoryPanel\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n33#2,3:485\n1586#3:488\n1661#3,3:489\n1915#3,2:492\n1915#3,2:497\n14060#4,2:494\n1#5:496\n*S KotlinDebug\n*F\n+ 1 CpuAndMemoryPanel.kt\ncom/intellij/profiler/api/monitor/CpuAndMemoryPanel\n*L\n58#1:485,3\n221#1:488\n221#1:489,3\n244#1:492,2\n302#1:497,2\n309#1:494,2\n*E\n"})
public final class CpuAndMemoryPanel
extends BorderLayoutPanel
implements Disposable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private Function2<? super CpuAndMemoryError, ? super Throwable, Unit> errorHandler = (arg_0, arg_1) -> CpuAndMemoryPanel.errorHandler$lambda$0(this, arg_0, arg_1);
    @NotNull
    private final ReadWriteProperty processId$delegate;
    private int seconds;
    @Nullable
    private VirtualMachineDescriptor processDescriptor;
    @NotNull
    private final List<ValueDotPainter<?>> dotPainters;
    @Nullable
    private JMXProcessMonitor javaProcessMonitor;
    @NotNull
    private final EdtWorker edtWorker;
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private final Insets chartInsets;
    @NotNull
    private final Map<LineDataset<?, ?>, Paint> lineColors;
    @NotNull
    private final Map<LineDataset<?, ?>, Paint> fillColors;
    @NotNull
    private final XYLineChart<Long, Double> cpu;
    @NotNull
    private final XYLineChart<Long, Long> mem;
    @NotNull
    private final XYLineChart<Long, Long> nonheap;
    @NotNull
    private final XYLineChart<Long, Integer> thread;

    /*
     * WARNING - void declaration
     */
    public CpuAndMemoryPanel(int processId) {
        void $this$mapTo$iv$iv;
        Object[] $this$_init__u24lambda_u241;
        Integer $this$_init__u24lambda_u240;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = processId;
        boolean $i$f$observable22 = false;
        this.processId$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ CpuAndMemoryPanel this$0;
            {
                this.this$0 = cpuAndMemoryPanel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                int oldValue2 = ((Number)oldValue).intValue();
                boolean bl = false;
                if (oldValue2 != newValue2) {
                    this.this$0.cancel();
                    this.this$0.start();
                }
            }
        };
        this.seconds = 60;
        this.dotPainters = new ArrayList();
        this.edtWorker = new EdtWorker(AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Cpu and Memory Worker", (int)1));
        this.alarm = SingleAlarm.Companion.pooledThreadSingleAlarm(1000, (Disposable)this, () -> CpuAndMemoryPanel.alarm$lambda$0(this));
        this.chartInsets = new Insets(30, 10, 30, 10);
        this.lineColors = new LinkedHashMap();
        this.fillColors = new LinkedHashMap();
        this.cpu = ChartUtils.lineChart(arg_0 -> CpuAndMemoryPanel.cpu$lambda$0(this, arg_0));
        this.mem = ChartUtils.lineChart(arg_0 -> CpuAndMemoryPanel.mem$lambda$0(this, arg_0));
        this.nonheap = ChartUtils.lineChart(arg_0 -> CpuAndMemoryPanel.nonheap$lambda$0(this, arg_0));
        this.thread = ChartUtils.lineChart(arg_0 -> CpuAndMemoryPanel.thread$lambda$0(this, arg_0));
        final OnePixelSplitter central = new OnePixelSplitter(true, "cpu.and.memory.view.proportionKey", 0.65f);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                central.setOrientation((double)e.getComponent().getHeight() / (double)e.getComponent().getWidth() >= 0.5);
            }
        });
        Integer $i$f$observable22 = initialValue$iv = new OpaquePanel();
        Object object = central;
        boolean bl = false;
        $this$_init__u24lambda_u240.setLayout(new BoxLayout((Container)((Object)$this$_init__u24lambda_u240), 0));
        $this$_init__u24lambda_u240.add(this.cpu.getComponent());
        $this$_init__u24lambda_u240.add(this.mem.getComponent());
        object.setFirstComponent((JComponent)((Object)initialValue$iv));
        $this$_init__u24lambda_u240 = initialValue$iv = new OpaquePanel();
        object = central;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setLayout((LayoutManager)new BoxLayout((Container)$this$_init__u24lambda_u241, 0));
        $this$_init__u24lambda_u241.add((Component)this.thread.getComponent());
        $this$_init__u24lambda_u241.add((Component)this.nonheap.getComponent());
        object.setSecondComponent((JComponent)((Object)initialValue$iv));
        this.addToCenter((Component)central);
        $this$_init__u24lambda_u241 = new XYLineChart[]{this.cpu, this.mem, this.nonheap, this.thread};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])$this$_init__u24lambda_u241);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XYLineChart xYLineChart = (XYLineChart)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            object.add(it.getComponent());
        }
        List charts = (List)destination$iv$iv;
        MouseAdapter ma2 = new MouseAdapter(charts){
            final /* synthetic */ List<JComponent> $charts;
            {
                this.$charts = $charts;
            }

            private final void repaintOtherCharts(MouseEvent e) {
                Iterable $this$forEach$iv = this.$charts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JComponent it = (JComponent)element$iv;
                    boolean bl = false;
                    if (it == e.getSource()) continue;
                    it.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }
        };
        Iterable $this$forEach$iv = charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl4 = false;
            it.addMouseMotionListener(ma2);
            it.addMouseListener(ma2);
        }
        this.forEachDataset((arg_0, arg_1) -> CpuAndMemoryPanel._init_$lambda$4(this, arg_0, arg_1));
    }

    @NotNull
    public final Function2<CpuAndMemoryError, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@NotNull Function2<? super CpuAndMemoryError, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.errorHandler = function2;
    }

    public final int getProcessId() {
        return ((Number)this.processId$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    public final void setProcessId(int n) {
        this.processId$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final void setSeconds(int value) {
        if (this.seconds != value) {
            this.seconds = value < 1 ? -1 : value;
            long currentTime = System.currentTimeMillis();
            this.forEachChart(arg_0 -> CpuAndMemoryPanel._set_seconds_$lambda$0(this, currentTime, arg_0));
            this.repaint();
        }
    }

    private final void xLines(Grid<Long, ?> $this$xLines, XYLineChart<Long, ?> chart2) {
        $this$xLines.setXLines(ChartUtils.generator((long)1000L));
        ChartUtils.xPainter($this$xLines, arg_0 -> CpuAndMemoryPanel.xLines$lambda$0(chart2, this, arg_0));
    }

    public final void clear() {
        this.cpu.clear();
        this.mem.clear();
        this.nonheap.clear();
        this.nonheap.getRanges().setYMax((Number)1L);
        this.thread.clear();
        this.thread.getRanges().setYMax((Number)1);
    }

    public final void start() {
        this.edtWorker.updateAsync(CpuAndMemoryPanel::start$lambda$0).onSuccess(arg_0 -> CpuAndMemoryPanel.start$lambda$2(arg_0 -> CpuAndMemoryPanel.start$lambda$1(this, arg_0), arg_0));
    }

    public final void cancel() {
        this.alarm.cancelAllRequests();
        this.clear();
    }

    public final void restart() {
        this.cancel();
        this.start();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.forEachDataset((arg_0, arg_1) -> CpuAndMemoryPanel.setEnabled$lambda$0(this, arg_0, arg_1));
        } else {
            this.forEachDataset(CpuAndMemoryPanel::setEnabled$lambda$1);
        }
    }

    private final void forEachDataset(Function2<? super XYLineChart<Long, ?>, ? super LineDataset<Long, ?>, Unit> action) {
        this.forEachChart(arg_0 -> CpuAndMemoryPanel.forEachDataset$lambda$0(action, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void forEachChart(Function1<? super XYLineChart<Long, ?>, Unit> action) {
        void $this$forEach$iv;
        XYLineChart[] xYLineChartArray = new XYLineChart[]{this.cpu, this.mem, this.nonheap, this.thread};
        boolean $i$f$forEach = false;
        for (void element$iv : $this$forEach$iv) {
            action.invoke((Object)element$iv);
        }
    }

    private final void updateChart() {
        VirtualMachineDescriptor data = this.processDescriptor;
        if (data == null) {
            this.edtWorker.updateAsync(CpuAndMemoryPanel::updateChart$lambda$0).onSuccess(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$2(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$1(this, arg_0), arg_0));
            return;
        }
        this.edtWorker.updateAsync(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$3(data, this, arg_0)).onSuccess(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$5(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$4(this, arg_0), arg_0)).onError(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$7(arg_0 -> CpuAndMemoryPanel.updateChart$lambda$6(this, arg_0), arg_0));
    }

    private final void updateChart(CpuAndMemoryInfo info) {
        long currentTime = info.getMsecond();
        this.cpu.add((Number)info.getMsecond(), (Number)(info.getProcessCpuLoad() * (double)100));
        this.updateChartAxis(this.cpu, currentTime);
        this.cpu.getRanges().setXMax((Number)Math.max(info.getMsecond(), this.cpu.getRanges().getXMin().longValue() + 1L));
        Object[] objectArray = new Coordinates[]{ChartWrapperKt.to((Number)info.getMsecond(), (Number)info.getUsedHeapMemory())};
        this.mem.getDataset("Used").add(objectArray);
        this.updateChartAxis(this.mem, currentTime);
        this.mem.getRanges().setYMax((Number)info.getHeapMemoryMax());
        this.mem.getRanges().setXMax((Number)Math.max(info.getMsecond(), this.mem.getRanges().getXMin().longValue() + 1L));
        this.nonheap.add((Number)info.getMsecond(), (Number)info.getNonHeapMemory());
        this.updateChartAxis(this.nonheap, currentTime);
        this.nonheap.getRanges().setYMax((Number)Math.max(info.getNonHeapMemory(), this.nonheap.getRanges().getYMax().longValue()));
        this.nonheap.getRanges().setXMax((Number)Math.max(info.getMsecond(), this.nonheap.getRanges().getXMin().longValue() + 1L));
        objectArray = new Coordinates[]{ChartWrapperKt.to((Number)info.getMsecond(), (Number)info.getThreadCount())};
        this.thread.getDataset("Total").add(objectArray);
        objectArray = new Coordinates[]{ChartWrapperKt.to((Number)info.getMsecond(), (Number)info.getDaemonThreadCount())};
        this.thread.getDataset("Daemon").add(objectArray);
        this.thread.getRanges().setYMax((Number)info.getPeakThreadCount());
        this.updateChartAxis(this.thread, currentTime);
        this.thread.getRanges().setXMax((Number)Math.max(info.getMsecond(), this.thread.getRanges().getXMin().longValue() + 1L));
    }

    private final void updateChartAxis(XYLineChart<Long, ?> chart2, long currentTime) {
        block1: {
            block0: {
                if (this.seconds <= -1) break block0;
                chart2.getRanges().setXMin((Number)(currentTime - (long)(this.seconds * 1000)));
                break block1;
            }
            Object object = (XYLineDataset)CollectionsKt.firstOrNull((List)chart2.getDatasets());
            if (object == null || (object = object.getData()) == null || (object = (Coordinates)CollectionsKt.firstOrNull((Iterable)object)) == null) break block1;
            long it = object.getX().longValue();
            boolean bl = false;
            chart2.getRanges().setXMin((Number)it);
        }
    }

    public void dispose() {
        this.cancel();
        this.edtWorker.updateAsync(arg_0 -> CpuAndMemoryPanel.dispose$lambda$0(this, arg_0)).onSuccess(arg_0 -> CpuAndMemoryPanel.dispose$lambda$2(arg_0 -> CpuAndMemoryPanel.dispose$lambda$1(this, arg_0), arg_0));
    }

    @NlsSafe
    @NotNull
    public final String getDisplayName(@NotNull VirtualMachineDescriptor vmd, int maxLength, int suffixLength) {
        Intrinsics.checkNotNullParameter((Object)vmd, (String)"vmd");
        String string = "%s %s";
        Object[] objectArray = new Object[]{vmd.id(), vmd.displayName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String string3 = StringUtil.shortenTextWithEllipsis((String)string2, (int)maxLength, (int)suffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
        return string3;
    }

    public static /* synthetic */ String getDisplayName$default(CpuAndMemoryPanel cpuAndMemoryPanel, VirtualMachineDescriptor virtualMachineDescriptor, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 90;
        }
        if ((n3 & 4) != 0) {
            n2 = 30;
        }
        return cpuAndMemoryPanel.getDisplayName(virtualMachineDescriptor, n, n2);
    }

    private final String time(long v) {
        String string = "%1$tH:%1$tM:%1$tS";
        Object[] objectArray = new Object[]{v};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final void errorHandler$lambda$0$0(CpuAndMemoryPanel this$0, String $message) {
        Messages.showErrorDialog((Component)((Component)((Object)this$0)), (String)$message, (String)CommonProfilerBundleKt.profilerMessage("cpumemory.errorOccurred", new Object[0]));
    }

    private static final Unit errorHandler$lambda$0(CpuAndMemoryPanel this$0, CpuAndMemoryError type, Throwable exc) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String message = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> CommonProfilerBundleKt.profilerMessage("cpumemory.cannotFindVM", new Object[0]);
            case 2 -> CommonProfilerBundleKt.profilerMessage("cpumemory.cannotConnect", new Object[0]);
            case 3 -> CommonProfilerBundleKt.profilerMessage("cpumemory.unknownError", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        ApplicationManager.getApplication().invokeLater(() -> CpuAndMemoryPanel.errorHandler$lambda$0$0(this$0, message));
        Throwable throwable = exc;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            it.printStackTrace();
            throw it;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _set_seconds_$lambda$0(CpuAndMemoryPanel this$0, long $currentTime, XYLineChart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        this$0.updateChartAxis(chart2, chart2.getRanges().getXMaxInitialized() ? chart2.getRanges().getXMax().longValue() : $currentTime);
        return Unit.INSTANCE;
    }

    private static final Unit alarm$lambda$0(CpuAndMemoryPanel this$0) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final Unit xLines$lambda$0(XYLineChart $chart, CpuAndMemoryPanel this$0, GridLine $this$xPainter) {
        Intrinsics.checkNotNullParameter((Object)$this$xPainter, (String)"$this$xPainter");
        int scale = ChartUtils.findScale((ChartWrapper)((ChartWrapper)$chart), (long)$this$xPainter.getXY().getXMin().longValue(), (long)$this$xPainter.getXY().getXMax().longValue(), (int)120);
        $this$xPainter.setPaintLine((this$0.seconds == -1 ? $this$xPainter.getValue().longValue() - $this$xPainter.getXY().getXMin().longValue() : $this$xPainter.getValue().longValue() / (long)1000 * (long)1000) % (long)scale == 0L);
        $this$xPainter.setHorizontalAlignment(4);
        if ($this$xPainter.getPaintLine()) {
            Object v0;
            block3: {
                Iterable iterable = this$0.dotPainters;
                for (Object t : iterable) {
                    ValueDotPainter it = (ValueDotPainter)((Object)t);
                    boolean bl = false;
                    if (!(it.getMouseLocation() != null)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if (v0 == null) {
                $this$xPainter.setLabel(this$0.time($this$xPainter.getValue().longValue()));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit cpu$lambda$0$0(MinMax $this$ranges) {
        Intrinsics.checkNotNullParameter((Object)$this$ranges, (String)"$this$ranges");
        $this$ranges.setYMin((Number)0.0);
        $this$ranges.setYMax((Number)100.0);
        return Unit.INSTANCE;
    }

    private static final Unit cpu$lambda$0$1(CpuAndMemoryPanel this$0, XYLineChart $this_lineChart, Grid $this$grid) {
        Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
        this$0.xLines($this$grid, $this_lineChart);
        Double[] doubleArray = new Double[]{0.0, 25.0, 50.0, 75.0, 100.0};
        $this$grid.setYLines(ChartUtils.enumerator((Number[])doubleArray));
        return Unit.INSTANCE;
    }

    private static final Unit cpu$lambda$0$2(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYLineDataset $this$dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$dataset, (String)"$this$dataset");
        $this$dataset.setLineColor((Paint)new Color(98, 150, 85));
        $this$dataset.setFillColor((Paint)new Color(98, 150, 85, 128));
        $this$dataset.setModificationFirst(true);
        Object[] objectArray = new Overlay[]{new ValueDotPainter(this$0, (Dataset)$this$dataset, "%%", 0), new ValueDisplay((Dataset)$this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.cpu", new Object[0]), "%%", 0, true)};
        $this_lineChart.setOverlays(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit cpu$lambda$0(CpuAndMemoryPanel this$0, XYLineChart $this$lineChart) {
        Intrinsics.checkNotNullParameter((Object)$this$lineChart, (String)"$this$lineChart");
        ChartUtils.ranges((XYChartComponent)((XYChartComponent)$this$lineChart), CpuAndMemoryPanel::cpu$lambda$0$0);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)$this$lineChart), arg_0 -> CpuAndMemoryPanel.cpu$lambda$0$1(this$0, $this$lineChart, arg_0));
        $this$lineChart.setMargins(this$0.chartInsets);
        ChartUtils.dataset((XYLineChart)$this$lineChart, arg_0 -> CpuAndMemoryPanel.cpu$lambda$0$2($this$lineChart, this$0, arg_0));
        $this$lineChart.setBorderPainted(true);
        return Unit.INSTANCE;
    }

    private static final Unit mem$lambda$0$1$0(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYLineDataset $this$dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$dataset, (String)"$this$dataset");
        $this$dataset.setLabel("Used");
        $this$dataset.setLineColor((Paint)DarculaColors.BLUE);
        Color color = DarculaColors.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLUE");
        $this$dataset.setFillColor((Paint)$this$dataset.transparent(color, 0.5));
        $this$dataset.setModificationFirst(true);
        Object[] objectArray = new Overlay[]{new ValueDotPainter(this$0, (Dataset)$this$dataset, " MB", 0), new ValueDisplay((Dataset)$this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.heap.memory", new Object[0]), " MB", 0, false, 16, null)};
        $this_lineChart.setOverlays(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit mem$lambda$0$0(CpuAndMemoryPanel this$0, XYLineChart $this_lineChart, Grid $this$grid) {
        Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
        this$0.xLines($this$grid, $this_lineChart);
        $this$grid.setYLines(ChartUtils.generator((long)512L));
        return Unit.INSTANCE;
    }

    private static final Unit mem$lambda$0$1(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYDataHolder $this$datasets) {
        Intrinsics.checkNotNullParameter((Object)$this$datasets, (String)"$this$datasets");
        ChartUtils.dataset((XYDataHolder)$this$datasets, arg_0 -> CpuAndMemoryPanel.mem$lambda$0$1$0($this_lineChart, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit mem$lambda$0(CpuAndMemoryPanel this$0, XYLineChart $this$lineChart) {
        Intrinsics.checkNotNullParameter((Object)$this$lineChart, (String)"$this$lineChart");
        $this$lineChart.getRanges().setYMin((Number)0L);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)$this$lineChart), arg_0 -> CpuAndMemoryPanel.mem$lambda$0$0(this$0, $this$lineChart, arg_0));
        $this$lineChart.setMargins(this$0.chartInsets);
        ChartUtils.datasets((XYLineChart)$this$lineChart, arg_0 -> CpuAndMemoryPanel.mem$lambda$0$1($this$lineChart, this$0, arg_0));
        $this$lineChart.setBorderPainted(true);
        return Unit.INSTANCE;
    }

    private static final Unit nonheap$lambda$0$1$0(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYLineDataset $this$dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$dataset, (String)"$this$dataset");
        $this$dataset.setLabel("Used");
        $this$dataset.setLineColor((Paint)new Color(151, 118, 169));
        $this$dataset.setFillColor((Paint)$this$dataset.transparent(new Color(151, 118, 169), 0.5));
        $this$dataset.setModificationFirst(true);
        Object[] objectArray = new Overlay[]{new ValueDotPainter(this$0, (Dataset)$this$dataset, " MB", 0), new ValueDisplay((Dataset)$this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.non.heap", new Object[0]), " MB", 0, false, 16, null)};
        $this_lineChart.setOverlays(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit nonheap$lambda$0$0(CpuAndMemoryPanel this$0, XYLineChart $this_lineChart, Grid $this$grid) {
        Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
        this$0.xLines($this$grid, $this_lineChart);
        $this$grid.setYLines(ChartUtils.generator((long)512L));
        return Unit.INSTANCE;
    }

    private static final Unit nonheap$lambda$0$1(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYDataHolder $this$datasets) {
        Intrinsics.checkNotNullParameter((Object)$this$datasets, (String)"$this$datasets");
        ChartUtils.dataset((XYDataHolder)$this$datasets, arg_0 -> CpuAndMemoryPanel.nonheap$lambda$0$1$0($this_lineChart, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit nonheap$lambda$0(CpuAndMemoryPanel this$0, XYLineChart $this$lineChart) {
        Intrinsics.checkNotNullParameter((Object)$this$lineChart, (String)"$this$lineChart");
        $this$lineChart.getRanges().setYMin((Number)0L);
        $this$lineChart.getRanges().setYMax((Number)0L);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)$this$lineChart), arg_0 -> CpuAndMemoryPanel.nonheap$lambda$0$0(this$0, $this$lineChart, arg_0));
        $this$lineChart.setMargins(this$0.chartInsets);
        ChartUtils.datasets((XYLineChart)$this$lineChart, arg_0 -> CpuAndMemoryPanel.nonheap$lambda$0$1($this$lineChart, this$0, arg_0));
        $this$lineChart.setBorderPainted(true);
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0$1$0(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYLineDataset $this$dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$dataset, (String)"$this$dataset");
        $this$dataset.setLabel("Daemon");
        $this$dataset.setStacked(true);
        $this$dataset.setLineColor((Paint)JBColor.RED);
        JBColor jBColor = JBColor.RED;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
        $this$dataset.setFillColor((Paint)$this$dataset.transparent((Color)jBColor, 0.5));
        $this$dataset.setModificationFirst(true);
        $this_lineChart.setOverlays(CollectionsKt.listOf(new ValueDotPainter(this$0, (Dataset)$this$dataset, "", -1)));
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0$1$1(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYLineDataset $this$dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$dataset, (String)"$this$dataset");
        $this$dataset.setLabel("Total");
        $this$dataset.setLineColor((Paint)JBColor.ORANGE);
        JBColor jBColor = JBColor.ORANGE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"ORANGE");
        $this$dataset.setFillColor((Paint)$this$dataset.transparent((Color)jBColor, 0.5));
        $this$dataset.setModificationFirst(true);
        Object[] objectArray = new Overlay[]{new ValueDotPainter(this$0, (Dataset)$this$dataset, "", 0), new ValueDisplay((Dataset)$this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.threads", new Object[0]), "", 0, false, 16, null)};
        $this_lineChart.setOverlays(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0$0(CpuAndMemoryPanel this$0, XYLineChart $this_lineChart, Grid $this$grid) {
        Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
        this$0.xLines($this$grid, $this_lineChart);
        $this$grid.setYLines(ChartUtils.generator((int)50));
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0$1(XYLineChart $this_lineChart, CpuAndMemoryPanel this$0, XYDataHolder $this$datasets) {
        Intrinsics.checkNotNullParameter((Object)$this$datasets, (String)"$this$datasets");
        ChartUtils.dataset((XYDataHolder)$this$datasets, arg_0 -> CpuAndMemoryPanel.thread$lambda$0$1$0($this_lineChart, this$0, arg_0));
        ChartUtils.dataset((XYDataHolder)$this$datasets, arg_0 -> CpuAndMemoryPanel.thread$lambda$0$1$1($this_lineChart, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0(CpuAndMemoryPanel this$0, XYLineChart $this$lineChart) {
        Intrinsics.checkNotNullParameter((Object)$this$lineChart, (String)"$this$lineChart");
        $this$lineChart.getRanges().setYMin((Number)0);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)$this$lineChart), arg_0 -> CpuAndMemoryPanel.thread$lambda$0$0(this$0, $this$lineChart, arg_0));
        $this$lineChart.setMargins(this$0.chartInsets);
        ChartUtils.datasets((XYLineChart)$this$lineChart, arg_0 -> CpuAndMemoryPanel.thread$lambda$0$1($this$lineChart, this$0, arg_0));
        $this$lineChart.setBorderPainted(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(CpuAndMemoryPanel this$0, XYLineChart xYLineChart, LineDataset dataset2) {
        Intrinsics.checkNotNullParameter((Object)xYLineChart, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)dataset2, (String)"dataset");
        this$0.lineColors.put(dataset2, dataset2.getLineColor());
        this$0.fillColors.put(dataset2, dataset2.getFillColor());
        return Unit.INSTANCE;
    }

    private static final List start$lambda$0(ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualMachine.list();
    }

    private static final Unit start$lambda$1(CpuAndMemoryPanel this$0, List vms) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)vms, (String)"vms");
            Iterable iterable = vms;
            CpuAndMemoryPanel cpuAndMemoryPanel = this$0;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                VirtualMachineDescriptor it = (VirtualMachineDescriptor)t;
                boolean bl = false;
                String string = it.id();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id(...)");
                if (!(Integer.parseInt(string) == this$0.getProcessId())) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        cpuAndMemoryPanel.processDescriptor = v1;
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void start$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setEnabled$lambda$0(CpuAndMemoryPanel this$0, XYLineChart xYLineChart, LineDataset dataset2) {
        Intrinsics.checkNotNullParameter((Object)xYLineChart, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)dataset2, (String)"dataset");
        Paint paint = this$0.lineColors.get(dataset2);
        if (paint == null) {
            paint = (Paint)JBColor.GRAY;
        }
        dataset2.setLineColor(paint);
        Paint paint2 = this$0.fillColors.get(dataset2);
        if (paint2 == null) {
            paint2 = (Paint)JBColor.GRAY;
        }
        dataset2.setFillColor(paint2);
        return Unit.INSTANCE;
    }

    private static final Unit setEnabled$lambda$1(XYLineChart xYLineChart, LineDataset dataset2) {
        Intrinsics.checkNotNullParameter((Object)xYLineChart, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)dataset2, (String)"dataset");
        dataset2.setLineColor((Paint)JBColor.DARK_GRAY);
        dataset2.setFillColor((Paint)ColorUtil.withAlpha((Color)((Color)JBColor.GRAY), (double)0.5));
        return Unit.INSTANCE;
    }

    private static final Unit forEachDataset$lambda$0(Function2 $action, XYLineChart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        Iterable $this$forEach$iv = chart2.getDatasets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XYLineDataset dataset2 = (XYLineDataset)element$iv;
            boolean bl = false;
            $action.invoke((Object)chart2, (Object)dataset2);
        }
        return Unit.INSTANCE;
    }

    private static final List updateChart$lambda$0(ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualMachine.list();
    }

    private static final Unit updateChart$lambda$1(CpuAndMemoryPanel this$0, List vms) {
        Intrinsics.checkNotNullParameter((Object)vms, (String)"vms");
        String pid = String.valueOf(OSProcessUtil.getCurrentProcessId());
        for (VirtualMachineDescriptor descriptor : vms) {
            if (!Intrinsics.areEqual((Object)pid, (Object)descriptor.id())) continue;
            this$0.updateChart();
            return Unit.INSTANCE;
        }
        this$0.errorHandler.invoke((Object)CpuAndMemoryError.CANNOT_FIND_CURRENT_VM, null);
        return Unit.INSTANCE;
    }

    private static final void updateChart$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CpuAndMemoryInfo updateChart$lambda$3(VirtualMachineDescriptor $data, CpuAndMemoryPanel this$0, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer pid = Integer.valueOf($data.id());
        JMXProcessMonitor jMXProcessMonitor = this$0.javaProcessMonitor;
        if (!Intrinsics.areEqual((Object)(jMXProcessMonitor != null ? Integer.valueOf(jMXProcessMonitor.getPid()) : null), (Object)pid)) {
            JMXProcessMonitor jMXProcessMonitor2 = this$0.javaProcessMonitor;
            if (jMXProcessMonitor2 != null) {
                jMXProcessMonitor2.close();
            }
            Intrinsics.checkNotNull((Object)pid);
            this$0.javaProcessMonitor = JMXProcessMonitor.Companion.connect(pid);
        }
        JMXProcessMonitor jMXProcessMonitor3 = this$0.javaProcessMonitor;
        Intrinsics.checkNotNull((Object)jMXProcessMonitor3);
        OperatingSystemMXBean os = jMXProcessMonitor3.getOsBean();
        double processCpuLoad = os.getProcessCpuLoad();
        JMXProcessMonitor jMXProcessMonitor4 = this$0.javaProcessMonitor;
        Intrinsics.checkNotNull((Object)jMXProcessMonitor4);
        MemoryMXBean memory = jMXProcessMonitor4.getMemoryBean();
        long usedHeapMemory = memory.getHeapMemoryUsage().getUsed() >> 20;
        long heapMemoryMax = memory.getHeapMemoryUsage().getMax() >> 20;
        long nonHeapMemory = memory.getNonHeapMemoryUsage().getUsed() >> 20;
        JMXProcessMonitor jMXProcessMonitor5 = this$0.javaProcessMonitor;
        Intrinsics.checkNotNull((Object)jMXProcessMonitor5);
        ThreadMXBean threads = jMXProcessMonitor5.getThreadBean();
        int threadCount = threads.getThreadCount();
        int peakThreadCount = threads.getPeakThreadCount();
        int daemonThreadCount = threads.getDaemonThreadCount();
        long msecond = System.currentTimeMillis();
        it.checkCanceled();
        return new CpuAndMemoryInfo(processCpuLoad, usedHeapMemory, heapMemoryMax, nonHeapMemory, threadCount, daemonThreadCount, peakThreadCount, msecond);
    }

    private static final Unit updateChart$lambda$4(CpuAndMemoryPanel this$0, CpuAndMemoryInfo info) {
        Intrinsics.checkNotNull((Object)info);
        this$0.updateChart(info);
        this$0.alarm.request();
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final void updateChart$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateChart$lambda$6(CpuAndMemoryPanel this$0, Throwable exp) {
        this$0.errorHandler.invoke((Object)CpuAndMemoryError.CANNOT_CONNECT_TO_CURRENT_VM, (Object)exp);
        return Unit.INSTANCE;
    }

    private static final void updateChart$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit dispose$lambda$0(CpuAndMemoryPanel this$0, ProgressIndicator it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JMXProcessMonitor monitor = this$0.javaProcessMonitor;
        this$0.javaProcessMonitor = null;
        JMXProcessMonitor jMXProcessMonitor = monitor;
        if (jMXProcessMonitor != null) {
            jMXProcessMonitor.close();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit dispose$lambda$1(CpuAndMemoryPanel this$0, Unit it) {
        Disposer.dispose((Disposable)this$0.edtWorker);
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(CpuAndMemoryPanel.class, "processId", "getProcessId()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u00040\u0003B3\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bH\u0002R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel$ValueDotPainter;", "T", "", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "data", "Lcom/intellij/ui/charts/Dataset;", "Lcom/intellij/ui/charts/Coordinates;", "postfix", "", "digits", "", "<init>", "(Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel;Lcom/intellij/ui/charts/Dataset;Ljava/lang/String;I)V", "getData", "()Lcom/intellij/ui/charts/Dataset;", "getPostfix", "()Ljava/lang/String;", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "findHoveredCoordinate", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nCpuAndMemoryPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuAndMemoryPanel.kt\ncom/intellij/profiler/api/monitor/CpuAndMemoryPanel$ValueDotPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n1#2:485\n*E\n"})
    private final class ValueDotPainter<T extends Number>
    extends Overlay<LineChart<Long, T, ?>> {
        @NotNull
        private final Dataset<Coordinates<Long, T>> data;
        @NotNull
        private final String postfix;
        private final int digits;
        final /* synthetic */ CpuAndMemoryPanel this$0;

        public ValueDotPainter(@NotNull CpuAndMemoryPanel this$0, @NotNull Dataset<Coordinates<Long, T>> data, String postfix, int digits) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            this.this$0 = this$0;
            this.data = data;
            this.postfix = postfix;
            this.digits = digits;
            this.this$0.dotPainters.add(this);
        }

        public /* synthetic */ ValueDotPainter(CpuAndMemoryPanel cpuAndMemoryPanel, Dataset dataset2, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 2;
            }
            this(cpuAndMemoryPanel, dataset2, string, n);
        }

        @NotNull
        public final Dataset<Coordinates<Long, T>> getData() {
            return this.data;
        }

        @NotNull
        public final String getPostfix() {
            return this.postfix;
        }

        public void paintComponent(@NotNull Graphics2D g) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Coordinates<Long, T> coordinates = this.findHoveredCoordinate();
                if (coordinates == null) break block2;
                Coordinates<Long, T> coordinates2 = coordinates;
                CpuAndMemoryPanel cpuAndMemoryPanel = this.this$0;
                Coordinates<Long, T> res = coordinates2;
                boolean bl = false;
                MinMax xy = ((LineChart)this.getChart()).findMinMax();
                if (!xy.isInitialized()) {
                    return;
                }
                Point2D.Double p = ((LineChart)this.getChart()).findLocation(xy, res);
                int radius = 4;
                g.setPaint(this.data.getLineColor());
                g.fillOval(MathKt.roundToInt((double)p.x) - radius, MathKt.roundToInt((double)p.y) - radius, radius * 2, radius * 2);
                g.setPaint(((LineChart)this.getChart()).getBackground());
                g.drawOval(MathKt.roundToInt((double)p.x) - radius, MathKt.roundToInt((double)p.y) - radius, radius * 2, radius * 2);
                if (this.digits >= 0) {
                    g.setColor(JBColor.foreground());
                    String string = "%." + this.digits + "f" + this.postfix;
                    Object[] objectArray = new Object[]{res.getY().doubleValue()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    String test = string2;
                    String tm = cpuAndMemoryPanel.time(res.getX().longValue());
                    FontMetrics $this$paintComponent_u24lambda_u240_u240 = g.getFontMetrics();
                    boolean bl2 = false;
                    Rectangle2D bounds = $this$paintComponent_u24lambda_u240_u240.getStringBounds(test, null);
                    g.drawString(test, MathKt.roundToInt((double)p.x) - (int)bounds.getWidth() / 2, Math.max(MathKt.roundToInt((double)p.y) - (int)bounds.getHeight(), (int)bounds.getHeight() + 30));
                    g.setPaint(((LineChart)this.getChart()).getGridLabelColor());
                    Rectangle2D bounds2 = $this$paintComponent_u24lambda_u240_u240.getStringBounds(tm, null);
                    g.drawString(tm, MathKt.roundToInt((double)p.x) - (int)bounds2.getWidth() / 2, ((LineChart)this.getChart()).getHeight() - ((LineChart)this.getChart()).getMargins().bottom + (int)bounds2.getHeight());
                }
            }
        }

        private final Coordinates<Long, T> findHoveredCoordinate() {
            Object v2;
            block7: {
                MinMax xy;
                LineChart hoveredChart;
                Object mouseLocation;
                block9: {
                    block8: {
                        ValueDotPainter hoveredPainter;
                        Object object;
                        Object v0;
                        block6: {
                            Iterable iterable = this.this$0.dotPainters;
                            for (Object t : iterable) {
                                ValueDotPainter it = (ValueDotPainter)((Object)t);
                                boolean bl = false;
                                if (!(it.getMouseLocation() != null)) continue;
                                v0 = t;
                                break block6;
                            }
                            v0 = null;
                        }
                        if ((object = (hoveredPainter = (ValueDotPainter)v0)) == null || (object = object.getMouseLocation()) == null) {
                            return null;
                        }
                        mouseLocation = object;
                        hoveredChart = (LineChart)hoveredPainter.getChart();
                        xy = hoveredChart.findMinMax();
                        if (!xy.isInitialized()) break block8;
                        int n = hoveredChart.getMargins().left;
                        int it = hoveredChart.getWidth() - hoveredChart.getMargins().right;
                        int n2 = ((Point)mouseLocation).x;
                        if (n <= n2 ? n2 <= it : false) break block9;
                    }
                    return null;
                }
                int x = ((Point)mouseLocation).x - hoveredChart.getMargins().left;
                double rat = (double)x * 1.0 / (double)(hoveredChart.getWidth() - (hoveredChart.getMargins().left + hoveredChart.getMargins().right));
                long value = MathKt.roundToLong((double)((double)(xy.getXMax().longValue() - xy.getXMin().longValue()) * rat)) + xy.getXMin().longValue();
                Iterable iterable = this.data.getData();
                for (Object t : iterable) {
                    Coordinates it = (Coordinates)t;
                    boolean bl = false;
                    if (!(it.getX().longValue() > value)) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            return v2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuAndMemoryError.values().length];
            try {
                nArray[CpuAndMemoryError.CANNOT_FIND_CURRENT_VM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuAndMemoryError.CANNOT_CONNECT_TO_CURRENT_VM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuAndMemoryError.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

