/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.FlameChartColorsPreprocessor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J.\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001b\u0012\u0004\u0012\u00020\u00050\u001a2\b\b\u0001\u0010\u001c\u001a\u00020\u00052\b\b\u0001\u0010\u001d\u001a\u00020\u0005H\u0004J\u0016\u0010\u001e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070 \u0018\u00010\u001fH\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "", "<init>", "()V", "fillTextInsideNode", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "getText", "appendStackElementInRenderer", "", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "component", "Ljavax/swing/JComponent;", "selected", "", "getColorScheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "getRootColorScheme", "getCommentInfo", "classPartsAndMethod", "Lkotlin/Pair;", "", "text", "separator", "colorsPreprocessor", "Lcom/intellij/profiler/ui/flamegraph/FlameChartColorsPreprocessor;", "Lcom/intellij/profiler/model/CallTreeNode;", "Companion", "Empty", "intellij.profiler.common"})
public abstract class BaseCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int LEFT_MARGIN_PX = 0;
    public static final int GROUP_MARGIN_PX = 5;
    public static final int COMMENT_MARGIN_PX = 5;
    public static final int SHORTEST_LENGTH = 3;

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        String text = this.getText(node);
        String trimmedText = StringsKt.take((String)text, (int)3);
        if ((double)fontMetrics.stringWidth(trimmedText) < rect.getWidth() - 0.0) {
            return text;
        }
        return "";
    }

    @NlsSafe
    @NotNull
    public String getText(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.fullName();
    }

    public void appendStackElementInRenderer(@NotNull BaseCallStackElement node, @NotNull SimpleColoredComponent label, @NotNull JComponent component, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)component, (String)this.getText(node), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)label);
    }

    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return FlameChartColors.DEFAULT.INSTANCE;
    }

    @NotNull
    public FlameChartColorScheme getRootColorScheme() {
        return FlameChartColors.PARENT.INSTANCE;
    }

    @Nls
    @Nullable
    public String getCommentInfo(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return null;
    }

    @NotNull
    protected final Pair<List<String>, String> classPartsAndMethod(@NlsSafe @NotNull String text, @NlsSafe @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        String[] stringArray = new String[]{separator};
        List part = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return new Pair((Object)CollectionsKt.dropLast((List)part, (int)1), CollectionsKt.last((List)part));
    }

    @Nullable
    public FlameChartColorsPreprocessor<CallTreeNode<BaseCallStackElement>> colorsPreprocessor() {
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer$Companion;", "", "<init>", "()V", "LEFT_MARGIN_PX", "", "GROUP_MARGIN_PX", "COMMENT_MARGIN_PX", "SHORTEST_LENGTH", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer$Empty;", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "<init>", "()V", "intellij.profiler.common"})
    public static final class Empty
    extends BaseCallStackElementRenderer {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }
    }
}

