/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithOptionalUnits;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.callusage.DiffFactor;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.profiler.ui.callusage.SignedLong;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002()B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0015\b\u0002\u0010\u0005\u001a\u000f\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020 H\u0003J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0018H\u0003J\b\u0010#\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u000f\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "Ljavax/swing/table/TableCellRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "undefined", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;Lkotlin/jvm/functions/Function0;)V", "SPARK_LINE_COLOR", "Lcom/intellij/ui/JBColor;", "percentage", "Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "updateScaleHelper", "Lcom/intellij/util/ui/UpdateScaleHelper;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "formatValue", "", "nlsSafe", "any", "isOpaque", "paintComponent", "", "g", "Ljava/awt/Graphics;", "PercentageState", "Companion", "intellij.profiler.common"})
public final class CallUsageTableCellRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValueMetric metric;
    @Nullable
    private final Function0<String> undefined;
    @NotNull
    private final JBColor SPARK_LINE_COLOR;
    @NotNull
    private final PercentageState percentage;
    @NotNull
    private final ValueMetricPrinter metricPrinter;
    @NotNull
    private final UpdateScaleHelper updateScaleHelper;
    public static final int SPACING_SIZE = 8;
    public static final int EXPAND_LABEL_SPACING_SIZE = 15;

    public CallUsageTableCellRenderer(@NotNull ValueMetric metric, @Nullable Function0<String> undefined) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.metric = metric;
        this.undefined = undefined;
        this.SPARK_LINE_COLOR = new JBColor(12769014, 4543843);
        this.percentage = new PercentageState();
        this.metricPrinter = new ValueMetricPrinterWithOptionalUnits(ValueMetricPrinter.Default.INSTANCE);
        this.updateScaleHelper = new UpdateScaleHelper(false, null, 3, null);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        this.setHorizontalAlignment(4);
    }

    public /* synthetic */ CallUsageTableCellRenderer(ValueMetric valueMetric, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        this(valueMetric, (Function0<String>)function0);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBLabel");
        JBLabel comp = this;
        int width = table.getColumnModel().getColumn(column).getWidth();
        this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)comp);
        this.setBackground(RenderingUtil.getBackground((JTable)table, (boolean)isSelected));
        this.setForeground(RenderingUtil.getForeground((JTable)table, (boolean)isSelected));
        this.percentage.clear();
        Object object = value;
        if (object instanceof Percentage) {
            this.percentage.setWidth(MathKt.roundToInt((double)((double)width * ((Percentage)value).getValue())));
            this.percentage.setX(0);
            this.percentage.setColor(isSelected ? ColorUtil.mix((Color)this.getBackground(), (Color)this.getForeground(), (double)0.2) : (Color)this.SPARK_LINE_COLOR);
            Number number = ((Percentage)value).getNatureValue();
            string = number instanceof Long ? this.metricPrinter.print(this.metric, number.longValue()) : this.formatValue(number);
        } else if (object instanceof Long) {
            string = this.metricPrinter.print(this.metric, ((Number)value).longValue());
        } else if (object instanceof SignedLong) {
            long longValue = ((SignedLong)value).unbox-impl();
            Object res = this.metricPrinter.print(this.metric, longValue);
            if (longValue > 0L) {
                res = "+" + (String)res;
            }
            string = res;
        } else if (object instanceof DiffFactor) {
            double factor = ((DiffFactor)value).unbox-impl();
            string = Double.isInfinite(factor) ? CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.added", new Object[0]) : ProfilerUIUtilsKt.fractionToString$default(factor, 0.0, true, false, 10, null);
        } else {
            if (!isSelected) {
                this.setForeground(UIUtil.getLabelDisabledForeground());
            }
            Object object2 = value;
            if (object2 != null) {
                string = this.nlsSafe(object2);
            } else {
                Function0<String> function0 = this.undefined;
                string = function0 != null ? (String)function0.invoke() : null;
            }
        }
        comp.setText(string);
        return (Component)((Object)this);
    }

    @NlsSafe
    private final String formatValue(Number value) {
        Object object = value;
        object = object instanceof Integer || object instanceof Long ? "%,d" : (object instanceof Float || object instanceof Double ? "%.2f" : "%s");
        Object[] objectArray = new Object[]{value};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NlsSafe
    private final String nlsSafe(Object any) {
        return any.toString();
    }

    public boolean isOpaque() {
        return false;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.percentage.getColor());
        int pad = JBUI.scale((int)1);
        g.fillRect(this.percentage.getX(), pad, Math.max(this.percentage.getWidth(), 1), this.getHeight() - pad * 2);
        super.paintComponent(g);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$Companion;", "", "<init>", "()V", "SPACING_SIZE", "", "EXPAND_LABEL_SPACING_SIZE", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "", "<init>", "()V", "x", "", "getX", "()I", "setX", "(I)V", "width", "getWidth", "setWidth", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "updateState", "", "clear", "intellij.profiler.common"})
    private static final class PercentageState {
        private int x;
        private int width;
        @Nullable
        private Color color;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        public final void updateState(int x, int width, @Nullable Color color) {
            this.x = x;
            this.width = width;
            this.color = color;
        }

        public final void clear() {
            this.updateState(0, 0, null);
        }
    }
}

