/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.impl.ActiveChangeListTrackerImpl;
import com.intellij.platform.vcs.backend.split.BackendChangeListManager;
import com.intellij.platform.vcs.backend.split.HostVcsAppSettings;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendActiveChangeListTracker;", "Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getActiveChangeListId", "", "intellij.platform.vcs.backend.split"})
public final class BackendActiveChangeListTracker
extends ActiveChangeListTrackerImpl {
    public BackendActiveChangeListTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    public String getActiveChangeListId() {
        String activeId = super.getActiveChangeListId();
        if (activeId != null) {
            return activeId;
        }
        if (ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()).isOwner()) {
            return null;
        }
        if (!HostVcsAppSettings.Companion.getInstance().getCreateChangeListsForGuestChanges()) {
            return null;
        }
        LocalChangeList localChangeList = BackendChangeListManager.Companion.getInstance(this.getProject()).createChangeListFor(ClientId.Companion.getCurrent());
        return localChangeList != null ? localChangeList.getId() : null;
    }
}

