/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UiDslUnnamedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.starter.ShellCustomizer;
import org.jetbrains.plugins.terminal.starter.ShellExecOptions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/starter/ShellCustomizer;", "<init>", "()V", "customizeExecOptions", "", "project", "Lcom/intellij/openapi/project/Project;", "shellExecOptions", "Lorg/jetbrains/plugins/terminal/starter/ShellExecOptions;", "findBinDirPath", "Ljava/nio/file/Path;", "guessNodeModulesRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "NodeModulesBinConfigurable", "TerminalSettings", "intellij.javascript.terminal"})
@SourceDebugExtension(value={"SMAP\nNodeModulesEnvTerminalCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesEnvTerminalCustomizer.kt\ncom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n57#2:93\n35#2,2:94\n*S KotlinDebug\n*F\n+ 1 NodeModulesEnvTerminalCustomizer.kt\ncom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer\n*L\n46#1:93\n46#1:94,2\n*E\n"})
public final class NodeModulesEnvTerminalCustomizer
implements ShellCustomizer {
    public void customizeExecOptions(@NotNull Project project, @NotNull ShellExecOptions shellExecOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellExecOptions, (String)"shellExecOptions");
        if (!project.isDisposed() && TerminalSettings.Companion.getInstance().isNodeModulesBinAdded()) {
            Path path = this.findBinDirPath(project);
            if (path == null) {
                return;
            }
            Path binDir = path;
            shellExecOptions.appendEntryToPATH(binDir);
        }
    }

    private final Path findBinDirPath(Project project) {
        VirtualFile virtualFile = this.guessNodeModulesRoot(project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = root.findFileByRelativePath("node_modules/.bin");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile binDirVirtualFile = virtualFile2;
        try {
            return binDirVirtualFile.toNioPath();
        }
        catch (Exception e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot find Path for " + binDirVirtualFile.getPath(), (Throwable)e);
            return null;
        }
    }

    private final VirtualFile guessNodeModulesRoot(Project project) {
        Object object;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = NodeModuleUtil.findChildNodeModulesDir((VirtualFile)it) != null || PackageJsonUtil.findChildPackageJsonFile((VirtualFile)it) != null ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Project)project);
        return this.guessNodeModulesRoot(project) != null ? (UnnamedConfigurable)new NodeModulesBinConfigurable(descriptor.getOsFamily()) : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$NodeModulesBinConfigurable;", "Lcom/intellij/openapi/options/UiDslUnnamedConfigurable$Simple;", "osFamily", "Lcom/intellij/platform/eel/EelOsFamily;", "<init>", "(Lcom/intellij/platform/eel/EelOsFamily;)V", "createContent", "", "Lcom/intellij/ui/dsl/builder/Panel;", "intellij.javascript.terminal"})
    private static final class NodeModulesBinConfigurable
    extends UiDslUnnamedConfigurable.Simple {
        @NotNull
        private final EelOsFamily osFamily;

        public NodeModulesBinConfigurable(@NotNull EelOsFamily osFamily) {
            Intrinsics.checkNotNullParameter((Object)osFamily, (String)"osFamily");
            this.osFamily = osFamily;
        }

        public void createContent(@NotNull Panel $this$createContent) {
            Intrinsics.checkNotNullParameter((Object)$this$createContent, (String)"<this>");
            Panel.row$default((Panel)$this$createContent, null, arg_0 -> NodeModulesBinConfigurable.createContent$lambda$0(this, arg_0), (int)1, null);
        }

        private static final Unit createContent$lambda$0(NodeModulesBinConfigurable this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Object[] objectArray = new Object[]{EelPlatformKt.isWindows((EelOsFamily)this$0.osFamily) ? "%PATH%" : "$PATH"};
            String string = JavaScriptBundle.message((String)"terminal.add_node_modules_bin_to_path.label", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(TerminalSettings.Companion.getInstance()){

                public Object get() {
                    return ((TerminalSettings)this.receiver).isNodeModulesBinAdded();
                }

                public void set(Object value) {
                    ((TerminalSettings)this.receiver).setNodeModulesBinAdded((Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }
    }

    @Service(value={Service.Level.APP})
    @State(name="NodeModulesEnvTerminalCustomizer", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\b\u0010\u000b\"\u0004\b\f\u0010\r*\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings$SettingsState;", "<init>", "()V", "myState", "<set-?>", "", "isNodeModulesBinAdded", "isNodeModulesBinAdded$delegate", "(Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings;)Ljava/lang/Object;", "()Z", "setNodeModulesBinAdded", "(Z)V", "getState", "loadState", "", "state", "SettingsState", "Companion", "intellij.javascript.terminal"})
    private static final class TerminalSettings
    implements PersistentStateComponent<SettingsState> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SettingsState myState = new SettingsState();

        public final boolean isNodeModulesBinAdded() {
            return this.myState.getMyAddNodeModulesBin();
        }

        public final void setNodeModulesBinAdded(boolean bl) {
            this.myState.setMyAddNodeModulesBin(bl);
        }

        private static Object isNodeModulesBinAdded$delegate(TerminalSettings terminalSettings) {
            return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)terminalSettings.myState, SettingsState.class, "myAddNodeModulesBin", "getMyAddNodeModulesBin()Z", 0)));
        }

        @NotNull
        public SettingsState getState() {
            return this.myState;
        }

        public void loadState(@NotNull SettingsState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.myState.setMyAddNodeModulesBin(state.getMyAddNodeModulesBin());
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings;", "getInstance", "()Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings;", "intellij.javascript.terminal"})
        @SourceDebugExtension(value={"SMAP\nNodeModulesEnvTerminalCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesEnvTerminalCustomizer.kt\ncom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,92:1\n42#2,3:93\n*S KotlinDebug\n*F\n+ 1 NodeModulesEnvTerminalCustomizer.kt\ncom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings$Companion\n*L\n88#1:93,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TerminalSettings getInstance() {
                boolean $i$f$service = false;
                Class<TerminalSettings> serviceClass$iv = TerminalSettings.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                return (TerminalSettings)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings$SettingsState;", "", "<init>", "()V", "myAddNodeModulesBin", "", "getMyAddNodeModulesBin", "()Z", "setMyAddNodeModulesBin", "(Z)V", "intellij.javascript.terminal"})
        public static final class SettingsState {
            private boolean myAddNodeModulesBin = true;

            public final boolean getMyAddNodeModulesBin() {
                return this.myAddNodeModulesBin;
            }

            public final void setMyAddNodeModulesBin(boolean bl) {
                this.myAddNodeModulesBin = bl;
            }
        }
    }
}

