/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.common.protocol;

import com.intellij.codeInsight.completion.serialization.FrontendFriendlyPrefixConditionSerializer;
import com.intellij.codeInsight.completion.serialization.PrefixConditionDescriptor;
import com.intellij.codeInsight.completion.serialization.PrefixConditionDescriptorConverter;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StringPattern;
import com.intellij.platform.completion.common.protocol.AfterNonJavaIdentifierPartDescriptor;
import com.intellij.platform.completion.common.protocol.AlwaysTrueDescriptor;
import com.intellij.platform.completion.common.protocol.AndDescriptor;
import com.intellij.platform.completion.common.protocol.ContainsDescriptor;
import com.intellij.platform.completion.common.protocol.EndsWithDescriptor;
import com.intellij.platform.completion.common.protocol.EndsWithUppercaseLetterDescriptor;
import com.intellij.platform.completion.common.protocol.LongerThanDescriptor;
import com.intellij.platform.completion.common.protocol.ShorterThanDescriptor;
import com.intellij.platform.completion.common.protocol.StartsWithDescriptor;
import com.intellij.platform.completion.common.protocol.WithLengthDescriptor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\b\u001a\u0004\u0018\u00010\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/completion/common/protocol/AndPatternConverter;", "Lcom/intellij/codeInsight/completion/serialization/PrefixConditionDescriptorConverter;", "Lcom/intellij/patterns/StringPattern;", "<init>", "()V", "toDescriptor", "Lcom/intellij/codeInsight/completion/serialization/PrefixConditionDescriptor;", "target", "getDescriptorForSingleCondition", "condition", "Lcom/intellij/patterns/PatternCondition;", "intellij.platform.completion.common"})
public final class AndPatternConverter
implements PrefixConditionDescriptorConverter<StringPattern> {
    @Nullable
    public PrefixConditionDescriptor toDescriptor(@NotNull StringPattern target) {
        PrefixConditionDescriptor prefixConditionDescriptor;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List conditions = target.getCondition().getConditions();
        if (conditions.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)conditions);
        PatternCondition lastCondition = (PatternCondition)CollectionsKt.lastOrNull((List)conditions);
        PatternConditionPlus patternConditionPlus = lastCondition instanceof PatternConditionPlus ? (PatternConditionPlus)lastCondition : null;
        if (patternConditionPlus == null) {
            return null;
        }
        PatternConditionPlus andCondition = patternConditionPlus;
        if (!Intrinsics.areEqual((Object)andCondition.getDebugMethodName(), (Object)"and")) {
            return null;
        }
        ElementPattern elementPattern = andCondition.getValuePattern();
        Object object = elementPattern instanceof ElementPattern ? elementPattern : null;
        if (object == null) {
            return null;
        }
        ElementPattern wrappedPattern = object;
        PrefixConditionDescriptor prefixConditionDescriptor2 = (PrefixConditionDescriptor)FrontendFriendlyPrefixConditionSerializer.INSTANCE.toDescriptor((Object)wrappedPattern);
        if (prefixConditionDescriptor2 == null) {
            return null;
        }
        PrefixConditionDescriptor wrappedDescriptor = prefixConditionDescriptor2;
        List baseConditions = CollectionsKt.dropLast((List)conditions, (int)1);
        if (baseConditions.isEmpty()) {
            prefixConditionDescriptor = AlwaysTrueDescriptor.INSTANCE;
        } else if (baseConditions.size() == 1) {
            Object object2 = CollectionsKt.single((List)baseConditions);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"single(...)");
            prefixConditionDescriptor = this.getDescriptorForSingleCondition((PatternCondition)object2);
            if (prefixConditionDescriptor == null) {
                return null;
            }
        } else {
            return null;
        }
        PrefixConditionDescriptor baseDescriptor = prefixConditionDescriptor;
        return new AndDescriptor(baseDescriptor, wrappedDescriptor);
    }

    private final PrefixConditionDescriptor getDescriptorForSingleCondition(PatternCondition<?> condition) {
        Object object;
        PatternCondition<?> patternCondition = condition;
        if (patternCondition instanceof StringPattern.LongerThanCondition) {
            object = new LongerThanDescriptor(((StringPattern.LongerThanCondition)condition).getMinLength());
        } else if (patternCondition instanceof StringPattern.ShorterThanCondition) {
            object = new ShorterThanDescriptor(((StringPattern.ShorterThanCondition)condition).getMaxLength());
        } else if (patternCondition instanceof StringPattern.WithLengthCondition) {
            object = new WithLengthDescriptor(((StringPattern.WithLengthCondition)condition).getLength());
        } else if (patternCondition instanceof StringPattern.StartsWithCondition) {
            String string = ((StringPattern.StartsWithCondition)condition).getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
            object = new StartsWithDescriptor(string);
        } else if (patternCondition instanceof StringPattern.EndsWithCondition) {
            String string = ((StringPattern.EndsWithCondition)condition).getSuffix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSuffix(...)");
            object = new EndsWithDescriptor(string);
        } else if (patternCondition instanceof StringPattern.ContainsCondition) {
            String string = ((StringPattern.ContainsCondition)condition).getSubstring();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubstring(...)");
            object = new ContainsDescriptor(string);
        } else {
            object = patternCondition instanceof StringPattern.EndsWithUppercaseLetterCondition ? (PrefixConditionDescriptor)EndsWithUppercaseLetterDescriptor.INSTANCE : (patternCondition instanceof StringPattern.AfterNonJavaIdentifierPartCondition ? (PrefixConditionDescriptor)AfterNonJavaIdentifierPartDescriptor.INSTANCE : null);
        }
        return object;
    }
}

