/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpParserDefinition;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpConditional;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    @Contract(value="null -> null")
    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement context = element.getContainingFile().getContext();
        if (context instanceof RegExpLanguageHost) {
            RegExpLanguageHost host = (RegExpLanguageHost)context;
            return host;
        }
        if (context != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(context.getClass());
        }
        return null;
    }

    @NotNull
    public EnumSet<RegExpCapability> getCapabilities(RegExpElement element) {
        EnumSet<RegExpCapability> enumSet;
        Language dialect = element.getContainingFile().getLanguage();
        Object object = LanguageParserDefinitions.INSTANCE.forLanguage(dialect);
        if (object instanceof RegExpParserDefinition) {
            RegExpParserDefinition definition = (RegExpParserDefinition)object;
            enumSet = definition.getCapabilities();
        } else {
            enumSet = EnumSet.noneOf(RegExpCapability.class);
        }
        if (enumSet == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text) {
        if (ch == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(1);
        }
        if (text == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(2);
        }
        if (text.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        return host != null ? !host.characterNeedsEscaping(text.charAt(1), ch.getParent() instanceof RegExpClass) : !"\\]".equals(text) && !"\\}".equals(text);
    }

    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsInlineOptionFlag(flag, context);
    }

    public boolean supportsExtendedHexCharacter(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        try {
            return host == null || host.supportsExtendedHexCharacter(regExpChar);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsLiteralBackspace(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        return host == null || host.supportsLiteralBackspace(regExpChar);
    }

    public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        RegExpLanguageHost host;
        if (context == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(3);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(context)) == null || host.supportsPropertySyntax(context);
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host == null || host.supportsNamedGroupSyntax(group);
    }

    public boolean supportsNamedGroupRefSyntax(@Nullable RegExpNamedGroupRef ref) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ref);
        try {
            return host == null || host.supportsNamedGroupRefSyntax(ref);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public Collection<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        if (host == null) {
            return Collections.emptySet();
        }
        return host.getSupportedNamedGroupTypes(context);
    }

    public boolean isValidGroupName(String name, @Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host == null || host.isValidGroupName(name, group);
    }

    public boolean isDuplicateGroupNamesAllowed(@NotNull RegExpGroup group) {
        RegExpLanguageHost host;
        if (group == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(4);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(group)) == null || host.isDuplicateGroupNamesAllowed(group);
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host == null || host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsConditionals(@Nullable RegExpConditional conditional) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(conditional);
        return host == null || host.supportsPythonConditionalRefs();
    }

    public boolean supportConditionalCondition(RegExpAtom condition) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(condition);
        return host == null || host.supportConditionalCondition(condition);
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsPossessiveQuantifiers(context);
    }

    public boolean supportsBoundary(@Nullable RegExpBoundary boundary) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(boundary);
        return host == null || host.supportsBoundary(boundary);
    }

    public boolean supportsSimpleClass(@Nullable RegExpSimpleClass simpleClass) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(simpleClass);
        return host == null || host.supportsSimpleClass(simpleClass);
    }

    public boolean isValidCategory(@NotNull PsiElement element, @NotNull String category) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(5);
        }
        if (category == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(6);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    public boolean isValidPropertyName(@NotNull PsiElement element, @NotNull String type) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(7);
        }
        if (type == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(8);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) == null || host.isValidPropertyName(type);
    }

    public boolean isValidPropertyValue(@NotNull PsiElement element, @NotNull String propertyName, @NotNull String propertyValue) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(9);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(10);
        }
        if (propertyValue == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(11);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) == null || host.isValidPropertyValue(propertyName, propertyValue);
    }

    public boolean supportsNamedCharacters(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(12);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) == null || host.supportsNamedCharacters(namedCharacter);
    }

    public boolean isValidNamedCharacter(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(13);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) == null || host.isValidNamedCharacter(namedCharacter);
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        if (host == null) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return host.supportsLookbehind(group);
    }

    @Nullable
    public Number getQuantifierValue(@NotNull RegExpNumber valueElement) {
        RegExpLanguageHost host;
        if (valueElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(14);
        }
        if ((host = RegExpLanguageHosts.findRegExpHost(valueElement)) == null) {
            return Double.valueOf(valueElement.getText());
        }
        return host.getQuantifierValue(valueElement);
    }

    public String[] @NotNull [] getAllKnownProperties(@NotNull PsiElement element) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(15);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
    }

    public String[] @NotNull [] getAllPropertyValues(@NotNull PsiElement element, @NotNull String propertyName) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(16);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(17);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getAllPropertyValues(propertyName) : RegExpLanguageHost.EMPTY_COMPLETION_ITEMS_ARRAY;
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element, @Nullable String name) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(18);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getPropertyDescription(name) : this.myDefaultProvider.getPropertyDescription(name);
    }

    String[] @NotNull [] getKnownCharacterClasses(@NotNull PsiElement element) {
        RegExpLanguageHost host;
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(19);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element)) != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
    }

    String[][] getPosixCharacterClasses(@NotNull PsiElement element) {
        if (element == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(20);
        }
        return this.myDefaultProvider.getPosixCharacterClasses();
    }

    public boolean belongsToConditionalExpression(@NotNull PsiElement regexpElement, @NotNull PsiElement hostElement) {
        RegExpLanguageHost host;
        if (regexpElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(21);
        }
        if (hostElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(22);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(regexpElement)) != null && host.belongsToConditionalExpression(hostElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpLanguageHosts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedCharacter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexpElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHosts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantEscape";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsPropertySyntax";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicateGroupNamesAllowed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsNamedCharacters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamedCharacter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllKnownProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertyValues";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescription";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getKnownCharacterClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPosixCharacterClasses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "belongsToConditionalExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }
}

