/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.ide.rpc.FrontendDocumentId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentUniqueIdSessionRegistry;
import com.jetbrains.rd.ide.document.ProtocolDocumentHost;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.FrontendDocumentIdDocumentExtension;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentEntry;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import com.jetbrains.rdclient.document.FrontendDocumentHostKt;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.document.FrontendDocumentIdRegistryService;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u0018J*\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000bH\u0004J\"\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0014J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010,\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J0\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H$J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\fH\u0016J\u001e\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H$J\u0010\u0010:\u001a\u00020;2\u0006\u00104\u001a\u00020\fH\u0004J\u0010\u0010<\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\fH\u0016J\u0010\u0010=\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u00101\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "openedDocuments", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/intellij/openapi/editor/Document;", "getOpenedDocuments$annotations", "()V", "getOpenedDocuments", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "recentlyClosedDocuments", "", "documentsOperationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "getDocumentsOperationModel", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "ensureProtocolSubscriptionsReady", "", "markAsFailed", "id", "isRecentlyClosed", "", "documentId", "beforeRecoveryStarts", "getOrCreateIdeaDocument", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "createDocumentWithoutFile", "createDocumentFromVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAlreadyCreatedFrontendDocument", "Lcom/jetbrains/rdclient/document/DocumentEntry;", "viewDocumentModel", "ideaDocument", "createDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "lifetime", "currentlyBindingDocument", "bindDocument", "createModel", "document", "extensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "uniqueIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getAndSetUniqueId", "", "createId", "unregisterDocument", "getSynchronizer", "Companion", "MyProtocolListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DocumentEx.kt\ncom/jetbrains/rd/ide/document/DocumentExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n*L\n1#1,278:1\n67#2,4:279\n67#2,4:301\n67#2,4:306\n67#2,4:316\n13#2:322\n1#3:283\n22#4:284\n23#4,4:297\n812#5,12:285\n1391#5:310\n1480#5,5:311\n66#6:305\n67#6,2:320\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n*L\n114#1:279,4\n185#1:301,4\n227#1:306,4\n232#1:316,4\n40#1:322\n163#1:284\n163#1:297,4\n163#1:285,12\n228#1:310\n228#1:311,5\n226#1:305\n226#1:320,2\n*E\n"})
public abstract class FrontendDocumentHost
extends LifetimedService
implements ProtocolDocumentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ViewableMap<RdDocumentId, Document> openedDocuments;
    @NotNull
    private final List<RdDocumentId> recentlyClosedDocuments;
    @Nullable
    private Document currentlyBindingDocument;
    @NotNull
    private final AtomicLong uniqueIdCounter;
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @NotNull
    private static final Key<Boolean> shouldNotWaitInitialChange;

    public FrontendDocumentHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.openedDocuments = new ViewableMap(null, 1, null);
        this.recentlyClosedDocuments = new ArrayList();
        this.uniqueIdCounter = new AtomicLong(0L);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ViewableMap<RdDocumentId, Document> getOpenedDocuments() {
        return this.openedDocuments;
    }

    protected static /* synthetic */ void getOpenedDocuments$annotations() {
    }

    private final DocumentsOperationModel getDocumentsOperationModel() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol(this.session));
    }

    public final void ensureProtocolSubscriptionsReady() {
        this.getDocumentsOperationModel();
    }

    private final void markAsFailed(RdDocumentId id) {
        this.getDocumentsOperationModel().getClientOpenedWithError().fire((Object)id);
        this.recentlyClosedDocuments.add(id);
    }

    public final boolean isRecentlyClosed(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return !((Map)this.openedDocuments).containsKey(documentId) && this.recentlyClosedDocuments.contains(documentId);
    }

    public final void beforeRecoveryStarts() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Clear recentlyClosedDocuments before recovery starts.");
        }
        this.recentlyClosedDocuments.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Document getOrCreateIdeaDocument(@NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Lifetime documentLifetime, @NotNull IProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-171425");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            DocumentEntry documentEntry = this.getAlreadyCreatedFrontendDocument(documentId, documentModel);
            if (documentEntry != null) {
                if (documentEntry.getOnBindingDispose() != null) {
                    RLifetimeKt.plusAssign((Lifetime)documentLifetime, () -> FrontendDocumentHost.getOrCreateIdeaDocument$lambda$0$0(documentEntry));
                }
                Document document = documentEntry.getDocument();
                return document;
            }
            Document document = this.currentlyBindingDocument;
            if (document != null) {
                Document it2 = document;
                boolean bl2 = false;
                Document document2 = it2;
                return document2;
            }
            Document document3 = (Document)this.openedDocuments.get((Object)documentId);
            if (document3 != null) {
                Document it3 = document3;
                boolean bl3 = false;
                Document document4 = it3;
                return document4;
            }
            VirtualFile virtualFile = AppLevelIdeBackend.Companion.getInstance().tryCreateVirtualFile(documentId);
            Document document5 = virtualFile != null ? this.createDocumentFromVirtualFile(documentModel, documentId, virtualFile) : this.createDocumentWithoutFile(documentModel, documentId);
            return document5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    protected final Document createDocumentWithoutFile(@NotNull RdDocumentModel documentModel, @NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        EditorFactory editorFactory = EditorFactory.getInstance();
        boolean writeThreadOnlyAccess = documentModel.isWriteThreadOnly();
        Document document = editorFactory.createDocument(!writeThreadOnlyAccess);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        return document;
    }

    @Nullable
    protected Document createDocumentFromVirtualFile(@NotNull RdDocumentModel documentModel, @NotNull RdDocumentId documentId, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (Registry.Companion.is("rdclient.test.document.create.fail", false)) {
            throw new RuntimeException("Failed to create document");
        }
        return FileDocumentManager.getInstance().getDocument(virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    private final DocumentEntry getAlreadyCreatedFrontendDocument(RdDocumentId documentId, RdDocumentModel documentModel) {
        FrontendDocumentId frontendDocumentId;
        Object object;
        void $this$filterIsInstanceTo$iv$iv$iv;
        RdDocumentModel $this$getExtensionSafe$iv = documentModel;
        boolean $i$f$getExtensionSafe = false;
        Iterable $this$filterIsInstance$iv$iv = $this$getExtensionSafe$iv.getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof FrontendDocumentIdDocumentExtension)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List extensions$iv = (List)destination$iv$iv$iv;
        if (((Collection)extensions$iv).size() > 1) {
            Logger.getInstance((String)"com.jetbrains.rd.ide.document").error("Document has duplicates of an extension of type " + FrontendDocumentIdDocumentExtension.class);
        }
        if ((object = (FrontendDocumentIdDocumentExtension)((DocumentExtension)CollectionsKt.firstOrNull((List)extensions$iv))) != null && (object = object.getFrontendDocumentId()) != null) {
            Object it = object;
            boolean bl = false;
            v1 = FrontendDocumentId.Companion.fromString((String)it);
        } else {
            v1 = frontendDocumentId = null;
        }
        if (frontendDocumentId == null) {
            return null;
        }
        DocumentEntry documentEntry = FrontendDocumentIdRegistryService.Companion.getInstance().getAndUnregisterDocument(frontendDocumentId);
        if (documentEntry == null) {
            LOG.warn("No document found for document which is already bind with backend: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId) + " with frontend id: " + frontendDocumentId + ".");
            return null;
        }
        return documentEntry;
    }

    protected void viewDocumentModel(@NotNull Lifetime documentLifetime, @NotNull RdDocumentId documentId, @NotNull Document ideaDocument, @NotNull RdDocumentModel documentModel, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ThreadingAssertions.assertEventDispatchThread();
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("binding new document " + documentId + " with frontend document " + ideaDocument);
        }
        if (!(ideaDocument instanceof DocumentImpl)) {
            boolean $i$a$-require-FrontendDocumentHost$viewDocumentModel$32 = false;
            String $i$a$-require-FrontendDocumentHost$viewDocumentModel$32 = "ideaDocument is not a DocumentImpl";
            throw new IllegalArgumentException($i$a$-require-FrontendDocumentHost$viewDocumentModel$32.toString());
        }
        DocumentUniqueIdSessionRegistry registry = DocumentUniqueIdSessionRegistry.Companion.getInstance(session);
        LOG.assertTrue(!registry.hasUniqueId(ideaDocument));
        registry.registerUniqueId(ideaDocument, documentModel.getUniqueId());
        LOG.info("Subscribing for document changes.");
        RLifetimeKt.assertAlive((Lifetime)documentLifetime);
        DocumentSynchronizer documentSynchronizer = this.createDocumentSynchronizer(documentLifetime, documentId, ideaDocument, documentModel, session);
        DocumentExKt.putModel(ideaDocument, session, documentId, documentSynchronizer);
        FrontendDocumentHostKt.access$getBindingCounter(ideaDocument).incrementAndGet();
        ((Map)this.openedDocuments).put(documentId, ideaDocument);
        RLifetimeKt.plusAssign((Lifetime)documentLifetime, () -> FrontendDocumentHost.viewDocumentModel$lambda$2(documentId, this, ideaDocument, session));
        FrontendDocumentHostListener publisher = (FrontendDocumentHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendDocumentHostListener.Companion.getTOPIC());
        publisher.documentBound(documentLifetime, session, documentId, documentModel, ideaDocument);
    }

    @NotNull
    protected abstract DocumentSynchronizer createDocumentSynchronizer(@NotNull Lifetime var1, @NotNull RdDocumentId var2, @NotNull Document var3, @NotNull RdDocumentModel var4, @NotNull ClientAppSession var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public RdDocumentId bindDocument(@NotNull Document ideaDocument) {
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        try {
            void $this$getOrCreate$iv;
            this.currentlyBindingDocument = ideaDocument;
            RdDocumentId documentId = this.createId(ideaDocument);
            IMutableViewableMap documents = this.getDocumentsOperationModel().getDocuments();
            Map map = (Map)documents;
            RdDocumentId key$iv = documentId;
            boolean $i$f$getOrCreate = false;
            Object object = $this$getOrCreate$iv.get(key$iv);
            if (object == null) {
                void $this$flatMapTo$iv$iv;
                Logger logger;
                RdDocumentId it = key$iv;
                boolean bl = false;
                Logger $this$trace$iv = FrontendDocumentHost.LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Creating model document. ee.Path: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
                }
                Iterable $this$flatMap$iv = FrontendDocumentExtensionsProvider.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FrontendDocumentExtensionsProvider provider2 = (FrontendDocumentExtensionsProvider)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = provider2.getExtensions(ideaDocument);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List epExtensions = (List)destination$iv$iv;
                RdDocumentModel rdDocumentModel = this.createModel(ideaDocument, epExtensions);
                Logger $this$trace$iv2 = FrontendDocumentHost.LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl4 = false;
                    logger.trace("Created model: " + rdDocumentModel + ", creation side:" + rdDocumentModel.getCreationSide());
                }
                RdDocumentModel it$iv = rdDocumentModel;
                boolean bl5 = false;
                $this$getOrCreate$iv.put(key$iv, it$iv);
                object = it$iv;
            }
            LOG.info("finished registering document " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
            map = documentId;
            return map;
        }
        finally {
            this.currentlyBindingDocument = null;
        }
    }

    @NotNull
    protected abstract RdDocumentModel createModel(@NotNull Document var1, @NotNull List<? extends DocumentExtension> var2);

    @NotNull
    protected final String getAndSetUniqueId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return Registry.Companion.is("rd.client.patch.engine.enable.unique.document.id") ? "frontend-document-" + this.uniqueIdCounter.getAndIncrement() : "";
    }

    @NotNull
    public RdDocumentId createId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        RdDocumentId existingId = DocumentExKt.getDocumentId(document, this.session);
        if (existingId != null) {
            return existingId;
        }
        return super.createId(document);
    }

    public void unregisterDocument(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        ThreadingAssertions.assertEventDispatchThread();
        DocumentSynchronizer documentSynchronizer = this.getSynchronizer(documentId);
        Document document = documentSynchronizer != null ? documentSynchronizer.getDocument() : null;
        LOG.assertTrue(document != null);
        Document document2 = document;
        if (document2 != null) {
            Document it = document2;
            boolean bl = false;
            DocumentUniqueIdSessionRegistry.Companion.getInstance(this.session).unregisterUniqueId(it);
        }
        this.getDocumentsOperationModel().getDocuments().remove((Object)documentId);
    }

    @Nullable
    public DocumentSynchronizer getSynchronizer(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Document document = (Document)this.openedDocuments.get((Object)documentId);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return DocumentExKt.getDocumentSynchronizer(document2, this.session);
    }

    private static final Unit getOrCreateIdeaDocument$lambda$0$0(DocumentEntry $documentEntry) {
        $documentEntry.getOnBindingDispose().invoke();
        return Unit.INSTANCE;
    }

    private static final Unit viewDocumentModel$lambda$2(RdDocumentId $documentId, FrontendDocumentHost this$0, Document $ideaDocument, ClientAppSession $session) {
        LOG.info("Unbinding document " + $documentId);
        this$0.openedDocuments.remove((Object)$documentId);
        FrontendDocumentHostKt.access$getBindingCounter($ideaDocument).decrementAndGet();
        DocumentExKt.removeModel($ideaDocument, $session);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDocumentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"FrontendDocumentHost.shouldNotWaitInitialChange");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        shouldNotWaitInitialChange = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "shouldNotWaitInitialChange", "Lcom/intellij/openapi/util/Key;", "", "getShouldNotWaitInitialChange", "()Lcom/intellij/openapi/util/Key;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,278:1\n30#2,2:279\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n*L\n42#1:279,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendDocumentHost> serviceClass$iv = FrontendDocumentHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendDocumentHost)((Object)object);
        }

        @Deprecated(message="Use an overload with client app session")
        @ApiStatus.ScheduledForRemoval
        @ApiStatus.Internal
        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        @NotNull
        public final Key<Boolean> getShouldNotWaitInitialChange() {
            return shouldNotWaitInitialChange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,278:1\n67#2,4:279\n67#2,4:283\n67#2,4:287\n67#2,4:291\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n*L\n63#1:279,4\n79#1:283,4\n70#1:287,4\n94#1:291,4\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: subscribe on `documents` model");
            }
            Companion.getLOG().assertTrue(model2.getDocuments().isEmpty(), (Object)"Listener was created too last and the model was already obtained");
            model2.getDocuments().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.extensionCreated$lambda$1(session, this, arg_0, arg_1, arg_2));
            model2.getHostReleasedDocument().advise(lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$2(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$1$2(ClientAppSession $session, RdDocumentId $documentId, Document $document) {
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("document lifetime is terminating. Moving it's id to recentlyClosedDocuments: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)$documentId));
            }
            Companion.getInstance($session).recentlyClosedDocuments.add($documentId);
            DocumentUniqueIdSessionRegistry.Companion.getInstance($session).unregisterUniqueId($document);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientAppSession $session, MyProtocolListener this$0, Lifetime documentLifetime, RdDocumentId documentId, RdDocumentModel documentModel) {
            Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
            ThreadingAssertions.assertEventDispatchThread();
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] MyProtocolListener$extensionCreated$solutions.view$documents.view before invokeLaterIfNeeded. document=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
            }
            try {
                Document document = Companion.getInstance($session).getOrCreateIdeaDocument(documentId, documentModel, documentLifetime, FrontendSessionsUtilKt.getProtocol($session));
                if (document == null) {
                    MyProtocolListener $this$extensionCreated_u24lambda_u241_u241 = this$0;
                    boolean bl = false;
                    Companion.getLOG().warn("It's not possible to get or create a Document for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
                    return Unit.INSTANCE;
                }
                Document document2 = document;
                Companion.getInstance($session).viewDocumentModel(documentLifetime, documentId, document2, documentModel, $session);
                documentLifetime.onTermination(() -> MyProtocolListener.extensionCreated$lambda$1$2($session, documentId, document2));
            }
            catch (ProcessCanceledException e) {
                Companion.getInstance($session).markAsFailed(documentId);
                throw e;
            }
            catch (Throwable e) {
                Companion.getInstance($session).markAsFailed(documentId);
                Companion.getLOG().error(e);
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$2(ClientAppSession $session, RdDocumentId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("document was released on host. Remove it's id from recentlyClosedEditors: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)it) + " ");
            }
            Companion.getInstance($session).recentlyClosedDocuments.remove(it);
            return Unit.INSTANCE;
        }
    }
}

