/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ad.RuntimeFlagsKt;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.KernelAwareTextControlId;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.util.idea.EditorKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "host", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "initializeEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "factory", "Lcom/intellij/openapi/editor/impl/EditorFactoryImpl;", "effectiveDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "highlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "asyncLoader", "Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;", "hackyPutEditorIdToDocument", "", "document", "hackyRemoveEditorIdFromDocument", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPsiAwareTextEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPsiAwareTextEditorProvider.kt\ncom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n67#2,4:111\n13#2:116\n1#3:115\n*S KotlinDebug\n*F\n+ 1 FrontendPsiAwareTextEditorProvider.kt\ncom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider\n*L\n58#1:111,4\n40#1:116\n*E\n"})
public final class FrontendPsiAwareTextEditorProvider
extends PsiAwareTextEditorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel textControlModel;
    @NotNull
    private final FrontendTextControlHost host;
    @NotNull
    private final Lifetime editorLifetime;
    @NotNull
    private static final Logger LOG;

    public FrontendPsiAwareTextEditorProvider(@NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel, @NotNull FrontendTextControlHost host, @NotNull Lifetime editorLifetime) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
        this.textControlId = textControlId;
        this.textControlModel = textControlModel;
        this.host = host;
        this.editorLifetime = editorLifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected EditorImpl initializeEditor(@NotNull EditorFactoryImpl factory, @NotNull Document effectiveDocument, @NotNull Project project, @NotNull VirtualFile file, @NotNull EditorHighlighter highlighter, @NotNull AsyncEditorLoader asyncLoader) {
        EditorImpl editorImpl;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)effectiveDocument, (String)"effectiveDocument");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)asyncLoader, (String)"asyncLoader");
        Optional<Object> optional = factory.editors(effectiveDocument, project).filter(arg_0 -> FrontendPsiAwareTextEditorProvider.initializeEditor$lambda$1(arg_0 -> FrontendPsiAwareTextEditorProvider.initializeEditor$lambda$0(this, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        Editor existingEditor = (Editor)OptionalsKt.getOrNull(optional);
        if (existingEditor != null) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Found existing editor for document with provided textControlId. documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)this.textControlId.getDocumentId()) + ", textControlId=" + UtilKt.toDebugString((TextControlId)this.textControlId));
            }
            return (EditorImpl)existingEditor;
        }
        EditorKind editorKind = EditorKt.toEditorKind((TextControlLocation)this.textControlId.getKind());
        if (!(editorKind == EditorKind.MAIN_EDITOR)) {
            boolean bl = false;
            String string = "Invalid Editor Kind has been found for " + UtilKt.toDebugString((TextControlId)this.textControlId) + ". Expected MAIN_EDITOR, but found " + editorKind.name();
            throw new IllegalArgumentException(string.toString());
        }
        this.hackyPutEditorIdToDocument(effectiveDocument, this.textControlId);
        try {
            editorImpl = factory.createMainEditor(effectiveDocument, project, file, highlighter, arg_0 -> FrontendPsiAwareTextEditorProvider.initializeEditor$lambda$4(this, asyncLoader, arg_0));
        }
        finally {
            this.hackyRemoveEditorIdFromDocument(effectiveDocument);
        }
        return editorImpl;
    }

    private final void hackyPutEditorIdToDocument(Document document, TextControlId textControlId) {
        if (RuntimeFlagsKt.isRhizomeAdRebornEnabled()) {
            ThreadingAssertions.assertEventDispatchThread();
            EditorId existing = (EditorId)document.getUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY());
            if (!(existing == null)) {
                boolean bl = false;
                String string = "editorId is not expected to be in document's user data but found " + existing;
                throw new IllegalArgumentException(string.toString());
            }
            if (textControlId instanceof KernelAwareTextControlId) {
                EditorId editorId = EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)textControlId).getKernelEditorId());
                document.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)editorId);
            }
        }
    }

    private final void hackyRemoveEditorIdFromDocument(Document document) {
        if (RuntimeFlagsKt.isRhizomeAdRebornEnabled()) {
            ThreadingAssertions.assertEventDispatchThread();
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)document), (Key)EditorIdKt.getKERNEL_EDITOR_ID_KEY());
        }
    }

    private static final boolean initializeEditor$lambda$0(FrontendPsiAwareTextEditorProvider this$0, Editor it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)DocumentExKt.getTextControlId(it), (Object)this$0.textControlId);
    }

    private static final boolean initializeEditor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit initializeEditor$lambda$4(FrontendPsiAwareTextEditorProvider this$0, AsyncEditorLoader $asyncLoader, EditorImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.textControlId instanceof KernelAwareTextControlId) {
            it.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)this$0.textControlId).getKernelEditorId()));
        }
        it.putUserData(AsyncEditorLoader.ASYNC_LOADER, (Object)$asyncLoader);
        it.putUserData(FrontendTextControlHost.Companion.getBackendBoundEditor(), (Object)true);
        Boolean bl = (Boolean)this$0.textControlModel.isReadonly().getValueOrNull();
        ((EditorEx)it).setViewer(bl != null ? bl : false);
        FrontendTextControlHost frontendTextControlHost = this$0.host;
        Lifetime lifetime = this$0.editorLifetime;
        Disposable disposable = it.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        frontendTextControlHost.bindTextControl$intellij_rd_client(RLifetimeKt.intersect((Lifetime)lifetime, (Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)disposable)), this$0.textControlId, this$0.textControlModel, (Editor)it);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendPsiAwareTextEditorProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

