/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositeModel;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptionsHint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorManagerKt;
import com.jetbrains.rdclient.fileEditors.SyncEditorCompositeRequest;
import com.jetbrains.rdclient.fileEditors.SyncPreloadedEditorCompositeHint;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJi\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000f0\u001cH\u0000\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncRequest", "Lcom/jetbrains/rdclient/fileEditors/SyncEditorCompositeRequest;", "setSyncRequest", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "setSyncRequest$intellij_rd_client", "openFileFromBackend", "", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "requestFocus", "", "selectAsCurrent", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "isSingletonEditorInWindow", "isPinned", "forceFocus", "initialize", "Lkotlin/Function1;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "openFileFromBackend$intellij_rd_client", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,330:1\n67#2,4:331\n67#2,4:335\n67#2,4:339\n67#2,4:343\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager\n*L\n249#1:331,4\n258#1:335,4\n268#1:339,4\n275#1:343,4\n*E\n"})
public final class SyncFrontendEditorCompositeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private SyncEditorCompositeRequest syncRequest;

    public SyncFrontendEditorCompositeManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SyncEditorCompositeRequest setSyncRequest$intellij_rd_client(@NotNull VirtualFile file) {
        SyncEditorCompositeRequest ourRequest;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SyncEditorCompositeRequest syncEditorCompositeRequest = this.syncRequest;
        if (syncEditorCompositeRequest != null) {
            SyncEditorCompositeRequest oldRequest = syncEditorCompositeRequest;
            boolean bl = false;
            FrontendFileEditorManagerKt.access$getLOG$p().error("Overriding editor request for " + oldRequest.getFile() + " with " + file + ".");
        }
        this.syncRequest = ourRequest = new SyncEditorCompositeRequest(file);
        return ourRequest;
    }

    public final void openFileFromBackend$intellij_rd_client(@NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders2, boolean requestFocus, boolean selectAsCurrent, @Nullable FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow, boolean isPinned, boolean forceFocus, @NotNull Function1<? super EditorComposite, Unit> initialize2) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(editorsWithProviders2, (String)"editorsWithProviders");
        Intrinsics.checkNotNullParameter(initialize2, (String)"initialize");
        Logger $this$trace$iv = FrontendFileEditorManagerKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] openFileFromBackend called. file.name=" + file.getName());
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl fileManager = (FileEditorManagerImpl)fileEditorManager;
        Flow model2 = fileManager.createPrecomputedCompositeModelByProvidedList(editorsWithProviders2);
        SyncPreloadedEditorCompositeHint hint = new SyncPreloadedEditorCompositeHint((Flow<EditorCompositeModel>)model2, initialize2);
        SyncEditorCompositeRequest currentRequest = this.syncRequest;
        if (currentRequest != null && Intrinsics.areEqual((Object)fileManager.getCurrentFile(), (Object)currentRequest.getFile())) {
            Logger $this$trace$iv2 = FrontendFileEditorManagerKt.access$getLOG$p();
            boolean $i$f$trace22 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("[file] openFileFromBackend: request is not null. DO NOT call openFile(...), just put `composite` into `request`.");
            }
            boolean bl = $this$trace$iv2 = currentRequest.getModel() == null;
            if (_Assertions.ENABLED && !$this$trace$iv2) {
                String $i$f$trace22 = "Assertion failed";
                throw new AssertionError((Object)$i$f$trace22);
            }
            currentRequest.setModel(hint);
            return;
        }
        if (currentRequest != null) {
            Logger $this$trace$iv3 = FrontendFileEditorManagerKt.access$getLOG$p();
            boolean $i$f$trace3 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("[file] openFileFromBackend: currentRequest is not null, but `request.value.first != composite.file`. Call openFile(...). currentRequest.value=" + currentRequest.getFile() + ", composite.file=" + file);
            }
        } else {
            Logger $this$trace$iv4 = FrontendFileEditorManagerKt.access$getLOG$p();
            boolean $i$f$trace4 = false;
            if ($this$trace$iv4.isTraceEnabled()) {
                logger = $this$trace$iv4;
                boolean bl = false;
                logger.trace("[file] openFileFromBackend: currentRequest is null. Call openFile(...)");
            }
        }
        fileManager.openFile(file, null, new FileEditorOpenOptions(selectAsCurrent, false, false, requestFocus, isPinned, 0, false, openMode, false, isSingletonEditorInWindow, forceFocus, (FileEditorOpenOptionsHint)hint, 356, null));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,330:1\n30#2,2:331\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/SyncFrontendEditorCompositeManager$Companion\n*L\n224#1:331,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SyncFrontendEditorCompositeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SyncFrontendEditorCompositeManager> serviceClass$iv = SyncFrontendEditorCompositeManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SyncFrontendEditorCompositeManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

