/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmProperties;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradleDaemonJvmPropertiesFile;", "", "<init>", "()V", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleDaemonJvmProperties;", "externalProjectPath", "Ljava/nio/file/Path;", "getPropertyPath", "loadGradleDaemonJvmProperties", "propertiesPath", "EMPTY", "Lorg/jetbrains/plugins/gradle/properties/GradleDaemonJvmPropertiesImpl;", "intellij.gradle"})
public final class GradleDaemonJvmPropertiesFile {
    @NotNull
    public static final GradleDaemonJvmPropertiesFile INSTANCE = new GradleDaemonJvmPropertiesFile();
    @NotNull
    private static final GradleDaemonJvmPropertiesImpl EMPTY = new GradleDaemonJvmPropertiesImpl(null, null);

    private GradleDaemonJvmPropertiesFile() {
    }

    @JvmStatic
    @NotNull
    public static final GradleDaemonJvmProperties getProperties(@NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Path propertiesPath = GradleDaemonJvmPropertiesFile.getPropertyPath(externalProjectPath2);
        GradleDaemonJvmProperties gradleDaemonJvmProperties = INSTANCE.loadGradleDaemonJvmProperties(propertiesPath);
        if (gradleDaemonJvmProperties == null) {
            gradleDaemonJvmProperties = EMPTY;
        }
        return gradleDaemonJvmProperties;
    }

    @JvmStatic
    @NotNull
    public static final Path getPropertyPath(@NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        String[] stringArray = new String[]{"gradle-daemon-jvm.properties"};
        Path path = externalProjectPath2.resolve(Paths.get("gradle", stringArray)).toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }

    private final GradleDaemonJvmProperties loadGradleDaemonJvmProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return null;
        }
        Properties properties2 = properties;
        return new GradleDaemonJvmPropertiesImpl(PropertyKt.getStringProperty(properties2, "toolchainVersion", propertiesPath), PropertyKt.getStringProperty(properties2, "toolchainVendor", propertiesPath));
    }
}

