/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.google.gson.GsonBuilder;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.FileDownloadEventImpl;
import com.intellij.build.events.impl.FileDownloadedEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleDownloadProgressMapper;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionProgressMapper;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.statistics.GradleModelBuilderMessageCollector;
import org.jetbrains.plugins.gradle.tooling.Message;

public class GradleProgressListener
implements ProgressListener,
org.gradle.tooling.ProgressListener {
    private static final Logger LOG = Logger.getInstance(GradleProgressListener.class);
    public static final String SEND_PROGRESS_EVENTS_TO_OUTPUT_KEY = "gradle.output.sync.progress.events";
    private final GradleDownloadProgressMapper myDownloadProgressMapper;
    private final ExternalSystemTaskNotificationListener myListener;
    private final GradleExecutionProgressMapper myProgressMapper;
    private final ExternalSystemTaskId myTaskId;
    private final Map<Object, Long> myStatusEventIds;
    private final String myOperationId;
    @NotNull
    private final String myBuildRootDirPath;
    private static final String EXECUTING_BUILD = "Build";
    private static final String STARTING_GRADLE_DAEMON_EVENT = "Starting Gradle Daemon";
    private ExternalSystemTaskNotificationEvent myLastStatusChange;
    private final boolean sendProgressEventsToOutput;

    @Deprecated
    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId) {
        if (listener2 == null) {
            GradleProgressListener.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(1);
        }
        this(listener2, taskId, "");
    }

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId, @NotNull String buildRootDir) {
        if (listener2 == null) {
            GradleProgressListener.$$$reportNull$$$0(2);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(3);
        }
        if (buildRootDir == null) {
            GradleProgressListener.$$$reportNull$$$0(4);
        }
        this.myStatusEventIds = new HashMap<Object, Long>();
        this.myLastStatusChange = null;
        this.myListener = listener2;
        this.myTaskId = taskId;
        this.myOperationId = taskId.hashCode() + ":" + FileUtil.pathHashCode((String)buildRootDir);
        this.myProgressMapper = new GradleExecutionProgressMapper();
        this.myDownloadProgressMapper = new GradleDownloadProgressMapper();
        this.myBuildRootDirPath = buildRootDir;
        this.sendProgressEventsToOutput = Registry.is((String)SEND_PROGRESS_EVENTS_TO_OUTPUT_KEY, (boolean)true);
    }

    public void statusChanged(ProgressEvent event) {
        ExternalSystemTaskNotificationEvent taskNotificationEvent;
        ExternalSystemBuildEvent downloadEvent;
        if (this.myDownloadProgressMapper.canMap(event) && (downloadEvent = this.myDownloadProgressMapper.map(this.myTaskId, event)) != null) {
            this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)downloadEvent);
            if (this.sendProgressEventsToOutput) {
                this.sendProgressEventToOutput((ExternalSystemTaskNotificationEvent)downloadEvent);
            }
            return;
        }
        ExternalSystemTaskNotificationEvent progressBuildEvent = this.myProgressMapper.map(this.myTaskId, event);
        if (progressBuildEvent != null && !progressBuildEvent.equals((Object)this.myLastStatusChange)) {
            this.myListener.onStatusChange(progressBuildEvent);
            this.myLastStatusChange = progressBuildEvent;
        }
        if ((taskNotificationEvent = GradleProgressEventConverter.createTaskNotificationEvent(this.myTaskId, this.myOperationId, event)) != null) {
            this.myListener.onStatusChange(taskNotificationEvent);
        }
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        String eventDescription = event.getDescription();
        if (!this.maybeReportModelBuilderMessage(eventDescription)) {
            ExternalSystemTaskNotificationEvent progressBuildEvent = this.myProgressMapper.mapLegacyEvent(this.myTaskId, eventDescription);
            if (progressBuildEvent != null && !progressBuildEvent.equals((Object)this.myLastStatusChange)) {
                this.myListener.onStatusChange(progressBuildEvent);
                this.myLastStatusChange = progressBuildEvent;
            }
            ExternalSystemTaskNotificationEvent taskNotificationEvent = GradleProgressEventConverter.legacyConvertTaskNotificationEvent(this.myTaskId, eventDescription);
            this.myListener.onStatusChange(taskNotificationEvent);
            if (this.sendProgressEventsToOutput) {
                this.reportGradleDaemonStartingEvent(eventDescription);
            }
        }
    }

    private boolean maybeReportModelBuilderMessage(String eventDescription) {
        Message message = GradleProgressListener.parseModelBuilderMessage(eventDescription);
        if (message == null) {
            return false;
        }
        this.reportModelBuilderMessageToFus(message);
        GradleProgressListener.reportModelBuilderMessageToLogger(message);
        this.reportModelBuilderMessageToListener(message);
        return true;
    }

    @Nullable
    private static Message parseModelBuilderMessage(String eventDescription) {
        if (!eventDescription.startsWith("ModelBuilderService message: ")) {
            return null;
        }
        String messageString = StringUtil.substringAfter((String)eventDescription, (String)"ModelBuilderService message: ");
        try {
            return (Message)new GsonBuilder().create().fromJson(messageString, Message.class);
        }
        catch (Exception e) {
            LOG.warn("Failed to report model builder message using event '" + eventDescription + "'", (Throwable)e);
            return null;
        }
    }

    private void reportModelBuilderMessageToFus(@NotNull Message message) {
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(5);
        }
        GradleModelBuilderMessageCollector.logModelBuilderMessage(this.myTaskId.findProject(), this.myTaskId.getId(), message);
    }

    private static void reportModelBuilderMessageToLogger(@NotNull Message message) {
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(6);
        }
        String text = message.getGroup() + "\n" + message.getTitle() + "\n" + message.getText();
        if (message.isInternal() && message.getKind() == Message.Kind.ERROR) {
            LOG.error(text, new Throwable());
        } else {
            LOG.debug(text);
        }
    }

    private void reportModelBuilderMessageToListener(@NotNull Message message) {
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(7);
        }
        if (!message.isInternal()) {
            BuildIssueEvent messageEvent = this.getModelBuilderErrorMessage(message);
            if (messageEvent == null) {
                messageEvent = this.getModelBuilderMessage(message);
            }
            this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myTaskId, (BuildEvent)messageEvent));
        }
    }

    @NotNull
    private MessageEvent getModelBuilderMessage(@NotNull Message message) {
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(8);
        }
        MessageEvent.Kind kind = MessageEvent.Kind.valueOf((String)message.getKind().name());
        Message.FilePosition messageFilePosition = message.getFilePosition();
        final FilePosition filePosition = messageFilePosition == null ? null : new FilePosition(new File(messageFilePosition.getFilePath()), messageFilePosition.getLine(), messageFilePosition.getColumn());
        return new MessageEventImpl(this, this.myTaskId, kind, message.getGroup(), message.getTitle(), message.getText()){

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (filePosition == null) {
                    return null;
                }
                return new FileNavigatable(project, filePosition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener$1", "getNavigatable"));
            }
        };
    }

    @Nullable
    private BuildIssueEvent getModelBuilderErrorMessage(@NotNull Message message) {
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(9);
        }
        if (message.getKind() != Message.Kind.ERROR) {
            return null;
        }
        GradleIssueData issueData = this.getGradleIssueData(message);
        for (GradleIssueChecker checker : GradleIssueChecker.getKnownIssuesCheckList()) {
            BuildIssue buildIssue = checker.check(issueData);
            if (buildIssue == null) continue;
            return new BuildIssueEventImpl((Object)this.myTaskId, buildIssue, MessageEvent.Kind.ERROR);
        }
        return null;
    }

    @NotNull
    private GradleIssueData getGradleIssueData(@NotNull Message message) {
        GradleIssueData issueData;
        if (message == null) {
            GradleProgressListener.$$$reportNull$$$0(10);
        }
        String errorText = StringUtil.notNullize((String)message.getText(), (String)message.getTitle());
        RuntimeException syntheticError = new RuntimeException(errorText);
        Message.FilePosition position = message.getFilePosition();
        FilePosition filePosition = position == null ? null : new FilePosition(new File(position.getFilePath()), position.getLine(), position.getColumn());
        GradleIssueData gradleIssueData = issueData = new GradleIssueData(this.myBuildRootDirPath, syntheticError, null, filePosition);
        if (gradleIssueData == null) {
            GradleProgressListener.$$$reportNull$$$0(11);
        }
        return gradleIssueData;
    }

    private void sendProgressEventToOutput(ExternalSystemTaskNotificationEvent event) {
        if (event instanceof ExternalSystemBuildEvent) {
            BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
            if (buildEvent instanceof FileDownloadedEventImpl) {
                long duration = ((FileDownloadedEventImpl)buildEvent).getDuration();
                String operationName = buildEvent.getMessage();
                String text = String.format("%s, took %s", operationName, StringUtil.formatDuration((long)duration));
                this.myListener.onTaskOutput(this.myTaskId, "\r" + text + "\n", ProcessOutputType.STDOUT);
            }
            if (buildEvent instanceof FileDownloadEventImpl) {
                long progress = ((FileDownloadEventImpl)buildEvent).getProgress();
                long total = ((FileDownloadEventImpl)buildEvent).getTotal();
                String operationName = buildEvent.getMessage();
                String text = String.format("%s (%s / %s)", operationName, GradleProgressListener.formatFileSize(progress), GradleProgressListener.formatFileSize(total));
                if (((FileDownloadEventImpl)buildEvent).isFirstInGroup()) {
                    this.myListener.onTaskOutput(this.myTaskId, text, ProcessOutputType.STDOUT);
                } else {
                    this.myListener.onTaskOutput(this.myTaskId, "\r" + text, ProcessOutputType.STDOUT);
                }
            }
        }
    }

    private void reportGradleDaemonStartingEvent(String eventDescription) {
        if (StringUtil.equals((CharSequence)STARTING_GRADLE_DAEMON_EVENT, (CharSequence)eventDescription) && !this.myStatusEventIds.containsKey(STARTING_GRADLE_DAEMON_EVENT)) {
            this.myListener.onTaskOutput(this.myTaskId, "Starting Gradle Daemon...\n", ProcessOutputType.STDOUT);
            this.myStatusEventIds.put(STARTING_GRADLE_DAEMON_EVENT, System.currentTimeMillis());
        } else if (StringUtil.equals((CharSequence)EXECUTING_BUILD, (CharSequence)eventDescription) && this.myStatusEventIds.containsKey(STARTING_GRADLE_DAEMON_EVENT)) {
            Long startTime = this.myStatusEventIds.remove(STARTING_GRADLE_DAEMON_EVENT);
            String duration = StringUtil.formatDuration((long)(System.currentTimeMillis() - startTime));
            this.myListener.onTaskOutput(this.myTaskId, "\rGradle Daemon started in " + duration + "\n", ProcessOutputType.STDOUT);
        }
    }

    @NotNull
    private static String formatFileSize(@NotNull Long value) {
        if (value == null) {
            GradleProgressListener.$$$reportNull$$$0(12);
        }
        String string = StringUtil.formatFileSize((long)value, (String)" ", (int)-1, (boolean)true);
        if (string == null) {
            GradleProgressListener.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootDir";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleIssueData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportModelBuilderMessageToFus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportModelBuilderMessageToLogger";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportModelBuilderMessageToListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilderMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilderErrorMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGradleIssueData";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13 -> new IllegalStateException(string);
        };
    }
}

