/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.util.io.DigestUtil;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/collaboration/auth/services/PkceUtils;", "", "<init>", "()V", "generateCodeVerifier", "", "generateShaCodeChallenge", "codeVerifier", "encoder", "Ljava/util/Base64$Encoder;", "intellij.platform.collaborationTools.auth"})
public final class PkceUtils {
    @NotNull
    public static final PkceUtils INSTANCE = new PkceUtils();

    private PkceUtils() {
    }

    @NotNull
    public final String generateCodeVerifier() {
        return DigestUtil.randomToken();
    }

    @NotNull
    public final String generateShaCodeChallenge(@NotNull String codeVerifier, @NotNull Base64.Encoder encoder) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        MessageDigest messageDigest = DigestUtil.sha256();
        String string = codeVerifier;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] sha = messageDigest.digest(byArray);
        String string2 = encoder.encodeToString(sha);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }
}

