/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.config.processor;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.spring.boot.properties.datasource.config.SpringBootDataSourceDatabaseConfigPropertiesKt;
import com.intellij.spring.boot.properties.datasource.config.processor.DataSourceSettingsFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/properties/datasource/config/processor/RelationalDataSourceSettingsFormatter;", "Lcom/intellij/spring/boot/properties/datasource/config/processor/DataSourceSettingsFormatter;", "<init>", "()V", "format", "", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "canProcess", "", "intellij.spring.boot.properties.datasource"})
public final class RelationalDataSourceSettingsFormatter
implements DataSourceSettingsFormatter {
    @Override
    @NotNull
    public Map<String, String> format(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Pair[] pairArray = new Pair[4];
        String string = dataSource.getUrl();
        if (string == null) {
            string = "";
        }
        pairArray[0] = TuplesKt.to((Object)"spring.datasource.url", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"spring.datasource.username", (Object)dataSource.getUsername());
        pairArray[2] = TuplesKt.to((Object)"spring.datasource.password", (Object)"");
        String string2 = dataSource.getDriverClass();
        if (string2 == null) {
            string2 = "";
        }
        pairArray[3] = TuplesKt.to((Object)"spring.datasource.driver-class-name", (Object)string2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean canProcess(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return SpringBootDataSourceDatabaseConfigPropertiesKt.isRelational(dbms);
    }
}

