/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.config.provider;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.config.impl.RecognizedDataSourceConfigProviderImpl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.spring.boot.properties.datasource.SpringBootConfigPropertyValueSearcher;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCommonDataSourceConfigProvider;", "Lcom/intellij/persistence/database/config/impl/RecognizedDataSourceConfigProviderImpl;", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "<init>", "()V", "guessSampleUrl", "", "driverClass", "propertySearcher", "Lcom/intellij/spring/boot/properties/datasource/SpringBootConfigPropertyValueSearcher;", "guessDefaultDatasourceName", "url", "guessDriverClass", "tryToRetrieveDatabase", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseType;", "intellij.spring.boot.properties.datasource"})
@SourceDebugExtension(value={"SMAP\nSpringBootCommonDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootCommonDataSourceConfigProvider.kt\ncom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCommonDataSourceConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n296#2,2:45\n1#3:47\n*S KotlinDebug\n*F\n+ 1 SpringBootCommonDataSourceConfigProvider.kt\ncom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCommonDataSourceConfigProvider\n*L\n20#1:45,2\n*E\n"})
public abstract class SpringBootCommonDataSourceConfigProvider
extends RecognizedDataSourceConfigProviderImpl<ConfigDataSourcePropertyInfo> {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String guessSampleUrl(@Nullable String driverClass, @NotNull SpringBootConfigPropertyValueSearcher propertySearcher) {
        DatabaseType databaseType;
        Intrinsics.checkNotNullParameter((Object)((Object)propertySearcher), (String)"propertySearcher");
        if (driverClass != null) {
            Object v1;
            block3: {
                void $this$firstOrNull$iv;
                Collection collection = DatabaseDriverManager.getInstance().getDrivers();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
                Iterable iterable = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DatabaseDriver databaseDriver = (DatabaseDriver)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)databaseDriver.getDriverClass(), (Object)driverClass)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            DatabaseDriver driver = v1;
            if (driver != null) {
                DatabaseDriver it = driver;
                return it.getSampleUrl();
            }
        }
        DatabaseType databaseType2 = databaseType = this.tryToRetrieveDatabase(propertySearcher);
        DatabaseType databaseType3 = databaseType2;
        if (databaseType2 == null) return null;
        DatabaseType it = databaseType3;
        boolean bl = false;
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)databaseType);
        databaseType3 = databaseDriver;
        if (databaseDriver == null) return null;
        String string = databaseType3.getSampleUrl();
        return string;
    }

    @NotNull
    protected final String guessDefaultDatasourceName(@NotNull String url, @NotNull SpringBootConfigPropertyValueSearcher propertySearcher) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)propertySearcher), (String)"propertySearcher");
        DatabaseType databaseType = this.findFirstApplicableDbTypeOrDefault(url);
        if (databaseType == null && (databaseType = this.tryToRetrieveDatabase(propertySearcher)) == null) {
            return "unknown";
        }
        DatabaseType databaseType2 = databaseType;
        String string = databaseType2.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @Nullable
    protected final String guessDriverClass(@NotNull String url, @NotNull SpringBootConfigPropertyValueSearcher propertySearcher) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)propertySearcher), (String)"propertySearcher");
        DatabaseType databaseType = this.findFirstApplicableDbTypeOrDefault(url);
        if (databaseType == null && (databaseType = this.tryToRetrieveDatabase(propertySearcher)) == null) {
            return null;
        }
        DatabaseType dbType = databaseType;
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)dbType);
        return databaseDriver != null ? databaseDriver.getDriverClass() : null;
    }

    private final DatabaseType tryToRetrieveDatabase(SpringBootConfigPropertyValueSearcher propertySearcher) {
        DatabaseType databaseType;
        String databaseName;
        String string = databaseName = propertySearcher.find("spring.jpa.database");
        if (string != null) {
            String it = string;
            boolean bl = false;
            return this.findFirstApplicableDbTypeOrDefault(databaseName);
        }
        String string2 = propertySearcher.find("spring.jpa.database-platform");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            databaseType = this.findFirstApplicableDbTypeOrDefault(it);
        } else {
            databaseType = null;
        }
        return databaseType;
    }
}

