/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.metrics;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.Metric;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricType;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricsStatus;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.providers.MetricProvider;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.unattendedHost.metrics.CpuMetricsProvider;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\b\u0005*\u0002\u0018\u001f\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider;", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/providers/MetricProvider;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "laUpdate", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "laProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$LaData;", "initialized", "", "getMetrics", "", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/Metric;", "readLaFromUnix", "", "loadMetric", "com/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$loadMetric$1", "status", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;", "value", "", "(Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;D)Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$loadMetric$1;", "cpuMetric", "com/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$cpuMetric$1", "(Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;D)Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$cpuMetric$1;", "Companion", "LaData", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nCpuMetricsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuMetricsProvider.kt\ncom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1586#2:129\n1661#2,3:130\n*S KotlinDebug\n*F\n+ 1 CpuMetricsProvider.kt\ncom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider\n*L\n102#1:129\n102#1:130,3\n*E\n"})
public final class CpuMetricsProvider
implements MetricProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue laUpdate;
    @NotNull
    private final Property<LaData> laProperty;
    private boolean initialized;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String AVAILABLE_PROCESSORS = "availableProcessors";
    @NotNull
    public static final String LOAD_AVERAGE_1 = "loadAverage1";
    @NotNull
    public static final String LOAD_AVERAGE_5 = "loadAverage5";
    @NotNull
    public static final String LOAD_AVERAGE_15 = "loadAverage15";
    @NotNull
    public static final String SYSTEM_CPU_LOAD = "systemCpuLoad";

    public CpuMetricsProvider() {
        this.id = "cpuMetrics";
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"CpuMetricsProviderQueue");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.laUpdate = new MergingUpdateQueue(string, 10000, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, false);
        this.laProperty = new Property((Object)new LaData(0.0, 0.0, 0.0));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Map<String, Metric> getMetrics() {
        LOG.trace("Updating CPU data");
        if (!this.initialized) {
            if (SystemInfoRt.isUnix) {
                this.readLaFromUnix();
            }
            this.initialized = true;
        }
        this.laUpdate.queue(Update.Companion.create((Object)"laUpdate", () -> CpuMetricsProvider.getMetrics$lambda$0(this)));
        Map metrics = new LinkedHashMap();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystemMXBean, (String)"getPlatformMXBean(...)");
        OperatingSystemMXBean mxBean = operatingSystemMXBean;
        int availableProcessors = mxBean.getAvailableProcessors();
        Metric availableProcessorsMetric = new Metric(MetricType.PERFORMANCE, MetricsStatus.NORMAL, (Object)availableProcessors);
        metrics.put(AVAILABLE_PROCESSORS, availableProcessorsMetric);
        if (!SystemInfo.isWindows) {
            double la1Min = ((LaData)this.laProperty.getValue()).getLa1();
            loadMetric.1 la1Metric = this.loadMetric(MetricProvider.Companion.calculateMetricStatus((Comparable)Double.valueOf(la1Min), (Comparable)Double.valueOf(0.7 * (double)availableProcessors), (Comparable)Double.valueOf(1.0 * (double)availableProcessors)), la1Min);
            metrics.put(LOAD_AVERAGE_1, la1Metric);
            double la5Min = ((LaData)this.laProperty.getValue()).getLa5();
            loadMetric.1 la5Metric = this.loadMetric(MetricsStatus.NORMAL, la5Min);
            metrics.put(LOAD_AVERAGE_5, la5Metric);
            double la15Min = ((LaData)this.laProperty.getValue()).getLa15();
            loadMetric.1 la15Metric = this.loadMetric(MetricsStatus.NORMAL, la15Min);
            metrics.put(LOAD_AVERAGE_15, la15Metric);
        }
        double cpuLoad = mxBean.getCpuLoad() * (double)100;
        cpuMetric.1 cpuLoadMetric = this.cpuMetric(MetricProvider.Companion.calculateMetricStatus((Comparable)Double.valueOf(cpuLoad), (Comparable)Double.valueOf(80.0), (Comparable)Double.valueOf(95.0)), cpuLoad);
        metrics.put(SYSTEM_CPU_LOAD, cpuLoadMetric);
        return metrics;
    }

    /*
     * WARNING - void declaration
     */
    private final void readLaFromUnix() {
        try {
            Process process = Runtime.getRuntime().exec("uptime");
            boolean isExited = process.waitFor(10L, TimeUnit.SECONDS);
            if (isExited) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                byte[] byArray = process.getInputStream().readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                Object object = (String[])((Object)StringsKt.trim((CharSequence)StringsKt.substringAfterLast$default((String)StringsKt.decodeToString((byte[])byArray), (String)":", null, (int)2, null))).toString();
                Regex regex = new Regex("[\n\r]+");
                String string = "";
                object = regex.replace((CharSequence)object, string);
                regex = new Regex(", ");
                string = " ";
                object = regex.replace((CharSequence)object, string);
                regex = new Regex(",");
                string = ".";
                CharSequence charSequence = regex.replace((CharSequence)object, string);
                object = new String[]{" "};
                object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                string = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Double.parseDouble((String)it));
                }
                List psOutput = (List)destination$iv$iv;
                this.laProperty.set((Object)new LaData(((Number)psOutput.get(0)).doubleValue(), ((Number)psOutput.get(1)).doubleValue(), ((Number)psOutput.get(2)).doubleValue()));
            } else {
                LOG.warn("Failed waiting uptime to finish for reading LA metric");
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to run uptime or read its output for reading LA metric", e);
        }
    }

    private final loadMetric.1 loadMetric(MetricsStatus status, double value) {
        MetricType metricType = MetricType.PERFORMANCE;
        return new Metric(status, value, metricType){

            public String toString() {
                Object[] objectArray = new Object[1];
                String string = "%.2f";
                Object[] objectArray2 = new Object[]{this.getValueProperty().getValue()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                return PlatformSplitBundle.INSTANCE.message("metrics.load.average.label", objectArray);
            }
        };
    }

    private final cpuMetric.1 cpuMetric(MetricsStatus status, double value) {
        MetricType metricType = MetricType.PERFORMANCE;
        return new Metric(status, value, metricType){

            public String toString() {
                Object[] objectArray = new Object[1];
                String string = "%.1f";
                Object[] objectArray2 = new Object[]{this.getValueProperty().getValue()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                return PlatformSplitBundle.INSTANCE.message("metrics.cpu.label", objectArray);
            }
        };
    }

    private static final void getMetrics$lambda$0(CpuMetricsProvider this$0) {
        if (SystemInfoRt.isUnix) {
            this$0.readLaFromUnix();
        }
    }

    static {
        Logger logger = Logger.getInstance(CpuMetricsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "AVAILABLE_PROCESSORS", "", "LOAD_AVERAGE_1", "LOAD_AVERAGE_5", "LOAD_AVERAGE_15", "SYSTEM_CPU_LOAD", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/CpuMetricsProvider$LaData;", "", "la1", "", "la5", "la15", "<init>", "(DDD)V", "getLa1", "()D", "getLa5", "getLa15", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.remoteController.backend"})
    private static final class LaData {
        private final double la1;
        private final double la5;
        private final double la15;

        public LaData(double la1, double la5, double la15) {
            this.la1 = la1;
            this.la5 = la5;
            this.la15 = la15;
        }

        public final double getLa1() {
            return this.la1;
        }

        public final double getLa5() {
            return this.la5;
        }

        public final double getLa15() {
            return this.la15;
        }

        public final double component1() {
            return this.la1;
        }

        public final double component2() {
            return this.la5;
        }

        public final double component3() {
            return this.la15;
        }

        @NotNull
        public final LaData copy(double la1, double la5, double la15) {
            return new LaData(la1, la5, la15);
        }

        public static /* synthetic */ LaData copy$default(LaData laData, double d, double d2, double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = laData.la1;
            }
            if ((n & 2) != 0) {
                d2 = laData.la5;
            }
            if ((n & 4) != 0) {
                d3 = laData.la15;
            }
            return laData.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "LaData(la1=" + this.la1 + ", la5=" + this.la5 + ", la15=" + this.la15 + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.la1);
            result = result * 31 + Double.hashCode(this.la5);
            result = result * 31 + Double.hashCode(this.la15);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LaData)) {
                return false;
            }
            LaData laData = (LaData)other;
            if (Double.compare(this.la1, laData.la1) != 0) {
                return false;
            }
            if (Double.compare(this.la5, laData.la5) != 0) {
                return false;
            }
            return Double.compare(this.la15, laData.la15) == 0;
        }
    }
}

