/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.portForwarding.ui;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.portForwarding.utils.ForwardedPortUtil;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.PortForwardingTabState;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.data.ForwardPortUiDataFactory;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.data.ForwardedPortUiData;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J,\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0016J,\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J,\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0011H\u0016J \u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabStateUpdater;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PerClientPortListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "state", "Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabState;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabState;)V", "portAdded", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "port", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "portRemoved", "nameChanged", "oldName", "", "newName", "descriptionChanged", "oldDescription", "newDescription", "iconChanged", "oldIcon", "Ljavax/swing/Icon;", "newIcon", "tooltipChanged", "oldTooltip", "newTooltip", "becameReadOnly", "reason", "exposedUrlChanged", "newUrl", "stateChanged", "newState", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortState;", "findForwardedPortUiDataForPort", "Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/data/ForwardedPortUiData;", "Companion", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nPortForwardingTabStateUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingTabStateUpdater.kt\ncom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabStateUpdater\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,183:1\n23#2:184\n*S KotlinDebug\n*F\n+ 1 PortForwardingTabStateUpdater.kt\ncom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabStateUpdater\n*L\n23#1:184\n*E\n"})
public final class PortForwardingTabStateUpdater
implements PerClientPortListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final PortForwardingTabState state;
    @NotNull
    private static final Logger logger;

    public PortForwardingTabStateUpdater(@NotNull Lifetime lifetime, @NotNull PortForwardingTabState state) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.lifetime = lifetime;
        this.state = state;
    }

    public void portAdded(@NotNull ClientAppSession session, @NotNull ForwardedPort port) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port) || this.state.isSaving()) {
            return;
        }
        ForwardedPortUiData existingForwardedPortUi = this.findForwardedPortUiDataForPort(port);
        if (existingForwardedPortUi == null) {
            ForwardedPortUiData portData = ForwardPortUiDataFactory.INSTANCE.createUiDataFromForwardedPort(this.lifetime, port);
            this.state.addForwardedPort(portData);
        }
    }

    public void portRemoved(@NotNull ClientAppSession session, @NotNull ForwardedPort port) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
            return;
        }
        ForwardedPortUiData portToRemote = this.findForwardedPortUiDataForPort(port);
        if (portToRemote == null) {
            logger.info("Unable to find existing port in table. Nothing to remove.");
            return;
        }
        this.state.removeForwardedPort(portToRemote);
    }

    public void nameChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @Nullable String oldName, @Nullable String newName) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            IProperty<String> iProperty = this.findForwardedPortUiDataForPort(port);
            if (iProperty == null || (iProperty = iProperty.getNameProperty()) == null) break block2;
            String string = newName;
            if (string == null) {
                string = "";
            }
            iProperty.set((Object)string);
        }
    }

    public void descriptionChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @Nullable String oldDescription, @Nullable String newDescription) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            IProperty<String> iProperty = this.findForwardedPortUiDataForPort(port);
            if (iProperty == null || (iProperty = iProperty.getDescriptionProperty()) == null) break block2;
            String string = newDescription;
            if (string == null) {
                string = "";
            }
            iProperty.set((Object)string);
        }
    }

    public void iconChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @Nullable Icon oldIcon, @Nullable Icon newIcon) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            if (newIcon == null) {
                return;
            }
            IProperty<Icon> iProperty = this.findForwardedPortUiDataForPort(port);
            if (iProperty == null || (iProperty = iProperty.getStatusProperty()) == null || (iProperty = iProperty.getIcon()) == null) break block2;
            iProperty.set((Object)newIcon);
        }
    }

    public void tooltipChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @Nullable String oldTooltip, @Nullable String newTooltip) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            Property<String> property = this.findForwardedPortUiDataForPort(port);
            if (property == null || (property = property.getTooltipProperty()) == null) break block1;
            property.set((Object)newTooltip);
        }
    }

    public void becameReadOnly(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
            return;
        }
        ForwardedPortUiData forwardedPort = this.findForwardedPortUiDataForPort(port);
        if (forwardedPort == null) {
            logger.info("Unable to find existing port in table. Nothing to make read-only.");
            return;
        }
        forwardedPort.isReadOnlyProperty().set((Object)true);
        forwardedPort.getTooltipProperty().set((Object)reason);
    }

    public void exposedUrlChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @NotNull String newUrl) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            Property<String> property = this.findForwardedPortUiDataForPort(port);
            if (property == null || (property = property.getLocalPortValueProperty$intellij_platform_remoteController_backend()) == null) break block1;
            property.set((Object)newUrl);
        }
    }

    public void stateChanged(@NotNull ClientAppSession session, @NotNull ForwardedPort port, @NotNull ServerSocketPortState newState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            if (ForwardedPortUtil.INSTANCE.isNonUserTcpPort(port)) {
                return;
            }
            ForwardedPortUiData forwardedPortUiData = this.findForwardedPortUiDataForPort(port);
            if (forwardedPortUiData == null) break block1;
            forwardedPortUiData.updateStateDependentData(newState);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ForwardedPortUiData findForwardedPortUiDataForPort(ForwardedPort port) {
        block3: {
            targetForwardedPortsList = PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)port.getConfiguration()) != false ? this.state.getReverseForwardPorts() : (PortConfigurationKt.isExposedPort((PortConfiguration)port.getConfiguration()) != false ? this.state.getExposedPorts() : this.state.getDirectForwardPorts());
            var4_3 = (Iterable)targetForwardedPortsList;
            for (T var6_5 : var4_3) {
                data = (ForwardedPortUiData)var6_5;
                $i$a$-find-PortForwardingTabStateUpdater$findForwardedPortUiDataForPort$forwardedPortUiData$1 = false;
                v0 = (ForwardedPort)data.getForwardedPortProperty().getValue();
                if (v0 != null ? Integer.valueOf(v0.getTargetPortNumber()).equals(port) : false) ** GOTO lbl-1000
                v1 = StringsKt.toIntOrNull((String)((String)data.getRemotePortValueProperty$intellij_platform_remoteController_backend().getValue()));
                v2 = v1 != null ? v1.equals(port.getTargetPortNumber()) : false;
                if (v2) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (!v3) continue;
                v4 = var6_5;
                break block3;
            }
            v4 = null;
        }
        v5 = forwardedPortUiData = (Property<ForwardedPort>)v4;
        PortForwardingTabStateUpdater.logger.info("Found the following forwarded port (name: " + (v5 != null ? v5.getName() : null) + ") in table: <" + ((v6 = forwardedPortUiData) != null && (v6 = v6.getForwardedPortProperty()) != null ? (ForwardedPort)v6.getValue() : null) + ">");
        return forwardedPortUiData;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingTabStateUpdater.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingTabStateUpdater$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

