/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.inject;

import com.intellij.microservices.jvm.inject.InjectionCommandContext;
import com.intellij.microservices.jvm.inject.InjectionUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.uast.UastSmartPointer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0014\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$J\u0006\u0010%\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001bR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "", "uClass", "Lorg/jetbrains/uast/UClass;", "project", "Lcom/intellij/openapi/project/Project;", "containingFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "commandContext", "Lcom/intellij/microservices/jvm/inject/InjectionCommandContext;", "isInsertName", "", "elementAtCaret", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/microservices/jvm/inject/InjectionCommandContext;ZLcom/intellij/psi/SmartPsiElementPointer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getContainingFile", "()Lcom/intellij/psi/PsiFile;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getCommandContext", "()Lcom/intellij/microservices/jvm/inject/InjectionCommandContext;", "()Z", "getElementAtCaret", "()Lcom/intellij/psi/SmartPsiElementPointer;", "uClassPointer", "Lcom/intellij/uast/UastSmartPointer;", "getUClass", "()Lorg/jetbrains/uast/UClass;", "executeCommand", "command", "Ljava/util/function/Supplier;", "isValid", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nInjectionGeneratorContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionGeneratorContext.kt\ncom/intellij/microservices/jvm/inject/InjectionGeneratorContext\n+ 2 UastSmartPointer.kt\ncom/intellij/uast/UastSmartPointerKt\n*L\n1#1,38:1\n20#2:39\n*S KotlinDebug\n*F\n+ 1 InjectionGeneratorContext.kt\ncom/intellij/microservices/jvm/inject/InjectionGeneratorContext\n*L\n22#1:39\n*E\n"})
public final class InjectionGeneratorContext {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile containingFile;
    @NotNull
    private final Editor editor;
    @NotNull
    private final InjectionCommandContext commandContext;
    private final boolean isInsertName;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> elementAtCaret;
    @NotNull
    private final UastSmartPointer<UClass> uClassPointer;

    public InjectionGeneratorContext(@NotNull UClass uClass, @NotNull Project project, @NotNull PsiFile containingFile, @NotNull Editor editor, @NotNull InjectionCommandContext commandContext, boolean isInsertName, @Nullable SmartPsiElementPointer<PsiElement> elementAtCaret) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"commandContext");
        this.project = project;
        this.containingFile = containingFile;
        this.editor = editor;
        this.commandContext = commandContext;
        this.isInsertName = isInsertName;
        this.elementAtCaret = elementAtCaret;
        UElement $this$createUastSmartPointer$iv = (UElement)uClass;
        boolean $i$f$createUastSmartPointer = false;
        this.uClassPointer = new UastSmartPointer($this$createUastSmartPointer$iv, UClass.class);
    }

    public /* synthetic */ InjectionGeneratorContext(UClass uClass, Project project, PsiFile psiFile, Editor editor, InjectionCommandContext injectionCommandContext, boolean bl, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            PsiElement psiElement = InjectionUtilsKt.getElementAtCaret(editor);
            smartPsiElementPointer = psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null;
        }
        this(uClass, project, psiFile, editor, injectionCommandContext, bl, (SmartPsiElementPointer<PsiElement>)smartPsiElementPointer);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getContainingFile() {
        return this.containingFile;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final InjectionCommandContext getCommandContext() {
        return this.commandContext;
    }

    public final boolean isInsertName() {
        return this.isInsertName;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> getElementAtCaret() {
        return this.elementAtCaret;
    }

    @Nullable
    public final UClass getUClass() {
        return (UClass)this.uClassPointer.getElement();
    }

    public final boolean executeCommand(@NotNull Supplier<Boolean> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        if (!this.isValid()) {
            return false;
        }
        Ref.BooleanRef result = new Ref.BooleanRef();
        result.element = true;
        CommandProcessor.getInstance().executeCommand(this.project, () -> InjectionGeneratorContext.executeCommand$lambda$0(result, command), this.commandContext.getCommandName(), this.commandContext.getCommandScope());
        return result.element;
    }

    public final boolean isValid() {
        return !this.editor.isDisposed() && PsiDocumentManager.getInstance((Project)this.project).isCommitted(this.editor.getDocument());
    }

    private static final Boolean executeCommand$lambda$0$0(Supplier $command) {
        return (Boolean)$command.get();
    }

    private static final void executeCommand$lambda$0(Ref.BooleanRef $result, Supplier $command) {
        Object object = ActionsKt.runWriteAction(() -> InjectionGeneratorContext.executeCommand$lambda$0$0((Supplier)$command));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        $result.element = (Boolean)object;
    }
}

