/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.pathvars.InplaceRenameQuickFix;
import com.intellij.microservices.jvm.pathvars.PathVariableConsumerInfo;
import com.intellij.microservices.jvm.pathvars.PathVariableContext;
import com.intellij.microservices.jvm.pathvars.PathVariableMethodInspection$createRenameQuickfix$;
import com.intellij.microservices.jvm.pathvars.PathVariableQuickFix;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u001d\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0004J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "pathVariableContext", "Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "<init>", "(Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;)V", "getPathVariableContext", "()Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "method", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "highlightUnconsumedPathVariables", "", "unusedDeclarations", "", "", "highlightUndeclaredUsages", "undeclaredUsages", "", "Lcom/intellij/microservices/jvm/pathvars/PathVariableConsumerInfo;", "createRenameQuickfix", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiElement", "Lcom/intellij/psi/PsiElement;", "pathVariableName", "getAdditionallyConsumedPathVariables", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,138:1\n479#2:139\n*S KotlinDebug\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection\n*L\n91#1:139\n*E\n"})
public abstract class PathVariableMethodInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    private final PathVariableContext pathVariableContext;

    public PathVariableMethodInspection(@NotNull PathVariableContext pathVariableContext) {
        Intrinsics.checkNotNullParameter((Object)pathVariableContext, (String)"pathVariableContext");
        Class[] classArray = new Class[]{UMethod.class};
        super(classArray);
        this.pathVariableContext = pathVariableContext;
    }

    @NotNull
    protected final PathVariableContext getPathVariableContext() {
        return this.pathVariableContext;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!this.pathVariableContext.isApplicable(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @NotNull
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Map consumersMap;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UrlPathContext urlPathContext = this.pathVariableContext.getUrlPathContext(method);
        if (urlPathContext.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Set allDeclaredPathVariableNamesForContext = CollectionsKt.toSet((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext));
        if (Intrinsics.areEqual((Object)allDeclaredPathVariableNamesForContext, (consumersMap = MapsKt.plus(this.pathVariableContext.getConsumedPathVariables(method), this.getAdditionallyConsumedPathVariables(method))).keySet())) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)psiElement, isOnTheFly);
        Map undeclaredUsages = MapsKt.minus((Map)consumersMap, (Iterable)allDeclaredPathVariableNamesForContext);
        Set unusedDeclarations = SetsKt.minus((Set)allDeclaredPathVariableNamesForContext, (Iterable)consumersMap.keySet());
        this.highlightUndeclaredUsages(undeclaredUsages, unusedDeclarations, holder);
        this.highlightUnconsumedPathVariables(method, unusedDeclarations, holder);
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }

    private final void highlightUnconsumedPathVariables(UMethod method, Set<String> unusedDeclarations, ProblemsHolder holder) {
        Set<String> occupiedParameters = this.pathVariableContext.getOccupiedParameters(method, unusedDeclarations);
        for (String unConsumedVariable : unusedDeclarations) {
            Object[] objectArray;
            Object[] objectArray2;
            Pair<PsiElement, TextRange> pair;
            if (this.pathVariableContext.mayResolveToMethodBeanField(method.getJavaPsi(), unConsumedVariable) || this.pathVariableContext.getUnconsumedPathVariablePsiElement(method, unConsumedVariable) == null) continue;
            PsiElement psiElement = (PsiElement)pair.component1();
            TextRange range = (TextRange)pair.component2();
            if (!occupiedParameters.contains(unConsumedVariable)) {
                objectArray2 = new PathVariableQuickFix[]{new PathVariableQuickFix(unConsumedVariable, this.pathVariableContext)};
                objectArray = objectArray2;
            } else {
                objectArray = new PathVariableQuickFix[]{};
            }
            PathVariableQuickFix[] fixes = objectArray;
            objectArray2 = new Object[]{unConsumedVariable};
            String string = MicroservicesBundle.message((String)"PathVariableReference.unconsumed.path.variable", (Object[])objectArray2);
            TextRange textRange = range;
            if (textRange == null) {
                TextRange textRange2 = ElementManipulators.getValueTextRange((PsiElement)psiElement);
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getValueTextRange(...)");
            }
            holder.registerProblem(psiElement, string, ProblemHighlightType.WEAK_WARNING, textRange, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
        }
    }

    private final void highlightUndeclaredUsages(Map<String, PathVariableConsumerInfo> undeclaredUsages, Set<String> unusedDeclarations, ProblemsHolder holder) {
        for (Map.Entry<String, PathVariableConsumerInfo> entry : undeclaredUsages.entrySet()) {
            String pathVariableName = entry.getKey();
            PathVariableConsumerInfo consumerInfo = entry.getValue();
            if (consumerInfo.getAnchor() == null || !consumerInfo.getReportIfNotDeclared()) continue;
            Object[] objectArray = new Object[]{pathVariableName};
            String string = MicroservicesBundle.message((String)"PathVariableInspection.cannot.resolve", (Object[])objectArray);
            objectArray = LocalQuickFix.notNullElements((LocalQuickFix)this.createRenameQuickfix(consumerInfo.getAnchor(), pathVariableName, unusedDeclarations));
            holder.registerProblem(consumerInfo.getAnchor(), string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    @Nullable
    protected final LocalQuickFix createRenameQuickfix(@NotNull PsiElement psiElement, @NotNull String pathVariableName, @NotNull Set<String> unusedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        Intrinsics.checkNotNullParameter(unusedDeclarations, (String)"unusedDeclarations");
        if (unusedDeclarations.isEmpty()) {
            return null;
        }
        Sequence $this$filterIsInstance$iv = SequencesKt.take((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true), (int)2);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)createRenameQuickfix$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        PsiNamedElement psiNamedElement = (PsiNamedElement)SequencesKt.firstOrNull((Sequence)sequence2);
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement namedElement = psiNamedElement;
        return (LocalQuickFix)new InplaceRenameQuickFix(namedElement, pathVariableName, (Iterable<String>)unusedDeclarations);
    }

    @NotNull
    protected Map<String, PathVariableConsumerInfo> getAdditionallyConsumedPathVariables(@NotNull UMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return MapsKt.emptyMap();
    }
}

