/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.interaction.SshPasswordProvider;
import java.nio.file.Path;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JE\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0001J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider;", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "delegate", "InteractiveRedirectingSshPasswordProvider", "(Lcom/intellij/ssh/interaction/SshPasswordProvider;)V", "getKeyboardInteractive", "", "", "name", "instruction", "prompt", "echo", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[ZLcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getKeyPassphrase", "privateKeyPath", "Ljava/nio/file/Path;", "getUnixPassword", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nInteractiveRedirectingSshPasswordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractiveRedirectingSshPasswordProvider.kt\ncom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n60#2,5:60\n13#2:66\n1#3:65\n*S KotlinDebug\n*F\n+ 1 InteractiveRedirectingSshPasswordProvider.kt\ncom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider\n*L\n42#1:60,5\n57#1:66\n*E\n"})
public final class InteractiveRedirectingSshPasswordProvider
implements SshPasswordProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SshPasswordProvider delegate;
    @NotNull
    private static final Logger LOG;

    public InteractiveRedirectingSshPasswordProvider(@NotNull SshPasswordProvider delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public String[] getKeyboardInteractive(@NotNull String name, @NotNull String instruction, @NotNull String[] prompt, @NotNull boolean[] echo, @Nullable ProgressIndicator progressIndicator2) {
        String[] stringArray;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)echo, (String)"echo");
        String string = (String)ArraysKt.singleOrNull((Object[])prompt);
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = SshConnectionUtil.isPamUnixPasswordPrompted(string2);
            Logger logger = LOG;
            Throwable throwable = null;
            boolean bl4 = false;
            if (logger.isDebugEnabled()) {
                Logger logger2 = logger;
                boolean bl5 = false;
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String string3 = encoder.encodeToString(byArray);
                String string4 = bl3 ? "treated" : "NOT treated";
                logger2.debug("Password prompt `" + string2 + "` (base64 utf8 " + string3 + ") is " + string4 + " as unix password", throwable);
            }
            v2 = bl3;
        } else {
            v2 = bl = false;
        }
        if (bl) {
            String string5 = this.delegate.getUnixPassword(progressIndicator2);
            if (string5 != null) {
                String string6 = string5;
                boolean bl6 = false;
                String[] stringArray2 = new String[]{string6};
                stringArray = stringArray2;
            } else {
                stringArray = null;
            }
        } else {
            stringArray = this.delegate.getKeyboardInteractive(name, instruction, prompt, echo, progressIndicator2);
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getKeyPassphrase(@NotNull Path privateKeyPath, @Nullable ProgressIndicator progressIndicator2) {
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        return this.delegate.getKeyPassphrase(privateKeyPath, progressIndicator2);
    }

    @Override
    @Nullable
    public String getUnixPassword(@Nullable ProgressIndicator progressIndicator2) {
        return this.delegate.getUnixPassword(progressIndicator2);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(InteractiveRedirectingSshPasswordProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider$Companion;", "", "InteractiveRedirectingSshPasswordProvider$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

