/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.AbstractChangeListAction;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction;", "Lcom/intellij/openapi/vcs/changes/actions/AbstractChangeListAction;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canRemoveChangeLists", "", "project", "Lcom/intellij/openapi/project/Project;", "lists", "", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "actionPerformed", "deleteLists", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "confirmChangeListRemoval", "confirmAllChangeListsRemoval", "pendingLists", "toAsk", "askNewDefaultChangeList", "remainingLists", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRemoveChangeListAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveChangeListAction.kt\ncom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,171:1\n13#2:172\n1807#3,3:173\n1642#3,10:176\n1915#3:186\n1916#3:188\n1652#3:189\n1807#3,3:190\n1915#3,2:193\n1786#3,3:195\n1786#3,3:198\n1786#3,3:201\n1586#3:204\n1661#3,3:205\n1#4:187\n37#5,2:208\n*S KotlinDebug\n*F\n+ 1 RemoveChangeListAction.kt\ncom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction\n*L\n20#1:172\n34#1:173,3\n70#1:176,10\n70#1:186\n70#1:188\n70#1:189\n80#1:190,3\n116#1:193,2\n122#1:195,3\n137#1:198,3\n149#1:201,3\n157#1:204\n157#1:205,3\n70#1:187\n157#1:208,2\n*E\n"})
public final class RemoveChangeListAction
extends AbstractChangeListAction {
    @NotNull
    private final Logger LOG;

    public RemoveChangeListAction() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoveChangeListAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean hasChanges;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object[] changeListsArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        Object object = changeListsArray;
        if (changeListsArray == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object changeLists2 = object;
        boolean enabled = this.canRemoveChangeLists(e.getProject(), (List<? extends ChangeList>)changeLists2);
        AbstractChangeListAction.updateEnabledAndVisible$default(this, e, enabled, false, 4, null);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Object[] objectArray = new Object[]{changeLists2.size()};
        presentation2.setText(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.text.template", (Object[])objectArray));
        boolean bl = hasChanges = !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (hasChanges) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = (Iterable)changeLists2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChangeList it = (ChangeList)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof LocalChangeList && ((LocalChangeList)it).isDefault())) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            boolean containsActiveChangelist = bl2;
            Object[] objectArray2 = containsActiveChangelist ? VcsBundle.message((String)"changes.another.change.list", (Object[])new Object[0]) : VcsBundle.message((String)"changes.default.change.list", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)objectArray2);
            Object[] changeListName2 = objectArray2;
            objectArray2 = new Object[]{changeLists2.size(), changeListName2};
            presentation2.setDescription(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.description.template", (Object[])objectArray2));
        } else {
            presentation2.setDescription(null);
        }
    }

    private final boolean canRemoveChangeLists(Project project, List<? extends ChangeList> lists) {
        if (project == null || lists.isEmpty()) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            if (!((LocalChangeList)changeList).isReadOnly()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChangeList[] changeListArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeListArray == null) {
            return;
        }
        ChangeList[] selectedLists = changeListArray;
        List list = CollectionsKt.listOf((Object[])Arrays.copyOf(selectedLists, selectedLists.length));
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.openapi.vcs.changes.LocalChangeList>");
        this.deleteLists(project2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteLists(Project project, Collection<? extends LocalChangeList> lists) {
        boolean activeChangelistSelected;
        LocalChangeList it;
        List pendingLists;
        List toAsk;
        List toRemove;
        ChangeListManagerEx manager;
        block21: {
            void $this$mapNotNullTo$iv$iv;
            ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerEx), (String)"getInstanceEx(...)");
            manager = changeListManagerEx;
            toRemove = new ArrayList();
            toAsk = new ArrayList();
            Iterable $this$mapNotNull$iv = lists;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LocalChangeList it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LocalChangeList it2 = (LocalChangeList)element$iv$iv;
                boolean bl2 = false;
                if (manager.getChangeList(it2.getId()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            block6: for (LocalChangeList list : (List)destination$iv$iv) {
                switch (WhenMappings.$EnumSwitchMapping$0[ChangeListRemoveConfirmation.INSTANCE.checkCanDeleteChangelist(project, list, true).ordinal()]) {
                    case 1: {
                        toAsk.add(list);
                        continue block6;
                    }
                    case 2: {
                        toRemove.add(list);
                        continue block6;
                    }
                    case 3: {
                        continue block6;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            pendingLists = CollectionsKt.plus((Collection)toAsk, (Iterable)toRemove);
            Iterable $this$any$iv = pendingLists;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (LocalChangeList)element$iv;
                    boolean bl = false;
                    if (!it.isDefault()) continue;
                    v1 = true;
                    break block21;
                }
                v1 = activeChangelistSelected = false;
            }
        }
        if (activeChangelistSelected) {
            List list = manager.getChangeLists();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
            List remainingLists = CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)list, (Iterable)pendingLists));
            if (remainingLists.isEmpty()) {
                if (!this.confirmAllChangeListsRemoval(project, pendingLists, toAsk)) {
                    return;
                }
                LocalChangeList defaultList = manager.findChangeList(LocalChangeList.getDefaultName());
                if (defaultList == null) {
                    defaultList = manager.addChangeList(LocalChangeList.getDefaultName(), null);
                } else {
                    manager.editComment(defaultList.getName(), null);
                    manager.editChangeListData(defaultList.getName(), null);
                }
                LocalChangeList localChangeList = defaultList;
                Intrinsics.checkNotNull((Object)localChangeList);
                manager.setDefaultChangeList(localChangeList);
                toRemove.addAll(toAsk);
                toRemove.remove(defaultList);
            } else {
                LocalChangeList localChangeList = this.askNewDefaultChangeList(project, toAsk, remainingLists);
                if (localChangeList == null) {
                    return;
                }
                LocalChangeList newDefault = localChangeList;
                manager.setDefaultChangeList(newDefault);
                toRemove.addAll(toAsk);
                if (toRemove.remove(newDefault)) {
                    this.LOG.error("New default changelist should be selected among remaining");
                }
            }
        } else if (this.confirmChangeListRemoval(project, toAsk)) {
            toRemove.addAll(toAsk);
        }
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager.removeChangeList(it.getName());
        }
    }

    private final boolean confirmChangeListRemoval(Project project, List<? extends LocalChangeList> lists) {
        String string;
        boolean haveNoChanges;
        block6: {
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl = false;
                    if (it.getChanges().isEmpty()) continue;
                    v0 = false;
                    break block6;
                }
                v0 = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        if (lists.size() == 1) {
            var6_6 = new Object[]{((LocalChangeList)CollectionsKt.single(lists)).getName()};
            string = VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])var6_6);
        } else {
            var6_6 = new Object[]{lists.size()};
            string = VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])var6_6);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private final boolean confirmAllChangeListsRemoval(Project project, List<? extends LocalChangeList> pendingLists, List<? extends LocalChangeList> toAsk) {
        boolean haveNoChanges;
        block6: {
            if (pendingLists.size() == 1) {
                return true;
            }
            if (toAsk.isEmpty()) {
                return true;
            }
            Iterable $this$all$iv = pendingLists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl = false;
                    if (it.getChanges().isEmpty()) continue;
                    v0 = false;
                    break block6;
                }
                v0 = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        Object[] objectArray = new Object[]{pendingLists.size()};
        String string = VcsBundle.message((String)"changes.removechangelist.all.lists.warning.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        return Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final LocalChangeList askNewDefaultChangeList(Project project, List<? extends LocalChangeList> lists, List<? extends LocalChangeList> remainingLists) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        boolean haveNoChanges;
        Object element$iv2;
        block7: {
            boolean bl;
            boolean bl2 = bl = !((Collection)remainingLists).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv2;
                    boolean bl3 = false;
                    if (it.getChanges().isEmpty()) continue;
                    v1 = false;
                    break block7;
                }
                v1 = haveNoChanges = true;
            }
        }
        if (remainingLists.size() == 1 && haveNoChanges) {
            return (LocalChangeList)CollectionsKt.single(remainingLists);
        }
        Iterable $this$map$iv = remainingLists;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] remainingListsNames = thisCollection$iv.toArray(new String[0]);
        String $i$f$toTypedArray22 = haveNoChanges ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)$i$f$toTypedArray22);
        String message = $i$f$toTypedArray22;
        int nameIndex = Messages.showChooseDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)((String)ArraysKt.first((Object[])remainingListsNames)));
        if (nameIndex < 0) {
            return null;
        }
        return remainingLists.get(nameIndex);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.YES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

