/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangesViewShowDiffActionProviderKt;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesListViewDiffableSelectionUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/ChangesViewShowDiffActionProvider;", "Lcom/intellij/openapi/actionSystem/AnActionExtensionProvider;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isActive", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "actionPerformed", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ChangesViewShowDiffActionProvider
implements AnActionExtensionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Companion.updateAvailability(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ChangeDiffRequestChain changeDiffRequestChain;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChangesListView changesListView = (ChangesListView)e.getData(ChangesListView.DATA_KEY);
        if (changesListView == null) {
            return;
        }
        ChangesListView view = changesListView;
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        ListSelection selection = ChangesListViewDiffableSelectionUtil.INSTANCE.computeSelectionForDiff(view);
        ListSelection producers = ChangesViewShowDiffActionProviderKt.access$mapToProducers(selection, project2);
        if (producers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain $this$actionPerformed_u24lambda_u240 = changeDiffRequestChain = new ChangeDiffRequestChain((ListSelection<? extends ChangeDiffRequestChain.Producer>)producers);
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        boolean allowExcludeFromCommit = (Boolean)ChangesViewWorkflowManager.Companion.getInstance(project2).getAllowExcludeFromCommit().getValue();
        $this$actionPerformed_u24lambda_u240.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, allowExcludeFromCommit);
        ChangeDiffRequestChain chain = changeDiffRequestChain;
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J.\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/ChangesViewShowDiffActionProvider$Companion;", "", "<init>", "()V", "updateAvailability", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canShowDiff", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vcs/changes/Change;", "paths", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateAvailability(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            String string = e.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            String place = string;
            if (e.getData(ChangesListView.DATA_KEY) == null) {
                presentation2.setEnabled(false);
                return;
            }
            Change[] changeArray = (Change[])e.getData(VcsDataKeys.CHANGES);
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(changeArray, changeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            JBIterable changes = jBIterable;
            JBIterable jBIterable2 = JBIterable.from((Iterable)((Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"from(...)");
            JBIterable unversionedFiles = jBIterable2;
            if (Intrinsics.areEqual((Object)"MainMenu", (Object)place)) {
                presentation2.setEnabled(project != null && (changes.isNotEmpty() || unversionedFiles.isNotEmpty()));
            } else {
                presentation2.setEnabled(project != null && this.canShowDiff(project, (JBIterable<Change>)changes, (JBIterable<FilePath>)unversionedFiles));
            }
            if (Intrinsics.areEqual((Object)"ChangesViewToolbar", (Object)place)) {
                presentation2.setVisible(!ExperimentalUI.Companion.isNewUI());
            }
        }

        private final boolean canShowDiff(Project project, JBIterable<Change> changes, JBIterable<FilePath> paths) {
            return paths.isNotEmpty() || changes.filter(arg_0 -> Companion.canShowDiff$lambda$1(arg_0 -> Companion.canShowDiff$lambda$0(project, arg_0), arg_0)).isNotEmpty();
        }

        private static final boolean canShowDiff$lambda$0(Project $project, Change it) {
            return ChangeDiffRequestProducer.canCreate($project, it);
        }

        private static final boolean canShowDiff$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

