/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.configurable.SuggestedVcsComparator;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.dialog.VcsDialogUtils;
import com.intellij.vcs.VcsDisposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0003 !\"B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "vcsComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "directoryTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "content", "Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$VcsMappingDialogContent;", "directoryRadioButton", "Ljavax/swing/JRadioButton;", "projectRadioButton", "mappingCopy", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "getMapping", "setMapping", "", "mapping", "createCenterPanel", "Ljavax/swing/JComponent;", "updateVcsConfigurable", "doOKAction", "MyBrowseFolderListener", "VcsMappingDialogContent", "Companion", "intellij.platform.vcs.impl"})
public final class VcsMappingConfigurationDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ComboBox<AbstractVcs> vcsComboBox;
    @NotNull
    private final TextFieldWithBrowseButton directoryTextField;
    @NotNull
    private final VcsMappingDialogContent content;
    @NotNull
    private final JRadioButton directoryRadioButton;
    @NotNull
    private final JRadioButton projectRadioButton;
    @NotNull
    private VcsDirectoryMapping mappingCopy;

    public VcsMappingConfigurationDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(project, false);
        this.project = project;
        this.vcsManager = ProjectLevelVcsManager.Companion.getInstance(this.project);
        VcsDisposable vcsDisposable = VcsDisposable.Companion.getInstance(this.project);
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.coroutineScope = vcsDisposable.childScope("VcsMappingConfigurationDialog", disposable);
        this.vcsComboBox = VcsDirectoryConfigurationPanel.Companion.buildVcsesComboBox(this.project);
        this.directoryTextField = new TextFieldWithBrowseButton();
        this.content = new VcsMappingDialogContent();
        this.directoryRadioButton = new JRadioButton(VcsBundle.message((String)"vcs.common.labels.directory", (Object[])new Object[0]));
        this.projectRadioButton = new JRadioButton();
        this.mappingCopy = new VcsDirectoryMapping("", "");
        this.directoryRadioButton.setSelected(true);
        ActionListener listener2 = arg_0 -> VcsMappingConfigurationDialog._init_$lambda$0(this, arg_0);
        this.projectRadioButton.addActionListener(listener2);
        this.directoryRadioButton.addActionListener(listener2);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.singleDir().withTitle(VcsBundle.message((String)"settings.vcs.mapping.browser.select.directory.title", (Object[])new Object[0])).withDescription(VcsBundle.message((String)"settings.vcs.mapping.browser.select.directory.description", (Object[])new Object[0]));
        Intrinsics.checkNotNull((Object)descriptor);
        this.directoryTextField.addActionListener((ActionListener)((Object)new MyBrowseFolderListener(this.directoryTextField, this.project, descriptor)));
        this.setTitle(title);
        this.setOKButtonText(VcsBundle.message((String)"directory.mapping.save.button", (Object[])new Object[0]));
        this.init();
        this.setMapping(VcsMappingConfigurationDialog.Companion.suggestDefaultMapping(this.project));
        this.vcsComboBox.addActionListener(arg_0 -> VcsMappingConfigurationDialog._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final VcsDirectoryMapping getMapping() {
        String string;
        String vcsName;
        AbstractVcs vcs;
        AbstractVcs abstractVcs = vcs = (AbstractVcs)this.vcsComboBox.getItem();
        String string2 = abstractVcs != null ? abstractVcs.getName() : null;
        if (string2 == null) {
            string2 = vcsName = "";
        }
        if (this.projectRadioButton.isSelected()) {
            string = "";
        } else {
            String string3 = FileUtil.toSystemIndependentName((String)this.directoryTextField.getText());
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
        }
        String directory = string;
        return new VcsDirectoryMapping(directory, vcsName, this.mappingCopy.getRootSettings());
    }

    public final void setMapping(@NotNull VcsDirectoryMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        this.mappingCopy = new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings());
        this.projectRadioButton.setSelected(this.mappingCopy.isDefaultMapping());
        this.directoryRadioButton.setSelected(!this.projectRadioButton.isSelected());
        this.directoryTextField.setText(this.mappingCopy.isDefaultMapping() ? "" : FileUtil.toSystemDependentName((String)mapping.getDirectory()));
        this.directoryTextField.setEnabled(this.directoryRadioButton.isSelected());
        this.vcsComboBox.setSelectedItem((Object)this.vcsManager.findVcsByName(mapping.getVcs()));
        this.updateVcsConfigurable();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    private final void updateVcsConfigurable() {
        AbstractVcs abstractVcs = (AbstractVcs)this.vcsComboBox.getItem();
        UnnamedConfigurable newConfigurable = abstractVcs != null ? abstractVcs.getRootConfigurable(this.mappingCopy) : null;
        this.content.update(newConfigurable);
        this.pack();
    }

    protected void doOKAction() {
        try {
            this.content.apply();
        }
        catch (ConfigurationException ex) {
            Object[] objectArray = new Object[]{ex.getMessageHtml()};
            Messages.showErrorDialog((Component)this.getContentPanel(), (String)VcsBundle.message((String)"settings.vcs.mapping.invalid.vcs.options.error", (Object[])objectArray));
            return;
        }
        super.doOKAction();
    }

    private static final void _init_$lambda$0(VcsMappingConfigurationDialog this$0, ActionEvent it) {
        this$0.directoryTextField.setEnabled(this$0.directoryRadioButton.isSelected());
    }

    private static final void _init_$lambda$1(VcsMappingConfigurationDialog this$0, ActionEvent it) {
        this$0.updateVcsConfigurable();
    }

    private static final Unit createCenterPanel$lambda$0$0$0(VcsMappingConfigurationDialog this$0) {
        this$0.close(1);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$1$0(VcsMappingConfigurationDialog this$0, JRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setText(DefaultVcsRootPolicy.getInstance(this$0.project).getProjectMappingInDialogDescription());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$0(VcsMappingConfigurationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.directoryRadioButton);
        $this$row.cell((JComponent)this$0.directoryTextField).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$1(VcsMappingConfigurationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.projectRadioButton).applyToComponent(arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$1$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(VcsMappingConfigurationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.vcsComboBox).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        JComponent jComponent = this$0.getContentPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentPanel(...)");
        $this$row.cell((JComponent)VcsDialogUtils.getMorePluginsLink(jComponent, (Function0<Unit>)((Function0)() -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$0$0(this$0))));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(VcsMappingConfigurationDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$1$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(VcsMappingConfigurationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.content.getMainPanel()).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(VcsMappingConfigurationDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = VcsBundle.message((String)"vcs.common.labels.version.control", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$0(this$0, arg_0)).layout(RowLayout.LABEL_ALIGNED);
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)3, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VcsMappingConfigurationDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(VcsMappingConfigurationDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ ProjectLevelVcsManager access$getVcsManager$p(VcsMappingConfigurationDialog $this) {
        return $this.vcsManager;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$Companion;", "", "<init>", "()V", "suggestDefaultMapping", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VcsDirectoryMapping suggestDefaultMapping(Project project) {
            Object[] vcses = ProjectLevelVcsManager.Companion.getInstance(project).getAllSupportedVcss();
            ContainerUtil.sort((Object[])vcses, SuggestedVcsComparator.create(project));
            AbstractVcs abstractVcs = (AbstractVcs)ArraysKt.firstOrNull((Object[])vcses);
            String string = abstractVcs != null ? abstractVcs.getName() : null;
            if (string == null) {
                string = "";
            }
            String defaultVcsName = string;
            String string2 = project.getBasePath();
            if (string2 == null) {
                VcsDirectoryMapping vcsDirectoryMapping = VcsDirectoryMapping.createDefault((String)defaultVcsName);
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"createDefault(...)");
                return vcsDirectoryMapping;
            }
            String basePath = string2;
            return new VcsDirectoryMapping(basePath, defaultVcsName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener;", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener;", "Ljavax/swing/JTextField;", "textField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "project", "Lcom/intellij/openapi/project/Project;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog;Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "getInitialFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileChosen", "", "chosenFile", "intellij.platform.vcs.impl"})
    private final class MyBrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        public MyBrowseFolderListener(@NotNull TextFieldWithBrowseButton textField, @NotNull Project project, FileChooserDescriptor fileChooserDescriptor2) {
            Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor2, (String)"fileChooserDescriptor");
            super((ComponentWithBrowseButton)textField, project, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            String string = this.getComponentText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComponentText(...)");
            if (((CharSequence)string).length() == 0) {
                Project project = this.getProject();
                return project != null ? ProjectUtil.guessProjectDir((Project)project) : null;
            }
            return super.getInitialFile();
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
            String string = VcsMappingConfigurationDialog.this.directoryTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String oldText = string;
            super.onFileChosen(chosenFile);
            AbstractVcs vcs = (AbstractVcs)VcsMappingConfigurationDialog.this.vcsComboBox.getItem();
            if (((CharSequence)oldText).length() == 0 && vcs != null) {
                BuildersKt.launch$default((CoroutineScope)VcsMappingConfigurationDialog.this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(VcsMappingConfigurationDialog.this, chosenFile, null){
                    int label;
                    final /* synthetic */ VcsMappingConfigurationDialog this$0;
                    final /* synthetic */ VirtualFile $chosenFile;
                    {
                        this.this$0 = $receiver;
                        this.$chosenFile = $chosenFile;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Project project = VcsMappingConfigurationDialog.access$getProject$p(this.this$0);
                                String string = VcsBundle.message((String)"settings.vcs.mapping.status.looking.for.vcs.administrative.area", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                this.label = 1;
                                Object object2 = TasksKt.withBackgroundProgress((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$chosenFile, null){
                                    Object L$0;
                                    Object L$1;
                                    int label;
                                    final /* synthetic */ VcsMappingConfigurationDialog this$0;
                                    final /* synthetic */ VirtualFile $chosenFile;
                                    {
                                        this.this$0 = $receiver;
                                        this.$chosenFile = $chosenFile;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var4_5 = allVcss = VcsMappingConfigurationDialog.access$getVcsManager$p(this.this$0).getAllVcss();
                                                var5_6 = this.$chosenFile;
                                                $i$f$firstOrNull = false;
                                                var8_9 = ((void)$this$firstOrNull$iv).length;
                                                for (var7_8 = 0; var7_8 < var8_9; ++var7_8) {
                                                    descriptor = element$iv = $this$firstOrNull$iv[var7_8];
                                                    $i$a$-firstOrNull-VcsMappingConfigurationDialog$MyBrowseFolderListener$onFileChosen$1$1$probableVcs$1 = false;
                                                    if (!descriptor.probablyUnderVcs(var5_6)) continue;
                                                    v0 = element$iv;
                                                    ** GOTO lbl16
                                                }
                                                v0 = null;
lbl16:
                                                // 2 sources

                                                probableVcs = v0;
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)allVcss);
                                                this.L$1 = SpillingKt.nullOutSpilledVariable(probableVcs);
                                                this.label = 1;
                                                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(probableVcs, this.this$0, null){
                                                    int label;
                                                    final /* synthetic */ VcsDescriptor $probableVcs;
                                                    final /* synthetic */ VcsMappingConfigurationDialog this$0;
                                                    {
                                                        this.$probableVcs = $probableVcs;
                                                        this.this$0 = $receiver;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object $result) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                VcsDescriptor vcsDescriptor = this.$probableVcs;
                                                                if (vcsDescriptor != null) {
                                                                    VcsDescriptor vcsDescriptor2 = vcsDescriptor;
                                                                    VcsMappingConfigurationDialog vcsMappingConfigurationDialog = this.this$0;
                                                                    VcsDescriptor it = vcsDescriptor2;
                                                                    boolean bl = false;
                                                                    VcsMappingConfigurationDialog.access$getVcsComboBox$p(vcsMappingConfigurationDialog).setSelectedItem((Object)it);
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (v1 == var12_2) {
                                                    return var12_2;
                                                }
                                                ** GOTO lbl29
                                            }
                                            case 1: {
                                                probableVcs = (VcsDescriptor)this.L$1;
                                                allVcss = (VcsDescriptor[])this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl29:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$VcsMappingDialogContent;", "", "<init>", "()V", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "configurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "component", "Ljavax/swing/JComponent;", "update", "", "newConfigurable", "dispose", "apply", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsMappingConfigurationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsMappingConfigurationDialog.kt\ncom/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$VcsMappingDialogContent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
    private static final class VcsMappingDialogContent {
        @NotNull
        private final JPanel mainPanel = new JPanel(new BorderLayout());
        @Nullable
        private UnnamedConfigurable configurable;
        @Nullable
        private JComponent component;

        @NotNull
        public final JPanel getMainPanel() {
            return this.mainPanel;
        }

        /*
         * WARNING - void declaration
         */
        public final void update(@Nullable UnnamedConfigurable newConfigurable) {
            Object object;
            this.dispose();
            this.configurable = newConfigurable;
            VcsMappingDialogContent vcsMappingDialogContent = this;
            Object object2 = newConfigurable;
            if (object2 != null && (object2 = object2.createComponent()) != null) {
                void it;
                Object object3;
                Object object4 = object3 = object2;
                VcsMappingDialogContent vcsMappingDialogContent2 = vcsMappingDialogContent;
                boolean bl = false;
                this.mainPanel.add((Component)it, "Center");
                vcsMappingDialogContent = vcsMappingDialogContent2;
                object = object3;
            } else {
                object = null;
            }
            vcsMappingDialogContent.component = object;
        }

        public final void dispose() {
            JComponent jComponent = this.component;
            if (jComponent != null) {
                JComponent jComponent2 = jComponent;
                JPanel jPanel = this.mainPanel;
                Component p0 = jComponent2;
                boolean bl = false;
                jPanel.remove(p0);
            }
            UnnamedConfigurable unnamedConfigurable = this.configurable;
            if (unnamedConfigurable != null) {
                unnamedConfigurable.disposeUIResources();
            }
            this.configurable = null;
            this.component = null;
        }

        public final void apply() {
            block0: {
                UnnamedConfigurable unnamedConfigurable = this.configurable;
                if (unnamedConfigurable == null) break block0;
                unnamedConfigurable.apply();
            }
        }
    }
}

