/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DefaultLineFlags;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupActions;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBlockOperations;
import com.intellij.openapi.vcs.ex.LineStatusTrackerListener;
import com.intellij.openapi.vcs.ex.LocalLineStatusTrackerImpl;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialCommitContent;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.openapi.vcs.ex.commit.CommitChunkService;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 \u00af\u00012\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0018\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0001\u00ad\u0001\u00ae\u0001\u00af\u0001B!\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u000201H\u0014J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020 03H\u0016J\u0012\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0017J\u0016\u0010=\u001a\u0002082\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?03H\u0007J(\u0010@\u001a\u0002082\u0006\u0010A\u001a\u00020 2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020 032\b\u0010C\u001a\u0004\u0018\u00010 H\u0016J\u0018\u0010D\u001a\u0002082\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 H\u0016J\u0010\u0010G\u001a\u0002082\u0006\u0010H\u001a\u00020 H\u0016J\u0018\u0010I\u001a\u0002082\u0006\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020 H\u0016J\u0010\u0010L\u001a\u0002082\u0006\u0010K\u001a\u00020 H\u0016J$\u0010M\u001a\u0002082\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u00170O2\u0006\u0010P\u001a\u00020\u001eH\u0002J\b\u0010Q\u001a\u000208H\u0002J\u0010\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020\u0017H\u0003J\r\u0010T\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bUJ\r\u0010V\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bWJ\b\u0010X\u001a\u00020\u0017H\u0016J&\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020 032\u0006\u0010^\u001a\u00020\u0017H\u0017J$\u0010_\u001a\u0002082\u0006\u0010[\u001a\u00020\\2\n\u0010`\u001a\u00060aR\u00020\u00002\u0006\u0010b\u001a\u00020 H\u0002J\u001e\u0010c\u001a\u0002082\f\u0010B\u001a\b\u0012\u0004\u0012\u00020 032\u0006\u0010^\u001a\u00020\u0017H\u0017J(\u0010d\u001a\u0004\u0018\u00010 2\u0006\u0010[\u001a\u00020\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020 032\u0006\u0010^\u001a\u00020\u0017H\u0016J \u0010e\u001a\u0004\u0018\u00010f2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020 032\u0006\u0010^\u001a\u00020\u0017H\u0016J\u0018\u0010g\u001a\u0002082\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0017J\u0018\u0010g\u001a\u0002082\u0006\u0010l\u001a\u00020m2\u0006\u0010j\u001a\u00020kH\u0017J\u001c\u0010n\u001a\u0002082\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020i\u0012\u0004\u0012\u00020k0pH\u0007J$\u0010g\u001a\u0002082\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u00170O2\u0006\u0010j\u001a\u00020kH\u0003J\u0010\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020 H\u0016J\u0010\u0010t\u001a\u0002082\u0006\u0010u\u001a\u00020\u0017H\u0017J\u0018\u0010t\u001a\u0002082\u0006\u0010s\u001a\u00020 2\u0006\u0010u\u001a\u00020\u0017H\u0016J\u0018\u0010t\u001a\u0002082\u0006\u0010h\u001a\u00020i2\u0006\u0010u\u001a\u00020\u0017H\u0016J\u0018\u0010t\u001a\u0002082\u0006\u0010l\u001a\u00020m2\u0006\u0010u\u001a\u00020\u0017H\u0016J$\u0010t\u001a\u0002082\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u00170O2\u0006\u0010u\u001a\u00020\u0017H\u0002J \u0010v\u001a\u0002082\u0006\u0010l\u001a\u00020m2\u0006\u0010[\u001a\u00020\\2\u0006\u0010u\u001a\u00020\u0017H\u0016J(\u0010v\u001a\u0002082\u0006\u00100\u001a\u0002012\u0006\u0010l\u001a\u00020m2\u0006\u0010[\u001a\u00020\\2\u0006\u0010u\u001a\u00020\u0017H\u0002JX\u0010w\u001a\u0002082\u0006\u0010x\u001a\u00020m2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020z26\u0010|\u001a2\u0012\u0013\u0012\u00110z\u00a2\u0006\f\b~\u0012\b\b\u007f\u0012\u0004\b\b(y\u0012\u0013\u0012\u00110z\u00a2\u0006\f\b~\u0012\b\b\u007f\u0012\u0004\b\b({\u0012\u0004\u0012\u0002080}H\u0002J\t\u0010\u0080\u0001\u001a\u000208H\u0002J\u000f\u0010\u0081\u0001\u001a\u000208H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u0010\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0001\u00a2\u0006\u0003\b\u0085\u0001J\u0019\u0010\u0086\u0001\u001a\u00020\u00172\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0001\u00a2\u0006\u0003\b\u0089\u0001J\u0016\u0010\u008a\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u000103H\u0001\u00a2\u0006\u0003\b\u008c\u0001J\u0013\u0010\u008d\u0001\u001a\u00020\u00172\b\u0010\u0087\u0001\u001a\u00030\u0084\u0001H\u0002J\u0019\u0010\u0086\u0001\u001a\u00020\u00172\u000e\u0010\u008e\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u000103H\u0003J\u0019\u0010\u008f\u0001\u001a\u0002082\u000e\u0010\u008e\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u000103H\u0002J\u001c\u0010\u0090\u0001\u001a\u0002082\u0007\u0010\u0091\u0001\u001a\u00020-2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\u001d\u0010\u0090\u0001\u001a\u0002082\b\u0010\u0091\u0001\u001a\u00030\u0094\u00012\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020 0#j\b\u0012\u0004\u0012\u00020 `$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010+\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010-0-0,\u00a2\u0006\u0002\b.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0095\u0001\u001a\u00030\u0096\u0001*\u0002018TX\u0094\u0004\u00a2\u0006\b\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001R.\u0010\u009a\u0001\u001a\u00020\u001e*\u0002012\u0007\u0010\u0099\u0001\u001a\u00020\u001e8B@BX\u0082\u000e\u00a2\u0006\u0010\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001\"\u0006\b\u009d\u0001\u0010\u009e\u0001R/\u0010\u00a0\u0001\u001a\u00030\u009f\u0001*\u0002012\b\u0010\u0099\u0001\u001a\u00030\u009f\u00018B@BX\u0082\u000e\u00a2\u0006\u000f\u001a\u0006\b\u00a1\u0001\u0010\u00a2\u0001\"\u0005\bt\u0010\u00a3\u0001\u00a8\u0006\u00b0\u0001"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "Lcom/intellij/openapi/vcs/changes/ChangeListWorker$PartialChangeTracker;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;", "kotlin.jvm.PlatformType", "lstManager", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "activeChangeListTracker", "Lcom/intellij/openapi/vcs/impl/ActiveChangeListTracker;", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "undoStateRecordingEnabled", "", "redoStateRecordingEnabled", "renderer", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "defaultMarker", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;", "initialChangeListId", "", "lastKnownTrackerChangeListId", "affectedChangeLists", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasUndoInCommand", "initialExcludeState", "", "undoableActions", "Lcom/intellij/util/containers/WeakList;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyUndoableAction;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$Listener;", "Lorg/jetbrains/annotations/NotNull;", "toRange", "block", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "toIncludedRanges", "", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Partial;", "getAffectedChangeListsIds", "updateAffectedChangeLists", "", "notifyChangeListManager", "setBaseRevision", "vcsContent", "", "replayChangesFromDocumentEvents", "events", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "initChangeTracking", "defaultId", "changelistsIds", "fileChangelistId", "defaultListChanged", "oldListId", "newListId", "changeListRemoved", "listId", "moveChanges", "fromListId", "toListId", "moveChangesTo", "moveMarkers", "condition", "Lkotlin/Function1;", "toMarker", "dropExistingUndoActions", "registerUndoAction", "undo", "hasPartialState", "hasPartialState$intellij_platform_vcs_impl", "hasPendingPartialState", "hasPendingPartialState$intellij_platform_vcs_impl", "hasPartialChangesToCommit", "handlePartialCommit", "Lcom/intellij/openapi/vcs/ex/PartialCommitHelper;", "side", "Lcom/intellij/diff/util/Side;", "changelistIds", "honorExcludedFromCommit", "applyPartialCommitChanges", "toCommitCondition", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ToCommitCondition;", "contentToCommit", "rollbackChanges", "getChangesToBeCommitted", "getPartialCommitContent", "Lcom/intellij/openapi/vcs/ex/PartialCommitContent;", "moveToChangelist", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "changelist", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "lines", "Ljava/util/BitSet;", "recreateBlocks", "map", "", "getExcludedFromCommitState", "Lcom/intellij/openapi/vcs/ex/ExclusionState;", "changelistId", "setExcludedFromCommit", "isExcluded", "setPartiallyExcludedFromCommit", "iterateIncludedRangesBetween", "set", "start", "", "end", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "fireExcludedFromCommitChanged", "resetExcludedFromCommitMarkers", "resetExcludedFromCommitMarkers$intellij_platform_vcs_impl", "storeTrackerState", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "storeTrackerState$intellij_platform_vcs_impl", "restoreState", "state", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "restoreState$intellij_platform_vcs_impl", "collectRangeStates", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "collectRangeStates$intellij_platform_vcs_impl", "restoreFullState", "states", "restoreChangelistsState", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerListener;", "ourData", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListBlockData;", "getOurData", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListBlockData;", "value", "marker", "getMarker", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;", "setMarker", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;)V", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "excludedFromCommit", "getExcludedFromCommit", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Lcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "MyUndoDocumentListener", "MyUndoCommandListener", "PartialDocumentTrackerHandler", "ToCommitCondition", "MyLineStatusMarkerRenderer", "MyUndoableAction", "FullState", "State", "RangeState", "ChangeListMarker", "ChangeListBlockData", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPartialLocalLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialLocalLineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1107:1\n1#2:1108\n132#3,17:1109\n132#3,17:1126\n141#3,8:1155\n1586#4:1143\n1661#4,3:1144\n1924#4,3:1147\n1915#4,2:1150\n1807#4,3:1152\n777#4:1163\n873#4,2:1164\n1391#4:1166\n1480#4,5:1167\n1205#4,2:1172\n1282#4,4:1174\n1586#4:1178\n1661#4,3:1179\n1586#4:1182\n1661#4,3:1183\n1586#4:1186\n1661#4,3:1187\n*S KotlinDebug\n*F\n+ 1 PartialLocalLineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker\n*L\n950#1:1109,17\n973#1:1126,17\n566#1:1155,8\n988#1:1143\n988#1:1144,3\n992#1:1147,3\n520#1:1150,2\n538#1:1152,3\n603#1:1163\n603#1:1164,2\n604#1:1166\n604#1:1167,5\n768#1:1172,2\n768#1:1174,4\n944#1:1178\n944#1:1179,3\n954#1:1182\n954#1:1183,3\n977#1:1186\n977#1:1187,3\n*E\n"})
public final class ChangelistsLocalLineStatusTracker
extends LocalLineStatusTrackerImpl<LocalRange>
implements PartialLocalLineStatusTracker,
ChangeListWorker.PartialChangeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ChangeListManagerImpl changeListManager;
    @NotNull
    private final LineStatusTrackerManager lstManager;
    @NotNull
    private final ActiveChangeListTracker activeChangeListTracker;
    private final UndoManager undoManager;
    private final boolean undoStateRecordingEnabled;
    private final boolean redoStateRecordingEnabled;
    @NotNull
    private final LocalLineStatusTrackerImpl.LocalLineStatusMarkerRenderer renderer;
    @NotNull
    private ChangeListMarker defaultMarker;
    @Nullable
    private String initialChangeListId;
    @Nullable
    private String lastKnownTrackerChangeListId;
    @NotNull
    private final HashSet<String> affectedChangeLists;
    private boolean hasUndoInCommand;
    @NotNull
    private final Map<ChangeListMarker, Boolean> initialExcludeState;
    @NotNull
    private final WeakList<MyUndoableAction> undoableActions;
    @NotNull
    private final EventDispatcher<PartialLocalLineStatusTracker.Listener> eventDispatcher;
    @NotNull
    private static final Logger LOG;

    public ChangelistsLocalLineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(project, document, virtualFile);
        this.changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        this.lstManager = LineStatusTrackerManager.Companion.getInstanceImpl(project);
        this.activeChangeListTracker = ActiveChangeListTracker.Companion.getInstance(project);
        this.undoManager = UndoManager.getInstance((Project)project);
        this.undoStateRecordingEnabled = Registry.Companion.is("vcs.enable.partial.changelists.undo");
        this.redoStateRecordingEnabled = Registry.Companion.is("vcs.enable.partial.changelists.redo");
        this.renderer = new MyLineStatusMarkerRenderer(this);
        this.affectedChangeLists = new HashSet();
        this.initialExcludeState = new LinkedHashMap();
        this.undoableActions = new WeakList();
        EventDispatcher eventDispatcher = EventDispatcher.create(PartialLocalLineStatusTracker.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        LocalChangeList localChangeList = this.changeListManager.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        this.defaultMarker = new ChangeListMarker(localChangeList);
        this.affectedChangeLists.add(this.defaultMarker.getChangelistId());
        if (this.undoStateRecordingEnabled) {
            document.addDocumentListener((DocumentListener)new MyUndoDocumentListener(), this.getDisposable());
            MessageBusConnection messageBusConnection = project.getMessageBus().connect(this.getDisposable());
            Topic topic = CommandListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new MyUndoCommandListener());
            Disposer.register((Disposable)this.getDisposable(), () -> ChangelistsLocalLineStatusTracker._init_$lambda$0(this));
        }
        Disposer.register((Disposable)this.getDisposable(), () -> ChangelistsLocalLineStatusTracker._init_$lambda$1(this));
        this.getDocumentTracker().addHandler((DocumentTracker.Handler)new PartialDocumentTrackerHandler());
        boolean bl = this.getBlocks().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Override
    @NotNull
    protected LocalLineStatusTrackerImpl.LocalLineStatusMarkerRenderer getRenderer() {
        return this.renderer;
    }

    @NotNull
    protected LocalRange toRange(@NotNull DocumentTracker.Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new LocalRange(block.getStart(), block.getEnd(), block.getVcsStart(), block.getVcsEnd(), this.getOurData(block).getInnerRanges(), this.getOurData(block).getClientIds(), this.getMarker(block).getChangelistId(), this.getExcludedFromCommit(block));
    }

    private final List<LocalRange> toIncludedRanges(DocumentTracker.Block block, RangeExclusionState.Partial exclusionState) {
        List result2 = new ArrayList();
        String changelistId = this.getMarker(block).getChangelistId();
        exclusionState.iterateIncludedDeletionRanges(block.getRange(), arg_0 -> ChangelistsLocalLineStatusTracker.toIncludedRanges$lambda$0(result2, this, block, changelistId, arg_0));
        exclusionState.iterateIncludedAdditionRanges(block.getRange(), arg_0 -> ChangelistsLocalLineStatusTracker.toIncludedRanges$lambda$1(result2, this, block, changelistId, arg_0));
        return result2;
    }

    @Override
    @NotNull
    public List<String> getAffectedChangeListsIds() {
        return (List)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.getAffectedChangeListsIds$lambda$0(this));
    }

    private final void updateAffectedChangeLists(boolean notifyChangeListManager) {
        HashSet oldIds = new HashSet();
        HashSet<String> newIds = new HashSet<String>();
        for (DocumentTracker.Block block : this.getBlocks()) {
            newIds.add(this.getMarker(block).getChangelistId());
        }
        if (!this.isInitialized()) {
            String string = this.initialChangeListId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                newIds.add(it);
            }
        }
        if (newIds.isEmpty()) {
            String string = this.lastKnownTrackerChangeListId;
            if (string == null) {
                string = this.defaultMarker.getChangelistId();
            }
            String listId = string;
            newIds.add(listId);
        }
        if (newIds.size() == 1) {
            this.lastKnownTrackerChangeListId = (String)CollectionsKt.single((Iterable)newIds);
        }
        oldIds.addAll(this.affectedChangeLists);
        this.affectedChangeLists.clear();
        this.affectedChangeLists.addAll((Collection<String>)newIds);
        if (!Intrinsics.areEqual(oldIds, newIds)) {
            if (notifyChangeListManager) {
                this.changeListManager.notifyChangelistsChanged(VcsUtil.getFilePath((VirtualFile)this.getVirtualFile()), CollectionsKt.toList((Iterable)oldIds), CollectionsKt.toList((Iterable)newIds));
            }
            ((PartialLocalLineStatusTracker.Listener)this.eventDispatcher.getMulticaster()).onChangeListsChange(this);
        }
        ((PartialLocalLineStatusTracker.Listener)this.eventDispatcher.getMulticaster()).onChangeListMarkerChange(this);
    }

    static /* synthetic */ void updateAffectedChangeLists$default(ChangelistsLocalLineStatusTracker changelistsLocalLineStatusTracker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        changelistsLocalLineStatusTracker.updateAffectedChangeLists(bl);
    }

    @Override
    @RequiresEdt
    public void setBaseRevision(@NotNull CharSequence vcsContent) {
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        String changelistId = !this.isInitialized() ? this.initialChangeListId : null;
        this.initialChangeListId = null;
        this.setBaseRevisionContent(vcsContent, (Function0<Unit>)((Function0)() -> ChangelistsLocalLineStatusTracker.setBaseRevision$lambda$0(changelistId, this)));
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.setBaseRevision$lambda$1(this));
        this.dropExistingUndoActions();
        if (this.isValid()) {
            ((PartialLocalLineStatusTracker.Listener)this.eventDispatcher.getMulticaster()).onBecomingValid(this);
        }
    }

    @RequiresEdt
    public final void replayChangesFromDocumentEvents(@NotNull List<? extends DocumentEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (events.isEmpty() || !this.getBlocks().isEmpty()) {
            return;
        }
        this.updateDocument(Side.LEFT, arg_0 -> ChangelistsLocalLineStatusTracker.replayChangesFromDocumentEvents$lambda$0(events, arg_0));
    }

    @Override
    public void initChangeTracking(@NotNull String defaultId, @NotNull List<String> changelistsIds, @Nullable String fileChangelistId) {
        Intrinsics.checkNotNullParameter((Object)defaultId, (String)"defaultId");
        Intrinsics.checkNotNullParameter(changelistsIds, (String)"changelistsIds");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.initChangeTracking$lambda$0(this, defaultId, fileChangelistId, changelistsIds));
    }

    @Override
    public void defaultListChanged(@NotNull String oldListId, @NotNull String newListId) {
        Intrinsics.checkNotNullParameter((Object)oldListId, (String)"oldListId");
        Intrinsics.checkNotNullParameter((Object)newListId, (String)"newListId");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.defaultListChanged$lambda$0(this, newListId));
    }

    @Override
    public void changeListRemoved(@NotNull String listId) {
        Intrinsics.checkNotNullParameter((Object)listId, (String)"listId");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.changeListRemoved$lambda$0(this, listId));
    }

    @Override
    public void moveChanges(@NotNull String fromListId, @NotNull String toListId) {
        Intrinsics.checkNotNullParameter((Object)fromListId, (String)"fromListId");
        Intrinsics.checkNotNullParameter((Object)toListId, (String)"toListId");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.moveChanges$lambda$0(this, fromListId, toListId));
    }

    @Override
    public void moveChangesTo(@NotNull String toListId) {
        Intrinsics.checkNotNullParameter((Object)toListId, (String)"toListId");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.moveChangesTo$lambda$0(this, toListId));
    }

    private final void moveMarkers(Function1<? super DocumentTracker.Block, Boolean> condition, ChangeListMarker toMarker) {
        List affectedBlocks = new ArrayList();
        for (DocumentTracker.Block block : this.getBlocks()) {
            if (Intrinsics.areEqual((Object)this.getMarker(block), (Object)toMarker) || !((Boolean)condition.invoke((Object)block)).booleanValue()) continue;
            this.setMarker(block, toMarker);
            affectedBlocks.add(block);
        }
        if (!affectedBlocks.isEmpty()) {
            this.dropExistingUndoActions();
            this.updateHighlighters();
        }
    }

    private final void dropExistingUndoActions() {
        List list = this.undoableActions.copyAndClear();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"copyAndClear(...)");
        List actions = list;
        for (Object e : actions) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            MyUndoableAction action = (MyUndoableAction)((Object)e);
            action.drop();
        }
    }

    @RequiresEdt
    private final void registerUndoAction(boolean undo) {
        List<RangeState> undoState = this.collectRangeStates$intellij_platform_vcs_impl();
        MyUndoableAction action = new MyUndoableAction(this.getProject(), this.getDocument(), undoState, undo);
        this.undoManager.undoableActionPerformed((UndoableAction)action);
        this.undoableActions.add((Object)action);
    }

    public final boolean hasPartialState$intellij_platform_vcs_impl() {
        return (Boolean)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.hasPartialState$lambda$0(this));
    }

    public final boolean hasPendingPartialState$intellij_platform_vcs_impl() {
        return (Boolean)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.hasPendingPartialState$lambda$0(this));
    }

    @Override
    public boolean hasPartialChangesToCommit() {
        return (Boolean)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.hasPartialChangesToCommit$lambda$0(this));
    }

    @Override
    @RequiresEdt
    @NotNull
    public PartialCommitHelper handlePartialCommit(@NotNull Side side, @NotNull List<String> changelistIds, boolean honorExcludedFromCommit) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changelistIds, (String)"changelistIds");
        ToCommitCondition toCommitCondition = new ToCommitCondition(changelistIds, honorExcludedFromCommit);
        String contentToCommit = (String)this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.handlePartialCommit$lambda$0(this, side, toCommitCondition));
        return new PartialCommitHelper(contentToCommit, this, side, toCommitCondition){
            final /* synthetic */ String $contentToCommit;
            final /* synthetic */ ChangelistsLocalLineStatusTracker this$0;
            final /* synthetic */ Side $side;
            final /* synthetic */ ToCommitCondition $toCommitCondition;
            {
                this.$contentToCommit = $contentToCommit;
                this.this$0 = $receiver;
                this.$side = $side;
                this.$toCommitCondition = $toCommitCondition;
                super($contentToCommit);
            }

            public void applyChanges() {
                ChangelistsLocalLineStatusTracker.access$applyPartialCommitChanges(this.this$0, this.$side, this.$toCommitCondition, this.$contentToCommit);
            }
        };
    }

    private final void applyPartialCommitChanges(Side side, ToCommitCondition toCommitCondition, String contentToCommit) {
        if (this.isReleased()) {
            return;
        }
        boolean success = this.updateDocument(side, arg_0 -> ChangelistsLocalLineStatusTracker.applyPartialCommitChanges$lambda$0(this, side, toCommitCondition, contentToCommit, arg_0));
        if (!success) {
            LOG.warn("Can't update document state on partial commit: " + this.getVirtualFile());
        }
    }

    @Override
    @RequiresEdt
    public void rollbackChanges(@NotNull List<String> changelistsIds, boolean honorExcludedFromCommit) {
        Intrinsics.checkNotNullParameter(changelistsIds, (String)"changelistsIds");
        ToCommitCondition toCommitCondition = new ToCommitCondition(changelistsIds, honorExcludedFromCommit);
        this.runBulkRollback(toCommitCondition);
    }

    @Override
    @Nullable
    public String getChangesToBeCommitted(@NotNull Side side, @NotNull List<String> changelistIds, boolean honorExcludedFromCommit) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changelistIds, (String)"changelistIds");
        return (String)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.getChangesToBeCommitted$lambda$0(this, changelistIds, honorExcludedFromCommit, side));
    }

    @Override
    @Nullable
    public PartialCommitContent getPartialCommitContent(@NotNull List<String> changelistIds, boolean honorExcludedFromCommit) {
        Intrinsics.checkNotNullParameter(changelistIds, (String)"changelistIds");
        return (PartialCommitContent)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.getPartialCommitContent$lambda$0(this, changelistIds, honorExcludedFromCommit));
    }

    @Override
    @RequiresEdt
    public void moveToChangelist(@NotNull Range range, @NotNull LocalChangeList changelist) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)changelist, (String)"changelist");
        DocumentTracker.Block newRange = (DocumentTracker.Block)this.getBlockOperations().findBlock(range);
        if (newRange != null) {
            this.moveToChangelist((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.moveToChangelist$lambda$0(newRange, arg_0)), changelist);
        }
    }

    @Override
    @RequiresEdt
    public void moveToChangelist(@NotNull BitSet lines, @NotNull LocalChangeList changelist) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)changelist, (String)"changelist");
        this.moveToChangelist((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.moveToChangelist$lambda$1(lines, arg_0)), changelist);
    }

    @RequiresEdt
    @ApiStatus.Internal
    public final void recreateBlocks(@NotNull Map<Range, ? extends LocalChangeList> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.changeListManager.executeUnderDataLock(() -> ChangelistsLocalLineStatusTracker.recreateBlocks$lambda$0(map2, this));
    }

    @RequiresEdt
    private final void moveToChangelist(Function1<? super DocumentTracker.Block, Boolean> condition, LocalChangeList changelist) {
        this.changeListManager.executeUnderDataLock(() -> ChangelistsLocalLineStatusTracker.moveToChangelist$lambda$2(this, changelist, condition));
    }

    @Override
    @NotNull
    public ExclusionState getExcludedFromCommitState(@NotNull String changelistId) {
        Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
        ChangeListMarker marker = new ChangeListMarker(changelistId);
        Ref.BooleanRef hasIncluded = new Ref.BooleanRef();
        Ref.BooleanRef hasExcluded = new Ref.BooleanRef();
        this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.getExcludedFromCommitState$lambda$0(this, marker, hasIncluded, hasExcluded));
        if (!hasExcluded.element && !hasIncluded.element) {
            return ExclusionState.NO_CHANGES;
        }
        if (hasExcluded.element && hasIncluded.element) {
            return ExclusionState.PARTIALLY;
        }
        if (hasExcluded.element) {
            return ExclusionState.ALL_EXCLUDED;
        }
        return ExclusionState.ALL_INCLUDED;
    }

    @Override
    @RequiresEdt
    public void setExcludedFromCommit(boolean isExcluded) {
        this.setExcludedFromCommit((Function1<? super DocumentTracker.Block, Boolean>)((Function1)ChangelistsLocalLineStatusTracker::setExcludedFromCommit$lambda$0), isExcluded);
        if (!this.isOperational()) {
            Iterator<String> iterator = this.affectedChangeLists.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String changelistId;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                this.initialExcludeState.put(new ChangeListMarker(changelistId), isExcluded);
            }
        }
    }

    @Override
    public void setExcludedFromCommit(@NotNull String changelistId, boolean isExcluded) {
        Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
        ChangeListMarker marker = new ChangeListMarker(changelistId);
        this.setExcludedFromCommit((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.setExcludedFromCommit$lambda$1(this, marker, arg_0)), isExcluded);
        if (!this.isOperational()) {
            this.initialExcludeState.put(marker, isExcluded);
        }
    }

    @Override
    public void setExcludedFromCommit(@NotNull Range range, boolean isExcluded) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DocumentTracker.Block newRange = (DocumentTracker.Block)this.getBlockOperations().findBlock(range);
        this.setExcludedFromCommit((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.setExcludedFromCommit$lambda$2(newRange, arg_0)), isExcluded);
    }

    @Override
    public void setExcludedFromCommit(@NotNull BitSet lines, boolean isExcluded) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.setExcludedFromCommit((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.setExcludedFromCommit$lambda$3(lines, arg_0)), isExcluded);
    }

    private final void setExcludedFromCommit(Function1<? super DocumentTracker.Block, Boolean> condition, boolean isExcluded) {
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.setExcludedFromCommit$lambda$4(this, condition, isExcluded));
        this.fireExcludedFromCommitChanged();
    }

    @Override
    public void setPartiallyExcludedFromCommit(@NotNull BitSet lines, @NotNull Side side, boolean isExcluded) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.setPartiallyExcludedFromCommit$lambda$0(this, lines, side, isExcluded));
        this.fireExcludedFromCommitChanged();
    }

    private final void setPartiallyExcludedFromCommit(DocumentTracker.Block block, BitSet lines, Side side, boolean isExcluded) {
        int blockEnd;
        int blockStart = side.select(block.getVcsStart(), block.getStart());
        if (!DiffUtil.isSelectedByLine((BitSet)lines, (int)blockStart, (int)(blockEnd = side.select(block.getVcsEnd(), block.getEnd())))) {
            return;
        }
        int linesStart = lines.nextSetBit(0);
        int linesEnd = lines.length();
        if (blockEnd <= linesStart || blockStart >= linesEnd) {
            return;
        }
        int deletionsCount = block.getVcsEnd() - block.getVcsStart();
        int additionsCount = block.getEnd() - block.getStart();
        BitSet includedAdditions = new BitSet();
        BitSet includedDeletions = new BitSet();
        BitSet updatedSet = (BitSet)side.selectNotNull((Object)includedDeletions, (Object)includedAdditions);
        RangeExclusionState previousState = this.getExcludedFromCommit(block);
        if (previousState instanceof RangeExclusionState.Partial) {
            ((RangeExclusionState.Partial)previousState).validate(deletionsCount, additionsCount);
            ((RangeExclusionState.Partial)previousState).copyIncludedInto(includedDeletions, includedAdditions);
        }
        if (previousState instanceof RangeExclusionState.Included && isExcluded) {
            updatedSet.set(0, side.select(deletionsCount, additionsCount));
        }
        this.iterateIncludedRangesBetween(lines, blockStart, blockEnd, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> ChangelistsLocalLineStatusTracker.setPartiallyExcludedFromCommit$lambda$1(updatedSet, blockStart, isExcluded, arg_0, arg_1)));
        this.setExcludedFromCommit(block, (RangeExclusionState)new RangeExclusionState.Partial(deletionsCount, additionsCount, includedDeletions, includedAdditions));
    }

    private final void iterateIncludedRangesBetween(BitSet set2, int start2, int end, Function2<? super Integer, ? super Integer, Unit> consumer) {
        int nextStart;
        int index = start2;
        while ((nextStart = set2.nextSetBit(index)) != -1 && nextStart < end) {
            int nextEnd = RangesKt.coerceAtMost((int)set2.nextClearBit(nextStart), (int)end);
            consumer.invoke((Object)nextStart, (Object)nextEnd);
            index = nextEnd;
            if (nextEnd != end) continue;
            break;
        }
    }

    private final void fireExcludedFromCommitChanged() {
        ((PartialLocalLineStatusTracker.Listener)this.eventDispatcher.getMulticaster()).onExcludedFromCommitChange(this);
    }

    public final void resetExcludedFromCommitMarkers$intellij_platform_vcs_impl() {
        this.setExcludedFromCommit(false);
        this.dropExistingUndoActions();
    }

    @RequiresReadLock
    @NotNull
    public final FullState storeTrackerState$intellij_platform_vcs_impl() {
        return (FullState)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.storeTrackerState$lambda$0(this));
    }

    @RequiresEdt
    public final boolean restoreState$intellij_platform_vcs_impl(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof FullState) {
            return this.restoreFullState((FullState)state);
        }
        return this.restoreState(state.getRanges());
    }

    @RequiresReadLock
    @NotNull
    public final List<RangeState> collectRangeStates$intellij_platform_vcs_impl() {
        return (List)this.getDocumentTracker().readLock(() -> ChangelistsLocalLineStatusTracker.collectRangeStates$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean restoreFullState(FullState state) {
        void this_$iv$iv;
        Ref.BooleanRef success = new Ref.BooleanRef();
        DocumentTracker this_$iv = this.getDocumentTracker();
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                this.changeListManager.executeUnderDataLock(() -> ChangelistsLocalLineStatusTracker.restoreFullState$lambda$0$0(this, success, state));
                if (success.element) {
                    this.updateDocument(Side.LEFT, arg_0 -> ChangelistsLocalLineStatusTracker.restoreFullState$lambda$0$1(this, state, arg_0));
                }
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
        return success.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    private final boolean restoreState(List<RangeState> states) {
        void this_$iv$iv;
        Ref.BooleanRef success = new Ref.BooleanRef();
        DocumentTracker this_$iv = this.getDocumentTracker();
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                this.changeListManager.executeUnderDataLock(() -> ChangelistsLocalLineStatusTracker.restoreState$lambda$0$0(this, success, states));
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
        return success.element;
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreChangelistsState(List<RangeState> states) {
        DocumentTracker.Block it;
        String $this$mapTo$iv$iv;
        List<LocalChangeList> list = this.changeListManager.getChangeLists();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChangeLists(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List changelistIds = (List)destination$iv$iv;
        Map map2 = ContainerUtil.newMapFromKeys(changelistIds.iterator(), arg_0 -> ChangelistsLocalLineStatusTracker.restoreChangelistsState$lambda$2(ChangelistsLocalLineStatusTracker::restoreChangelistsState$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"newMapFromKeys(...)");
        Map idToMarker = map2;
        boolean bl = $i$f$map = this.getBlocks().size() == states.size();
        if (_Assertions.ENABLED && !$i$f$map) {
            $this$mapTo$iv$iv = "Assertion failed";
            throw new AssertionError((Object)$this$mapTo$iv$iv);
        }
        Iterable $this$forEachIndexed$iv = this.getBlocks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            RangeExclusionState it2;
            void block;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (DocumentTracker.Block)item$iv;
            int i = n;
            boolean bl2 = false;
            ChangeListMarker changeListMarker = (ChangeListMarker)idToMarker.get(states.get(i).getChangelistId());
            if (changeListMarker == null) {
                changeListMarker = this.defaultMarker;
            }
            this.setMarker((DocumentTracker.Block)block, changeListMarker);
            if (states.get(i).getExcludedFromCommit() == null) continue;
            boolean bl3 = false;
            this.setExcludedFromCommit((DocumentTracker.Block)block, it2);
        }
        ChangelistsLocalLineStatusTracker.updateAffectedChangeLists$default(this, false, 1, null);
        this.updateHighlighters();
    }

    @Override
    public void addListener(@NotNull PartialLocalLineStatusTracker.Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    @Override
    public void addListener(@NotNull LineStatusTrackerListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.getListeners().addListener((EventListener)listener2, disposable);
    }

    @Override
    @NotNull
    protected ChangeListBlockData getOurData(@NotNull DocumentTracker.Block $this$ourData) {
        Intrinsics.checkNotNullParameter((Object)$this$ourData, (String)"<this>");
        if ($this$ourData.getData() == null) {
            $this$ourData.setData((DocumentTracker.BlockData)new ChangeListBlockData(null, null, null, null, 15, null));
        }
        DocumentTracker.BlockData blockData = $this$ourData.getData();
        Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker.ChangeListBlockData");
        return (ChangeListBlockData)blockData;
    }

    private final ChangeListMarker getMarker(DocumentTracker.Block $this$marker) {
        ChangeListMarker changeListMarker = this.getOurData($this$marker).getMarker();
        if (changeListMarker == null) {
            DocumentTracker.Block $this$_get_marker__u24lambda_u240 = $this$marker;
            boolean bl = false;
            LOG.error("Line range changelist was not set yet", new Throwable());
            this.getOurData($this$_get_marker__u24lambda_u240).setMarker(this.defaultMarker);
            changeListMarker = this.defaultMarker;
        }
        return changeListMarker;
    }

    private final void setMarker(DocumentTracker.Block $this$marker, ChangeListMarker value) {
        this.getOurData($this$marker).setMarker(value);
    }

    private final RangeExclusionState getExcludedFromCommit(DocumentTracker.Block $this$excludedFromCommit) {
        return this.getOurData($this$excludedFromCommit).getExcludedFromCommit();
    }

    private final void setExcludedFromCommit(DocumentTracker.Block $this$excludedFromCommit, RangeExclusionState value) {
        this.getOurData($this$excludedFromCommit).setExcludedFromCommit(value);
    }

    private static final void _init_$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        this$0.dropExistingUndoActions();
    }

    private static final void _init_$lambda$1(ChangelistsLocalLineStatusTracker this$0) {
        this$0.eventDispatcher.getListeners().clear();
    }

    private static final Unit toIncludedRanges$lambda$0(List $result, ChangelistsLocalLineStatusTracker this$0, DocumentTracker.Block $block, String $changelistId, com.intellij.diff.util.Range deletedRange) {
        Intrinsics.checkNotNullParameter((Object)deletedRange, (String)"deletedRange");
        ((Collection)$result).add(new LocalRange(deletedRange.start1, deletedRange.end1, deletedRange.start2, deletedRange.end2, null, this$0.getOurData($block).getClientIds(), $changelistId, (RangeExclusionState)RangeExclusionState.Included.INSTANCE));
        return Unit.INSTANCE;
    }

    private static final Unit toIncludedRanges$lambda$1(List $result, ChangelistsLocalLineStatusTracker this$0, DocumentTracker.Block $block, String $changelistId, com.intellij.diff.util.Range addedRange) {
        Intrinsics.checkNotNullParameter((Object)addedRange, (String)"addedRange");
        ((Collection)$result).add(new LocalRange(addedRange.start1, addedRange.end1, addedRange.start2, addedRange.end2, null, this$0.getOurData($block).getClientIds(), $changelistId, (RangeExclusionState)RangeExclusionState.Included.INSTANCE));
        return Unit.INSTANCE;
    }

    private static final List getAffectedChangeListsIds$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        boolean bl;
        boolean bl2 = bl = !this$0.affectedChangeLists.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return CollectionsKt.toList((Iterable)this$0.affectedChangeLists);
    }

    private static final Unit setBaseRevision$lambda$0$0$0(ChangelistsLocalLineStatusTracker this$0) {
        this$0.getDocumentTracker().updateFrozenContentIfNeeded();
        return Unit.INSTANCE;
    }

    private static final void setBaseRevision$lambda$0$0(ChangelistsLocalLineStatusTracker this$0) {
        this$0.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.setBaseRevision$lambda$0$0$0(this$0));
    }

    private static final Unit setBaseRevision$lambda$0(String $changelistId, ChangelistsLocalLineStatusTracker this$0) {
        if ($changelistId != null) {
            this$0.activeChangeListTracker.runUnderChangeList($changelistId, () -> ChangelistsLocalLineStatusTracker.setBaseRevision$lambda$0$0(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit setBaseRevision$lambda$1(ChangelistsLocalLineStatusTracker this$0) {
        ChangelistsLocalLineStatusTracker.updateAffectedChangeLists$default(this$0, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit replayChangesFromDocumentEvents$lambda$0(List $events, Document vcsDocument) {
        Intrinsics.checkNotNullParameter((Object)vcsDocument, (String)"vcsDocument");
        for (DocumentEvent event : CollectionsKt.reversed((Iterable)$events)) {
            vcsDocument.replaceString(event.getOffset(), event.getOffset() + event.getNewLength(), event.getOldFragment());
        }
        return Unit.INSTANCE;
    }

    private static final boolean initChangeTracking$lambda$0$0(Set $idsSet, ChangelistsLocalLineStatusTracker this$0, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$idsSet.contains(this$0.getMarker(it).getChangelistId());
    }

    private static final Unit initChangeTracking$lambda$0(ChangelistsLocalLineStatusTracker this$0, String $defaultId, String $fileChangelistId, List $changelistsIds) {
        this$0.defaultMarker = new ChangeListMarker($defaultId);
        if (!this$0.isInitialized()) {
            this$0.initialChangeListId = $fileChangelistId;
        }
        this$0.lastKnownTrackerChangeListId = $fileChangelistId;
        Set idsSet = CollectionsKt.toSet((Iterable)$changelistsIds);
        this$0.moveMarkers((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.initChangeTracking$lambda$0$0(idsSet, this$0, arg_0)), this$0.defaultMarker);
        this$0.updateAffectedChangeLists(false);
        return Unit.INSTANCE;
    }

    private static final Unit defaultListChanged$lambda$0(ChangelistsLocalLineStatusTracker this$0, String $newListId) {
        this$0.defaultMarker = new ChangeListMarker($newListId);
        return Unit.INSTANCE;
    }

    private static final boolean changeListRemoved$lambda$0$0(ChangelistsLocalLineStatusTracker this$0, String $listId, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.getMarker(it).getChangelistId(), (Object)$listId);
    }

    private static final Unit changeListRemoved$lambda$0(ChangelistsLocalLineStatusTracker this$0, String $listId) {
        if (!this$0.affectedChangeLists.contains($listId)) {
            return Unit.INSTANCE;
        }
        if (!this$0.isInitialized() && Intrinsics.areEqual((Object)this$0.initialChangeListId, (Object)$listId)) {
            this$0.initialChangeListId = null;
        }
        if (Intrinsics.areEqual((Object)this$0.lastKnownTrackerChangeListId, (Object)$listId)) {
            this$0.lastKnownTrackerChangeListId = null;
        }
        this$0.moveMarkers((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.changeListRemoved$lambda$0$0(this$0, $listId, arg_0)), this$0.defaultMarker);
        this$0.updateAffectedChangeLists(false);
        return Unit.INSTANCE;
    }

    private static final boolean moveChanges$lambda$0$0(ChangelistsLocalLineStatusTracker this$0, String $fromListId, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.getMarker(it).getChangelistId(), (Object)$fromListId);
    }

    private static final Unit moveChanges$lambda$0(ChangelistsLocalLineStatusTracker this$0, String $fromListId, String $toListId) {
        if (!this$0.affectedChangeLists.contains($fromListId)) {
            return Unit.INSTANCE;
        }
        if (!this$0.isInitialized() && Intrinsics.areEqual((Object)this$0.initialChangeListId, (Object)$fromListId)) {
            this$0.initialChangeListId = $toListId;
        }
        if (Intrinsics.areEqual((Object)this$0.lastKnownTrackerChangeListId, (Object)$fromListId)) {
            this$0.lastKnownTrackerChangeListId = $toListId;
        }
        this$0.moveMarkers((Function1<? super DocumentTracker.Block, Boolean>)((Function1)arg_0 -> ChangelistsLocalLineStatusTracker.moveChanges$lambda$0$0(this$0, $fromListId, arg_0)), new ChangeListMarker($toListId));
        this$0.updateAffectedChangeLists(false);
        return Unit.INSTANCE;
    }

    private static final boolean moveChangesTo$lambda$0$0(DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit moveChangesTo$lambda$0(ChangelistsLocalLineStatusTracker this$0, String $toListId) {
        if (!this$0.isInitialized()) {
            this$0.initialChangeListId = $toListId;
        }
        this$0.lastKnownTrackerChangeListId = $toListId;
        this$0.moveMarkers((Function1<? super DocumentTracker.Block, Boolean>)((Function1)ChangelistsLocalLineStatusTracker::moveChangesTo$lambda$0$0), new ChangeListMarker($toListId));
        this$0.updateAffectedChangeLists(false);
        return Unit.INSTANCE;
    }

    private static final boolean hasPartialState$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        if (this$0.getAffectedChangeListsIds().size() > 1) {
            return true;
        }
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        Iterable $this$forEach$iv = this$0.getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
            boolean bl = false;
            RangeExclusionState exclusionState = this$0.getExcludedFromCommit(it);
            if (exclusionState.getHasIncluded()) {
                hasIncluded = true;
            }
            if (!exclusionState.getHasExcluded()) continue;
            hasExcluded = true;
        }
        return hasIncluded && hasExcluded;
    }

    private static final boolean hasPendingPartialState$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        return !this$0.initialExcludeState.isEmpty() || this$0.initialChangeListId != null && !CollectionsKt.contains((Iterable)this$0.getAffectedChangeListsIds(), (Object)this$0.initialChangeListId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasPartialChangesToCommit$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        DocumentTracker.Block it;
        if (this$0.affectedChangeLists.size() > 1) return true;
        Iterable $this$any$iv = this$0.getBlocks();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (DocumentTracker.Block)element$iv;
            boolean bl = false;
        } while (!this$0.getExcludedFromCommit(it).getHasExcluded());
        return true;
    }

    private static final String handlePartialCommit$lambda$0(ChangelistsLocalLineStatusTracker this$0, Side $side, ToCommitCondition $toCommitCondition) {
        this$0.getDocumentTracker().updateFrozenContentIfNeeded();
        String string = this$0.getDocumentTracker().getContentWithPartiallyAppliedBlocks($side, (Function1)$toCommitCondition);
        if (string == null) {
            ChangelistsLocalLineStatusTracker $this$handlePartialCommit_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            LOG.warn("handlePartialCommit - frozen tracker: " + $this$handlePartialCommit_u24lambda_u240_u240);
            string = ((Object)$this$handlePartialCommit_u24lambda_u240_u240.getDocumentTracker().getContent($side)).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applyPartialCommitChanges$lambda$0(ChangelistsLocalLineStatusTracker this$0, Side $side, ToCommitCondition $toCommitCondition, String $contentToCommit, Document doc) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        DocumentTracker documentTracker = this$0.getDocumentTracker();
        Side side$iv = $side;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side$iv);
        try {
            boolean bl = false;
            this$0.getDocumentTracker().partiallyApplyBlocks($side, (Function1)$toCommitCondition);
            doc.setText((CharSequence)$contentToCommit);
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
        return Unit.INSTANCE;
    }

    private static final String getChangesToBeCommitted$lambda$0(ChangelistsLocalLineStatusTracker this$0, List $changelistIds, boolean $honorExcludedFromCommit, Side $side) {
        if (!this$0.isValid() || this$0.getDocumentTracker().isFrozen()) {
            return null;
        }
        ToCommitCondition toCommitCondition = this$0.new ToCommitCondition($changelistIds, $honorExcludedFromCommit);
        String string = this$0.getDocumentTracker().getContentWithPartiallyAppliedBlocks($side, (Function1)toCommitCondition);
        if (string == null) {
            ChangelistsLocalLineStatusTracker $this$getChangesToBeCommitted_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            LOG.warn("getChangesToBeCommitted - frozen tracker: " + $this$getChangesToBeCommitted_u24lambda_u240_u240);
            string = ((Object)$this$getChangesToBeCommitted_u24lambda_u240_u240.getDocumentTracker().getContent($side)).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final PartialCommitContent getPartialCommitContent$lambda$0(ChangelistsLocalLineStatusTracker this$0, List $changelistIds, boolean $honorExcludedFromCommit) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        if (!this$0.isValid()) {
            return null;
        }
        ToCommitCondition toCommitCondition = this$0.new ToCommitCondition($changelistIds, $honorExcludedFromCommit);
        CharSequence vcsContent = this$0.getDocumentTracker().getContent(Side.LEFT);
        CharSequence currentContent = this$0.getDocumentTracker().getContent(Side.RIGHT);
        Iterable $this$filter$iv = this$0.getBlocks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DocumentTracker.Block it = (DocumentTracker.Block)element$iv$iv;
            boolean bl = false;
            if (!(!it.getRange().isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<LocalRange> list;
            DocumentTracker.Block block = (DocumentTracker.Block)element$iv$iv;
            boolean bl = false;
            RangeExclusionState exclusionState = toCommitCondition.invoke(block);
            RangeExclusionState rangeExclusionState = exclusionState;
            if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Included.INSTANCE)) {
                list = CollectionsKt.listOf((Object)this$0.toRange(block));
            } else if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Excluded.INSTANCE)) {
                list = CollectionsKt.emptyList();
            } else if (rangeExclusionState instanceof RangeExclusionState.Partial) {
                list = this$0.toIncludedRanges(block, (RangeExclusionState.Partial)exclusionState);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List ranges = (List)destination$iv$iv;
        return new PartialCommitContent(vcsContent, currentContent, ranges);
    }

    private static final boolean moveToChangelist$lambda$0(DocumentTracker.Block $newRange, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$newRange);
    }

    private static final boolean moveToChangelist$lambda$1(BitSet $lines, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LineStatusTrackerBlockOperations.Companion.isSelectedByLine((BlockI)it, $lines);
    }

    private static final Unit recreateBlocks$lambda$0$1(ChangelistsLocalLineStatusTracker this$0, Map $rangesToBlockData) {
        this$0.getDocumentTracker().recreateBlocks($rangesToBlockData);
        this$0.dropExistingUndoActions();
        this$0.updateHighlighters();
        ChangelistsLocalLineStatusTracker.updateAffectedChangeLists$default(this$0, false, 1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void recreateBlocks$lambda$0(Map $map, ChangelistsLocalLineStatusTracker this$0) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $map.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Range range = (Range)entry.getKey();
            LocalChangeList changelist = (LocalChangeList)entry.getValue();
            if (this$0.changeListManager.getChangeList(changelist.getId()) == null) {
                return;
            }
            ChangeListMarker newMarker = new ChangeListMarker(changelist);
            entry = TuplesKt.to((Object)new com.intellij.diff.util.Range(range.getVcsLine1(), range.getVcsLine2(), range.getLine1(), range.getLine2()), (Object)new ChangeListBlockData(null, null, newMarker, null, 11, null));
            map2.put(entry.getFirst(), entry.getSecond());
        }
        Map rangesToBlockData = destination$iv$iv;
        this$0.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.recreateBlocks$lambda$0$1(this$0, rangesToBlockData));
    }

    private static final Unit moveToChangelist$lambda$2$0(ChangelistsLocalLineStatusTracker this$0, Function1 $condition, ChangeListMarker $newMarker) {
        this$0.moveMarkers((Function1<? super DocumentTracker.Block, Boolean>)$condition, $newMarker);
        ChangelistsLocalLineStatusTracker.updateAffectedChangeLists$default(this$0, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final void moveToChangelist$lambda$2(ChangelistsLocalLineStatusTracker this$0, LocalChangeList $changelist, Function1 $condition) {
        if (this$0.changeListManager.getChangeList($changelist.getId()) == null) {
            return;
        }
        ChangeListMarker newMarker = new ChangeListMarker($changelist);
        this$0.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.moveToChangelist$lambda$2$0(this$0, $condition, newMarker));
    }

    private static final Unit getExcludedFromCommitState$lambda$0(ChangelistsLocalLineStatusTracker this$0, ChangeListMarker $marker, Ref.BooleanRef $hasIncluded, Ref.BooleanRef $hasExcluded) {
        for (DocumentTracker.Block block : this$0.getBlocks()) {
            if (!Intrinsics.areEqual((Object)this$0.getMarker(block), (Object)$marker)) continue;
            RangeExclusionState exclusionState = this$0.getExcludedFromCommit(block);
            if (exclusionState.getHasIncluded()) {
                $hasIncluded.element = true;
            }
            if (!exclusionState.getHasExcluded()) continue;
            $hasExcluded.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final boolean setExcludedFromCommit$lambda$0(DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean setExcludedFromCommit$lambda$1(ChangelistsLocalLineStatusTracker this$0, ChangeListMarker $marker, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.getMarker(it), (Object)$marker);
    }

    private static final boolean setExcludedFromCommit$lambda$2(DocumentTracker.Block $newRange, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$newRange);
    }

    private static final boolean setExcludedFromCommit$lambda$3(BitSet $lines, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LineStatusTrackerBlockOperations.Companion.isSelectedByLine((BlockI)it, $lines);
    }

    private static final Unit setExcludedFromCommit$lambda$4(ChangelistsLocalLineStatusTracker this$0, Function1 $condition, boolean $isExcluded) {
        for (DocumentTracker.Block block : this$0.getBlocks()) {
            if (!((Boolean)$condition.invoke((Object)block)).booleanValue()) continue;
            this$0.setExcludedFromCommit(block, $isExcluded ? (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE : (RangeExclusionState)RangeExclusionState.Included.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setPartiallyExcludedFromCommit$lambda$0(ChangelistsLocalLineStatusTracker this$0, BitSet $lines, Side $side, boolean $isExcluded) {
        for (DocumentTracker.Block block : this$0.getBlocks()) {
            this$0.setPartiallyExcludedFromCommit(block, $lines, $side, $isExcluded);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setPartiallyExcludedFromCommit$lambda$1(BitSet $updatedSet, int $blockStart, boolean $isExcluded, int start2, int end) {
        $updatedSet.set(start2 - $blockStart, end - $blockStart, !$isExcluded);
        return Unit.INSTANCE;
    }

    private static final FullState storeTrackerState$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        CharSequence vcsContent = this$0.getDocumentTracker().getContent(Side.LEFT);
        CharSequence currentContent = this$0.getDocumentTracker().getContent(Side.RIGHT);
        List<RangeState> rangeStates = this$0.collectRangeStates$intellij_platform_vcs_impl();
        return new FullState(this$0.getVirtualFile(), rangeStates, ((Object)vcsContent).toString(), ((Object)currentContent).toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final List collectRangeStates$lambda$0(ChangelistsLocalLineStatusTracker this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentTracker.Block block = (DocumentTracker.Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RangeState(it.getRange(), this$0.getMarker((DocumentTracker.Block)it).getChangelistId(), this$0.getExcludedFromCommit((DocumentTracker.Block)it)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit restoreFullState$lambda$0$0$0(Ref.BooleanRef $success, ChangelistsLocalLineStatusTracker this$0, FullState $state) {
        Collection<com.intellij.diff.util.Range> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $state.getRanges();
        CharSequence charSequence = $state.getCurrentContent();
        CharSequence charSequence2 = $state.getVcsContent();
        DocumentTracker documentTracker = this$0.getDocumentTracker();
        Ref.BooleanRef booleanRef = $success;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RangeState rangeState = (RangeState)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRange());
        }
        collection = (List)destination$iv$iv;
        booleanRef.element = documentTracker.setFrozenState(charSequence2, charSequence, (List)collection);
        if ($success.element) {
            this$0.restoreChangelistsState($state.getRanges());
        }
        return Unit.INSTANCE;
    }

    private static final void restoreFullState$lambda$0$0(ChangelistsLocalLineStatusTracker this$0, Ref.BooleanRef $success, FullState $state) {
        this$0.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.restoreFullState$lambda$0$0$0($success, this$0, $state));
    }

    private static final Unit restoreFullState$lambda$0$1(ChangelistsLocalLineStatusTracker this$0, FullState $state, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getVcsDocument().setText((CharSequence)$state.getVcsContent());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit restoreState$lambda$0$0$0(Ref.BooleanRef $success, ChangelistsLocalLineStatusTracker this$0, List $states) {
        Collection<com.intellij.diff.util.Range> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $states;
        DocumentTracker documentTracker = this$0.getDocumentTracker();
        Ref.BooleanRef booleanRef = $success;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RangeState rangeState = (RangeState)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRange());
        }
        collection = (List)destination$iv$iv;
        booleanRef.element = documentTracker.setFrozenState((List)collection);
        if ($success.element) {
            this$0.restoreChangelistsState($states);
        }
        return Unit.INSTANCE;
    }

    private static final void restoreState$lambda$0$0(ChangelistsLocalLineStatusTracker this$0, Ref.BooleanRef $success, List $states) {
        this$0.getDocumentTracker().writeLock(() -> ChangelistsLocalLineStatusTracker.restoreState$lambda$0$0$0($success, this$0, $states));
    }

    private static final ChangeListMarker restoreChangelistsState$lambda$1(String it) {
        Intrinsics.checkNotNull((Object)it);
        return new ChangeListMarker(it);
    }

    private static final ChangeListMarker restoreChangelistsState$lambda$2(Function1 $tmp0, Object p0) {
        return (ChangeListMarker)$tmp0.invoke(p0);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final ChangelistsLocalLineStatusTracker createTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile) {
        return Companion.createTracker(project, document, virtualFile);
    }

    public static final /* synthetic */ ActiveChangeListTracker access$getActiveChangeListTracker$p(ChangelistsLocalLineStatusTracker $this) {
        return $this.activeChangeListTracker;
    }

    public static final /* synthetic */ LineStatusTrackerManager access$getLstManager$p(ChangelistsLocalLineStatusTracker $this) {
        return $this.lstManager;
    }

    public static final /* synthetic */ void access$applyPartialCommitChanges(ChangelistsLocalLineStatusTracker $this, Side side, ToCommitCondition toCommitCondition, String contentToCommit) {
        $this.applyPartialCommitChanges(side, toCommitCondition, contentToCommit);
    }

    static {
        Logger logger = Logger.getInstance(ChangelistsLocalLineStatusTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B?\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JA\u0010\u001f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020'H\u00d6\u0081\u0004R\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListBlockData;", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalBlockData;", "innerRanges", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "clientIds", "Lcom/intellij/codeWithMe/ClientId;", "marker", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;", "excludedFromCommit", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;Lcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "getInnerRanges", "()Ljava/util/List;", "setInnerRanges", "(Ljava/util/List;)V", "getClientIds", "setClientIds", "getMarker", "()Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;", "setMarker", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;)V", "getExcludedFromCommit", "()Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "setExcludedFromCommit", "(Lcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    protected static final class ChangeListBlockData
    implements LocalLineStatusTrackerImpl.LocalBlockData {
        @Nullable
        private List<Range.InnerRange> innerRanges;
        @NotNull
        private List<ClientId> clientIds;
        @Nullable
        private ChangeListMarker marker;
        @NotNull
        private RangeExclusionState excludedFromCommit;

        public ChangeListBlockData(@Nullable List<Range.InnerRange> innerRanges, @NotNull List<ClientId> clientIds, @Nullable ChangeListMarker marker, @NotNull RangeExclusionState excludedFromCommit) {
            Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
            Intrinsics.checkNotNullParameter((Object)excludedFromCommit, (String)"excludedFromCommit");
            this.innerRanges = innerRanges;
            this.clientIds = clientIds;
            this.marker = marker;
            this.excludedFromCommit = excludedFromCommit;
        }

        public /* synthetic */ ChangeListBlockData(List list, List list2, ChangeListMarker changeListMarker, RangeExclusionState rangeExclusionState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                changeListMarker = null;
            }
            if ((n & 8) != 0) {
                rangeExclusionState = (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
            }
            this(list, list2, changeListMarker, rangeExclusionState);
        }

        @Override
        @Nullable
        public List<Range.InnerRange> getInnerRanges() {
            return this.innerRanges;
        }

        @Override
        public void setInnerRanges(@Nullable List<Range.InnerRange> list) {
            this.innerRanges = list;
        }

        @Override
        @NotNull
        public List<ClientId> getClientIds() {
            return this.clientIds;
        }

        @Override
        public void setClientIds(@NotNull List<ClientId> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.clientIds = list;
        }

        @Nullable
        public final ChangeListMarker getMarker() {
            return this.marker;
        }

        public final void setMarker(@Nullable ChangeListMarker changeListMarker) {
            this.marker = changeListMarker;
        }

        @NotNull
        public final RangeExclusionState getExcludedFromCommit() {
            return this.excludedFromCommit;
        }

        public final void setExcludedFromCommit(@NotNull RangeExclusionState rangeExclusionState) {
            Intrinsics.checkNotNullParameter((Object)rangeExclusionState, (String)"<set-?>");
            this.excludedFromCommit = rangeExclusionState;
        }

        @Nullable
        public final List<Range.InnerRange> component1() {
            return this.innerRanges;
        }

        @NotNull
        public final List<ClientId> component2() {
            return this.clientIds;
        }

        @Nullable
        public final ChangeListMarker component3() {
            return this.marker;
        }

        @NotNull
        public final RangeExclusionState component4() {
            return this.excludedFromCommit;
        }

        @NotNull
        public final ChangeListBlockData copy(@Nullable List<Range.InnerRange> innerRanges, @NotNull List<ClientId> clientIds, @Nullable ChangeListMarker marker, @NotNull RangeExclusionState excludedFromCommit) {
            Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
            Intrinsics.checkNotNullParameter((Object)excludedFromCommit, (String)"excludedFromCommit");
            return new ChangeListBlockData(innerRanges, clientIds, marker, excludedFromCommit);
        }

        public static /* synthetic */ ChangeListBlockData copy$default(ChangeListBlockData changeListBlockData, List list, List list2, ChangeListMarker changeListMarker, RangeExclusionState rangeExclusionState, int n, Object object) {
            if ((n & 1) != 0) {
                list = changeListBlockData.innerRanges;
            }
            if ((n & 2) != 0) {
                list2 = changeListBlockData.clientIds;
            }
            if ((n & 4) != 0) {
                changeListMarker = changeListBlockData.marker;
            }
            if ((n & 8) != 0) {
                rangeExclusionState = changeListBlockData.excludedFromCommit;
            }
            return changeListBlockData.copy(list, list2, changeListMarker, rangeExclusionState);
        }

        @NotNull
        public String toString() {
            return "ChangeListBlockData(innerRanges=" + this.innerRanges + ", clientIds=" + this.clientIds + ", marker=" + this.marker + ", excludedFromCommit=" + this.excludedFromCommit + ")";
        }

        public int hashCode() {
            int result2 = this.innerRanges == null ? 0 : ((Object)this.innerRanges).hashCode();
            result2 = result2 * 31 + ((Object)this.clientIds).hashCode();
            result2 = result2 * 31 + (this.marker == null ? 0 : this.marker.hashCode());
            result2 = result2 * 31 + this.excludedFromCommit.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangeListBlockData)) {
                return false;
            }
            ChangeListBlockData changeListBlockData = (ChangeListBlockData)other;
            if (!Intrinsics.areEqual(this.innerRanges, changeListBlockData.innerRanges)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.clientIds, changeListBlockData.clientIds)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.marker, (Object)changeListBlockData.marker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.excludedFromCommit, (Object)changeListBlockData.excludedFromCommit);
        }

        public ChangeListBlockData() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ChangeListMarker;", "", "changelistId", "", "<init>", "(Ljava/lang/String;)V", "changelist", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "getChangelistId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
    protected static final class ChangeListMarker {
        @NotNull
        private final String changelistId;

        public ChangeListMarker(@NotNull String changelistId) {
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            this.changelistId = changelistId;
        }

        @NotNull
        public final String getChangelistId() {
            return this.changelistId;
        }

        public ChangeListMarker(@NotNull LocalChangeList changelist) {
            Intrinsics.checkNotNullParameter((Object)changelist, (String)"changelist");
            String string = changelist.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            this(string);
        }

        @NotNull
        public final String component1() {
            return this.changelistId;
        }

        @NotNull
        public final ChangeListMarker copy(@NotNull String changelistId) {
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            return new ChangeListMarker(changelistId);
        }

        public static /* synthetic */ ChangeListMarker copy$default(ChangeListMarker changeListMarker, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = changeListMarker.changelistId;
            }
            return changeListMarker.copy(string);
        }

        @NotNull
        public String toString() {
            return "ChangeListMarker(changelistId=" + this.changelistId + ")";
        }

        public int hashCode() {
            return this.changelistId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangeListMarker)) {
                return false;
            }
            ChangeListMarker changeListMarker = (ChangeListMarker)other;
            return Intrinsics.areEqual((Object)this.changelistId, (Object)changeListMarker.changelistId);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createTracker", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final ChangelistsLocalLineStatusTracker createTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return new ChangelistsLocalLineStatusTracker(project, document, virtualFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "vcsContent", "", "currentContent", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getVcsContent", "()Ljava/lang/String;", "getCurrentContent", "intellij.platform.vcs.impl"})
    public static final class FullState
    extends State {
        @NotNull
        private final String vcsContent;
        @NotNull
        private final String currentContent;

        public FullState(@NotNull VirtualFile virtualFile, @NotNull List<RangeState> ranges, @NotNull String vcsContent, @NotNull String currentContent) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
            Intrinsics.checkNotNullParameter((Object)currentContent, (String)"currentContent");
            super(virtualFile, ranges);
            this.vcsContent = vcsContent;
            this.currentContent = currentContent;
        }

        @NotNull
        public final String getVcsContent() {
            return this.vcsContent;
        }

        @NotNull
        public final String getCurrentContent() {
            return this.currentContent;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J,\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u0017H\u0014J(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J*\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\"\u001a\u00020#H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "paintGutterMarkers", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "g", "Ljava/awt/Graphics;", "createAdditionalInfoPanel", "Ljavax/swing/JComponent;", "range", "mousePosition", "Ljava/awt/Point;", "disposable", "Lcom/intellij/openapi/Disposable;", "createCommitPanel", "point", "createAdditionalToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "popupDisposable", "createChangeListActions", "findRange", "moveToChangeList", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "toString", "", "MyFlagsProvider", "MoveToAnotherChangeListAction", "MoveToChangeListToggleAction", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nPartialLocalLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialLocalLineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1107:1\n1#2:1108\n*E\n"})
    private static final class MyLineStatusMarkerRenderer
    extends LocalLineStatusTrackerImpl.LocalLineStatusMarkerRenderer {
        @NotNull
        private final ChangelistsLocalLineStatusTracker tracker;

        public MyLineStatusMarkerRenderer(@NotNull ChangelistsLocalLineStatusTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            super(tracker);
            this.tracker = tracker;
        }

        @NotNull
        protected ChangelistsLocalLineStatusTracker getTracker() {
            return this.tracker;
        }

        protected void paintGutterMarkers(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            MyFlagsProvider flagsProvider = new MyFlagsProvider(this.getTracker().defaultMarker.getChangelistId());
            LineStatusMarkerDrawUtil.paintDefault((Editor)editor, (Graphics)g, ranges, (VisibleRangeMerger.FlagsProvider)((VisibleRangeMerger.FlagsProvider)flagsProvider), (int)0);
        }

        @Override
        @Nullable
        protected JComponent createAdditionalInfoPanel(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            JComponent superPanel = super.createAdditionalInfoPanel(editor, range, mousePosition, disposable);
            JComponent commitPanel = this.createCommitPanel(editor, range, mousePosition, disposable);
            if (superPanel == null || commitPanel == null) {
                JComponent jComponent = superPanel;
                if (jComponent == null) {
                    jComponent = commitPanel;
                }
                return jComponent;
            }
            BorderLayoutPanel panel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)commitPanel).addToRight((Component)superPanel).andTransparent();
            return (JComponent)panel;
        }

        private final JComponent createCommitPanel(Editor editor, Range range, Point point, Disposable disposable) {
            if (!(range instanceof LocalRange)) {
                return null;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNull((Object)project);
            return CommitChunkService.Companion.getInstance(project).getComponent(this.getTracker(), (LocalRange)range, disposable).getCommitInput();
        }

        @NotNull
        protected List<AnAction> createAdditionalToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable popupDisposable) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
            return this.createChangeListActions(editor, range, mousePosition);
        }

        private final List<AnAction> createChangeListActions(Editor editor, Range range, Point mousePosition) {
            Object v1;
            List changeLists2;
            block5: {
                if (!(range instanceof LocalRange)) {
                    return CollectionsKt.emptyList();
                }
                List list = ChangeListManager.getInstance((Project)this.getTracker().getProject()).getChangeLists();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
                changeLists2 = list;
                Iterable iterable = changeLists2;
                for (Object t : iterable) {
                    LocalChangeList it = (LocalChangeList)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((LocalRange)range).getChangelistId())) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            if ((LocalChangeList)v1 == null) {
                return CollectionsKt.emptyList();
            }
            DefaultActionGroup group = new DefaultActionGroup(VcsBundle.message((String)"ex.changelists", (Object[])new Object[0]), null, AllIcons.Vcs.Changelist);
            group.setPopup(true);
            if (changeLists2.size() > 1) {
                group.add((AnAction)new Separator(VcsBundle.message((String)"ex.changelists", (Object[])new Object[0])));
                for (LocalChangeList changeList : changeLists2) {
                    Intrinsics.checkNotNull((Object)changeList);
                    group.add((AnAction)new MoveToChangeListToggleAction(editor, range, mousePosition, changeList));
                }
                group.add((AnAction)Separator.getInstance());
            }
            group.add((AnAction)new MoveToAnotherChangeListAction(editor, range, mousePosition));
            return CollectionsKt.listOf((Object)group);
        }

        private final Range findRange(Range range) {
            return this.getRangesSource().findRange(range);
        }

        private final void moveToChangeList(Range range, LocalChangeList changeList, Editor editor, Point mousePosition) {
            this.getTracker().moveToChangelist(range, changeList);
            this.reopenRange(editor, range, mousePosition);
        }

        @Override
        @NotNull
        public String toString() {
            return "MyLineStatusMarkerRenderer(tracker=" + this.getTracker() + ")";
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer$MoveToAnotherChangeListAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;Ljava/awt/Point;)V", "getMousePosition", "()Ljava/awt/Point;", "isEnabled", "", "actionPerformed", "", "intellij.platform.vcs.impl"})
        private final class MoveToAnotherChangeListAction
        extends LineStatusMarkerPopupActions.RangeMarkerAction {
            @Nullable
            private final Point mousePosition;

            public MoveToAnotherChangeListAction(@NotNull Editor editor, @Nullable Range range, Point mousePosition) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                super(editor, (LineStatusMarkerRangesSource)MyLineStatusMarkerRenderer.this.getTracker(), range, null);
                this.mousePosition = mousePosition;
                this.getTemplatePresentation().setText(VcsBundle.message((String)"ex.new.changelist", (Object[])new Object[0]));
            }

            @Nullable
            public final Point getMousePosition() {
                return this.mousePosition;
            }

            protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return range instanceof LocalRange;
            }

            protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                MoveChangesLineStatusAction.moveToAnotherChangelist((PartialLocalLineStatusTracker)MyLineStatusMarkerRenderer.this.getTracker(), (LocalRange)range);
                MyLineStatusMarkerRenderer.this.reopenRange(editor, range, this.mousePosition);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer$MoveToChangeListToggleAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "changelist", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;Ljava/awt/Point;Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "getMousePosition", "()Ljava/awt/Point;", "getChangelist", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.platform.vcs.impl"})
        private final class MoveToChangeListToggleAction
        extends DumbAwareToggleAction {
            @NotNull
            private final Editor editor;
            @NotNull
            private final Range range;
            @Nullable
            private final Point mousePosition;
            @NotNull
            private final LocalChangeList changelist;

            public MoveToChangeListToggleAction(@NotNull Editor editor, @Nullable Range range, @NotNull Point mousePosition, LocalChangeList changelist) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter((Object)changelist, (String)"changelist");
                super(changelist.getName());
                this.editor = editor;
                this.range = range;
                this.mousePosition = mousePosition;
                this.changelist = changelist;
                this.getTemplatePresentation().setText(StringUtil.trimMiddle((String)this.changelist.getName(), (int)60), false);
                this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
            }

            @Nullable
            public final Point getMousePosition() {
                return this.mousePosition;
            }

            @NotNull
            public final LocalChangeList getChangelist() {
                return this.changelist;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                Range newRange = MyLineStatusMarkerRenderer.this.findRange(this.range);
                e.getPresentation().setEnabled(newRange != null && !this.editor.isDisposed() && newRange instanceof LocalRange);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Range range = MyLineStatusMarkerRenderer.this.findRange(this.range);
                if (range == null) {
                    return false;
                }
                Range newRange = range;
                if ((newRange instanceof LocalRange ? (LocalRange)newRange : null) == null) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((LocalRange)newRange).getChangelistId(), (Object)this.changelist.getId());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Range range = MyLineStatusMarkerRenderer.this.findRange(this.range);
                if (range == null) {
                    return;
                }
                Range newRange = range;
                MyLineStatusMarkerRenderer.this.moveToChangeList(newRange, this.changelist, this.editor, this.mousePosition);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyLineStatusMarkerRenderer$MyFlagsProvider;", "Lcom/intellij/openapi/diff/DefaultFlagsProvider;", "defaultChangelistId", "", "<init>", "(Ljava/lang/String;)V", "getFlags", "Lcom/intellij/openapi/diff/DefaultLineFlags;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "intellij.platform.vcs.impl"})
        public static final class MyFlagsProvider
        extends DefaultFlagsProvider {
            @NotNull
            private final String defaultChangelistId;

            public MyFlagsProvider(@NotNull String defaultChangelistId) {
                Intrinsics.checkNotNullParameter((Object)defaultChangelistId, (String)"defaultChangelistId");
                this.defaultChangelistId = defaultChangelistId;
            }

            @NotNull
            public DefaultLineFlags getFlags(@NotNull Range range) {
                DefaultLineFlags defaultLineFlags;
                boolean ignored;
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                boolean bl = ignored = range instanceof LocalRange && !Intrinsics.areEqual((Object)((LocalRange)range).getChangelistId(), (Object)this.defaultChangelistId);
                if (ignored) {
                    DefaultLineFlags defaultLineFlags2 = DefaultLineFlags.IGNORED;
                    defaultLineFlags = defaultLineFlags2;
                    Intrinsics.checkNotNullExpressionValue((Object)defaultLineFlags2, (String)"IGNORED");
                } else {
                    DefaultLineFlags defaultLineFlags3 = DefaultLineFlags.DEFAULT;
                    defaultLineFlags = defaultLineFlags3;
                    Intrinsics.checkNotNullExpressionValue((Object)defaultLineFlags3, (String)"DEFAULT");
                }
                return defaultLineFlags;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyUndoCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;)V", "commandStarted", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "commandFinished", "undoTransparentActionStarted", "undoTransparentActionFinished", "beforeCommandFinished", "beforeUndoTransparentActionFinished", "registerRedoAction", "intellij.platform.vcs.impl"})
    private final class MyUndoCommandListener
    implements CommandListener {
        public void commandStarted(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
                ChangelistsLocalLineStatusTracker.this.hasUndoInCommand = false;
            }
        }

        public void commandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
                ChangelistsLocalLineStatusTracker.this.hasUndoInCommand = false;
            }
        }

        public void undoTransparentActionStarted() {
            if (!CommandProcessor.getInstance().isCommandInProgress()) {
                ChangelistsLocalLineStatusTracker.this.hasUndoInCommand = false;
            }
        }

        public void undoTransparentActionFinished() {
            if (!CommandProcessor.getInstance().isCommandInProgress()) {
                ChangelistsLocalLineStatusTracker.this.hasUndoInCommand = false;
            }
        }

        public void beforeCommandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.registerRedoAction();
        }

        public void beforeUndoTransparentActionFinished() {
            this.registerRedoAction();
        }

        private final void registerRedoAction() {
            if (ChangelistsLocalLineStatusTracker.this.hasUndoInCommand && ChangelistsLocalLineStatusTracker.this.redoStateRecordingEnabled) {
                ChangelistsLocalLineStatusTracker.this.registerUndoAction(false);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyUndoDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;)V", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyUndoDocumentListener
    implements DocumentListener {
        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (ChangelistsLocalLineStatusTracker.this.getProject().isDisposed()) {
                return;
            }
            if (ChangelistsLocalLineStatusTracker.this.hasUndoInCommand) {
                return;
            }
            if (ChangelistsLocalLineStatusTracker.this.undoManager.isUndoOrRedoInProgress()) {
                return;
            }
            if (!CommandProcessor.getInstance().isCommandInProgress()) {
                return;
            }
            ChangelistsLocalLineStatusTracker.this.hasUndoInCommand = true;
            ChangelistsLocalLineStatusTracker.this.registerUndoAction(true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\t\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0002R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$MyUndoableAction;", "Lcom/intellij/openapi/command/undo/BasicUndoableAction;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "states", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "undo", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ljava/util/List;Z)V", "getStates", "()Ljava/util/List;", "setStates", "(Ljava/util/List;)V", "getUndo", "()Z", "projectRef", "Ljava/lang/ref/WeakReference;", "getProjectRef", "()Ljava/lang/ref/WeakReference;", "drop", "", "redo", "restore", "intellij.platform.vcs.impl"})
    private static final class MyUndoableAction
    extends BasicUndoableAction {
        @Nullable
        private List<RangeState> states;
        private final boolean undo;
        @NotNull
        private final WeakReference<Project> projectRef;

        public MyUndoableAction(@NotNull Project project, @NotNull Document document, @Nullable List<RangeState> states, boolean undo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Document[] documentArray = new Document[]{document};
            super(documentArray);
            this.states = states;
            this.undo = undo;
            this.projectRef = new WeakReference<Project>(project);
        }

        @Nullable
        public final List<RangeState> getStates() {
            return this.states;
        }

        public final void setStates(@Nullable List<RangeState> list) {
            this.states = list;
        }

        public final boolean getUndo() {
            return this.undo;
        }

        @NotNull
        public final WeakReference<Project> getProjectRef() {
            return this.projectRef;
        }

        public final void drop() {
            this.states = null;
        }

        public void undo() {
            if (this.undo) {
                this.restore();
            }
        }

        public void redo() {
            if (!this.undo) {
                this.restore();
            }
        }

        private final void restore() {
            LineStatusTracker<?> tracker;
            Object[] objectArray = this.getAffectedDocuments();
            Intrinsics.checkNotNull((Object)objectArray);
            Document document = ((DocumentReference)ArraysKt.single((Object[])objectArray)).getDocument();
            Project project = (Project)this.projectRef.get();
            List<RangeState> rangeStates = this.states;
            if (document != null && project != null && rangeStates != null && (tracker = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(document)) instanceof ChangelistsLocalLineStatusTracker) {
                ((ChangelistsLocalLineStatusTracker)tracker).restoreState(rangeStates);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u001e\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;)V", "onRangeRefreshed", "", "before", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "after", "", "onRangesChanged", "onRangeShifted", "mergeRanges", "", "block1", "block2", "merged", "afterBulkRangeChange", "isDirty", "onUnfreeze", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nPartialLocalLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialLocalLineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1107:1\n1#2:1108\n777#3:1109\n873#3,2:1110\n1807#3,3:1112\n1786#3,3:1115\n1586#3:1118\n1661#3,3:1119\n1915#3,2:1122\n*S KotlinDebug\n*F\n+ 1 PartialLocalLineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler\n*L\n442#1:1109\n442#1:1110,2\n444#1:1112,3\n447#1:1115,3\n451#1:1118\n451#1:1119,3\n502#1:1122,2\n*E\n"})
    private final class PartialDocumentTrackerHandler
    implements DocumentTracker.Handler {
        public void onRangeRefreshed(@NotNull DocumentTracker.Block before, @NotNull List<DocumentTracker.Block> after) {
            RangeExclusionState rangeExclusionState;
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after, (String)"after");
            RangeExclusionState rangeExclusionState2 = ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(before);
            if (Intrinsics.areEqual((Object)rangeExclusionState2, (Object)RangeExclusionState.Included.INSTANCE)) {
                rangeExclusionState = (RangeExclusionState)RangeExclusionState.Included.INSTANCE;
            } else if (Intrinsics.areEqual((Object)rangeExclusionState2, (Object)RangeExclusionState.Excluded.INSTANCE)) {
                rangeExclusionState = (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
            } else if (rangeExclusionState2 instanceof RangeExclusionState.Partial) {
                rangeExclusionState = (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            RangeExclusionState excludedFromCommit = rangeExclusionState;
            ChangeListMarker marker = ChangelistsLocalLineStatusTracker.this.getMarker(before);
            for (DocumentTracker.Block block : after) {
                ChangelistsLocalLineStatusTracker.this.setExcludedFromCommit(block, excludedFromCommit);
                ChangelistsLocalLineStatusTracker.this.setMarker(block, marker);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void onRangesChanged(@NotNull List<DocumentTracker.Block> before, @NotNull DocumentTracker.Block after) {
            block17: {
                block18: {
                    block16: {
                        Intrinsics.checkNotNullParameter(before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        v0 = ChangelistsLocalLineStatusTracker.access$getActiveChangeListTracker$p(ChangelistsLocalLineStatusTracker.this).getActiveChangeListId();
                        if (v0 != null) {
                            it = v0;
                            $i$a$-let-ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler$onRangesChanged$activeMarker$1 = false;
                            v1 = new ChangeListMarker((String)it);
                        } else {
                            v1 = activeMarker = ChangelistsLocalLineStatusTracker.access$getDefaultMarker$p(ChangelistsLocalLineStatusTracker.this);
                        }
                        if (!before.isEmpty()) break block18;
                        var6_10 = ChangelistsLocalLineStatusTracker.this.getBlocks();
                        it = ChangelistsLocalLineStatusTracker.this;
                        $i$f$filter = false;
                        var9_11 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        var12_15 = $this$filterTo$iv$iv.iterator();
                        while (var12_15.hasNext()) {
                            element$iv$iv = var12_15.next();
                            it = (DocumentTracker.Block)element$iv$iv;
                            $i$a$-filter-ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler$onRangesChanged$shouldExclude$changeListBlocks$1 = false;
                            if (!Intrinsics.areEqual((Object)ChangelistsLocalLineStatusTracker.access$getMarker((ChangelistsLocalLineStatusTracker)it, it), (Object)activeMarker)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        changeListBlocks = (List)destination$iv$iv;
                        if (changeListBlocks.isEmpty()) ** GOTO lbl-1000
                        $this$filter$iv = changeListBlocks;
                        it = ChangelistsLocalLineStatusTracker.this;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v2 = false;
                        } else {
                            $this$filterTo$iv$iv = $this$any$iv.iterator();
                            while ($this$filterTo$iv$iv.hasNext()) {
                                element$iv = $this$filterTo$iv$iv.next();
                                it = (DocumentTracker.Block)element$iv;
                                $i$a$-any-ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler$onRangesChanged$shouldExclude$1 = false;
                                if (!(Intrinsics.areEqual((Object)ChangelistsLocalLineStatusTracker.access$getExcludedFromCommit((ChangelistsLocalLineStatusTracker)it, it), (Object)RangeExclusionState.Included.INSTANCE) == false)) continue;
                                v2 = true;
                                break block16;
                            }
                            v2 = false;
                        }
                    }
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    break block17;
                }
                changeListBlocks = before;
                $this$any$iv = ChangelistsLocalLineStatusTracker.this;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v3 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (DocumentTracker.Block)element$iv;
                        $i$a$-all-ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler$onRangesChanged$shouldExclude$2 = false;
                        if (Intrinsics.areEqual((Object)ChangelistsLocalLineStatusTracker.access$getExcludedFromCommit((ChangelistsLocalLineStatusTracker)$this$any$iv, it), (Object)RangeExclusionState.Excluded.INSTANCE)) continue;
                        v3 = false;
                        break block17;
                    }
                    v3 = true;
                }
            }
            shouldExclude = v3;
            ChangelistsLocalLineStatusTracker.access$setExcludedFromCommit(ChangelistsLocalLineStatusTracker.this, after, shouldExclude != false ? (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE : (RangeExclusionState)RangeExclusionState.Included.INSTANCE);
            $this$any$iv = before;
            var7_5 = ChangelistsLocalLineStatusTracker.this;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (DocumentTracker.Block)item$iv$iv;
                var16_22 = destination$iv$iv;
                $i$a$-map-ChangelistsLocalLineStatusTracker$PartialDocumentTrackerHandler$onRangesChanged$affectedMarkers$1 = false;
                var16_22.add(ChangelistsLocalLineStatusTracker.access$getMarker(var7_5, it));
            }
            affectedMarkers = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if (affectedMarkers.isEmpty()) {
                ChangelistsLocalLineStatusTracker.access$setMarker(ChangelistsLocalLineStatusTracker.this, after, activeMarker);
            } else if (affectedMarkers.size() == 1) {
                ChangelistsLocalLineStatusTracker.access$setMarker(ChangelistsLocalLineStatusTracker.this, after, (ChangeListMarker)CollectionsKt.single((List)affectedMarkers));
            } else {
                ChangelistsLocalLineStatusTracker.access$setMarker(ChangelistsLocalLineStatusTracker.this, after, ChangelistsLocalLineStatusTracker.access$getDefaultMarker$p(ChangelistsLocalLineStatusTracker.this));
                ChangelistsLocalLineStatusTracker.access$getLstManager$p(ChangelistsLocalLineStatusTracker.this).notifyInactiveRangesDamaged$intellij_platform_vcs_impl(ChangelistsLocalLineStatusTracker.this.getVirtualFile());
            }
        }

        public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangelistsLocalLineStatusTracker.this.setExcludedFromCommit(after, ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(before));
            ChangelistsLocalLineStatusTracker.this.setMarker(after, ChangelistsLocalLineStatusTracker.this.getMarker(before));
        }

        public boolean mergeRanges(@NotNull DocumentTracker.Block block1, @NotNull DocumentTracker.Block block2, @NotNull DocumentTracker.Block merged) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            if (Intrinsics.areEqual((Object)ChangelistsLocalLineStatusTracker.this.getMarker(block1), (Object)ChangelistsLocalLineStatusTracker.this.getMarker(block2)) && Intrinsics.areEqual((Object)ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block1), (Object)ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block2))) {
                ChangelistsLocalLineStatusTracker.this.setMarker(merged, ChangelistsLocalLineStatusTracker.this.getMarker(block1));
                ChangelistsLocalLineStatusTracker.this.setExcludedFromCommit(merged, ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block1));
                return true;
            }
            if (block1.getRange().isEmpty()) {
                ChangelistsLocalLineStatusTracker.this.setMarker(merged, ChangelistsLocalLineStatusTracker.this.getMarker(block2));
                ChangelistsLocalLineStatusTracker.this.setExcludedFromCommit(merged, ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block2));
                return true;
            }
            if (block2.getRange().isEmpty()) {
                ChangelistsLocalLineStatusTracker.this.setMarker(merged, ChangelistsLocalLineStatusTracker.this.getMarker(block1));
                ChangelistsLocalLineStatusTracker.this.setExcludedFromCommit(merged, ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block1));
                return true;
            }
            return false;
        }

        public void afterBulkRangeChange(boolean isDirty) {
            ChangelistsLocalLineStatusTracker.updateAffectedChangeLists$default(ChangelistsLocalLineStatusTracker.this, false, 1, null);
            ChangelistsLocalLineStatusTracker.this.fireExcludedFromCommitChanged();
        }

        /*
         * WARNING - void declaration
         */
        public void onUnfreeze() {
            if (!ChangelistsLocalLineStatusTracker.this.initialExcludeState.isEmpty()) {
                void $this$forEach$iv;
                Iterable iterable = ChangelistsLocalLineStatusTracker.this.getBlocks();
                ChangelistsLocalLineStatusTracker changelistsLocalLineStatusTracker = ChangelistsLocalLineStatusTracker.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DocumentTracker.Block block = (DocumentTracker.Block)element$iv;
                    boolean bl = false;
                    Boolean bl2 = (Boolean)changelistsLocalLineStatusTracker.initialExcludeState.get(changelistsLocalLineStatusTracker.getMarker(block));
                    if (bl2 == null) {
                        continue;
                    }
                    boolean initWithExclusion = bl2;
                    changelistsLocalLineStatusTracker.setExcludedFromCommit(block, initWithExclusion ? (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE : (RangeExclusionState)RangeExclusionState.Included.INSTANCE);
                }
                ChangelistsLocalLineStatusTracker.this.initialExcludeState.clear();
            }
            if (ChangelistsLocalLineStatusTracker.this.isValid()) {
                ((PartialLocalLineStatusTracker.Listener)ChangelistsLocalLineStatusTracker.this.eventDispatcher.getMulticaster()).onBecomingValid(ChangelistsLocalLineStatusTracker.this);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "", "range", "Lcom/intellij/diff/util/Range;", "changelistId", "", "excludedFromCommit", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "(Lcom/intellij/diff/util/Range;Ljava/lang/String;Lcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "getRange", "()Lcom/intellij/diff/util/Range;", "getChangelistId", "()Ljava/lang/String;", "getExcludedFromCommit", "()Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "intellij.platform.vcs.impl"})
    public static final class RangeState {
        @NotNull
        private final com.intellij.diff.util.Range range;
        @NotNull
        private final String changelistId;
        @Nullable
        private final RangeExclusionState excludedFromCommit;

        public RangeState(@NotNull com.intellij.diff.util.Range range, @NotNull String changelistId, @Nullable RangeExclusionState excludedFromCommit) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            this.range = range;
            this.changelistId = changelistId;
            this.excludedFromCommit = excludedFromCommit;
        }

        public /* synthetic */ RangeState(com.intellij.diff.util.Range range, String string, RangeExclusionState rangeExclusionState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                rangeExclusionState = null;
            }
            this(range, string, rangeExclusionState);
        }

        @NotNull
        public final com.intellij.diff.util.Range getRange() {
            return this.range;
        }

        @NotNull
        public final String getChangelistId() {
            return this.changelistId;
        }

        @Nullable
        public final RangeExclusionState getExcludedFromCommit() {
            return this.excludedFromCommit;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRanges", "()Ljava/util/List;", "intellij.platform.vcs.impl"})
    public static class State {
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final List<RangeState> ranges;

        public State(@NotNull VirtualFile virtualFile, @NotNull List<RangeState> ranges) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this.virtualFile = virtualFile;
            this.ranges = ranges;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final List<RangeState> getRanges() {
            return this.ranges;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0082\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$ToCommitCondition;", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "changelistsIds", "", "", "honorExcludedFromCommit", "", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;Ljava/util/List;Z)V", "getHonorExcludedFromCommit", "()Z", "idsSet", "", "invoke", "block", "intellij.platform.vcs.impl"})
    private final class ToCommitCondition
    implements Function1<DocumentTracker.Block, RangeExclusionState> {
        private final boolean honorExcludedFromCommit;
        @NotNull
        private final Set<String> idsSet;

        public ToCommitCondition(List<String> changelistsIds, boolean honorExcludedFromCommit) {
            Intrinsics.checkNotNullParameter(changelistsIds, (String)"changelistsIds");
            this.honorExcludedFromCommit = honorExcludedFromCommit;
            this.idsSet = CollectionsKt.toSet((Iterable)changelistsIds);
        }

        public final boolean getHonorExcludedFromCommit() {
            return this.honorExcludedFromCommit;
        }

        @NotNull
        public RangeExclusionState invoke(@NotNull DocumentTracker.Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (!this.idsSet.contains(ChangelistsLocalLineStatusTracker.this.getMarker(block).getChangelistId())) {
                return (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
            }
            if (this.honorExcludedFromCommit) {
                return ChangelistsLocalLineStatusTracker.this.getExcludedFromCommit(block);
            }
            return (RangeExclusionState)RangeExclusionState.Included.INSTANCE;
        }
    }
}

