/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ModuleVcsDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultVcsRootPolicy {
    @NotNull
    protected final Project myProject;

    protected DefaultVcsRootPolicy(@NotNull Project project) {
        if (project == null) {
            DefaultVcsRootPolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static DefaultVcsRootPolicy getInstance(Project project) {
        return (DefaultVcsRootPolicy)project.getService(DefaultVcsRootPolicy.class);
    }

    @NotNull
    public abstract Collection<VirtualFile> getDefaultVcsRoots();

    @Nls
    public String getProjectConfigurationMessage() {
        boolean isDirectoryBased = ProjectKt.isDirectoryBased((Project)this.myProject);
        if (isDirectoryBased) {
            String fileName = Objects.requireNonNull(ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath()).getFileName().toString();
            return VcsBundle.message((String)"settings.vcs.mapping.project.description.with.idea.directory", (Object[])new Object[]{fileName});
        }
        return VcsBundle.message((String)"settings.vcs.mapping.project.description", (Object[])new Object[0]);
    }

    @Nls
    public String getProjectMappingInDialogDescription() {
        String message;
        boolean isDirectoryBased = ProjectKt.isDirectoryBased((Project)this.myProject);
        if (isDirectoryBased) {
            String fileName = Objects.requireNonNull(ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath()).getFileName().toString();
            message = VcsBundle.message((String)"settings.vcs.mapping.project.in.dialog.description.with.idea.directory", (Object[])new Object[]{fileName});
        } else {
            message = VcsBundle.message((String)"settings.vcs.mapping.project.description", (Object[])new Object[0]);
        }
        message = message.replace('\n', ' ');
        return StringUtil.escapeXmlEntities((String)(ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]) + ": " + message));
    }

    protected void scheduleMappedRootsUpdate() {
        ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
        if (StringUtil.isNotEmpty((String)vcsManager.haveDefaultMapping())) {
            vcsManager.scheduleMappedRootsUpdate();
        }
    }

    protected void scheduleRootsChangeProcessing(Collection<VirtualFile> removed, Collection<VirtualFile> added) {
        ((ModuleVcsDetector)this.myProject.getService(ModuleVcsDetector.class)).scheduleScanForNewContentRoots(removed, added);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy", "<init>"));
    }
}

