/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.vcs.VcsActivity;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.ChangeListDataCleaner;
import com.intellij.vcs.commit.CommittedChangesCacheListener;
import com.intellij.vcs.commit.EmptyChangeListDeleter;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.SaveCommittingDocumentsVetoerKt;
import com.intellij.vcs.commit.VcsCommitter;
import com.intellij.vcs.commit.VcsPathsToRefreshProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\r\b\u0002\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/commit/LocalChangesCommitter;", "Lcom/intellij/vcs/commit/VcsCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "localHistoryActionName", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/ChangeListCommitState;Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/lang/String;)V", "getCommitState", "()Lcom/intellij/vcs/commit/ChangeListCommitState;", "value", "", "isSuccess", "()Z", "commit", "", "commitChanges", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "commitWithoutChanges", "committedVcses", "refreshChanges", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalChangesCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalChangesCommitter.kt\ncom/intellij/vcs/commit/LocalChangesCommitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1651#2:154\n1915#2:155\n1916#2:157\n1652#2:158\n1915#2,2:159\n1#3:156\n*S KotlinDebug\n*F\n+ 1 LocalChangesCommitter.kt\ncom/intellij/vcs/commit/LocalChangesCommitter\n*L\n73#1:154\n73#1:155\n73#1:157\n73#1:158\n74#1:159,2\n73#1:156\n*E\n"})
public class LocalChangesCommitter
extends VcsCommitter {
    @NotNull
    private final ChangeListCommitState commitState;
    @NotNull
    private final String localHistoryActionName;
    private boolean isSuccess;

    public LocalChangesCommitter(@NotNull Project project, @NotNull ChangeListCommitState commitState, @NotNull CommitContext commitContext, @NotNull String localHistoryActionName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        Intrinsics.checkNotNullParameter((Object)localHistoryActionName, (String)"localHistoryActionName");
        super(project, commitState.getChanges(), commitState.getCommitMessage(), commitContext, true);
        this.commitState = commitState;
        this.localHistoryActionName = localHistoryActionName;
        this.addResultHandler(new CommittedChangesCacheListener(project));
        this.addResultHandler(new ChangeListDataCleaner(this));
        this.addResultHandler(new EmptyChangeListDeleter(this));
    }

    public /* synthetic */ LocalChangesCommitter(Project project, ChangeListCommitState changeListCommitState, CommitContext commitContext, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string2 = VcsBundle.message((String)"activity.name.commit", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        }
        this(project, changeListCommitState, commitContext, string);
    }

    @NotNull
    public final ChangeListCommitState getCommitState() {
        return this.commitState;
    }

    public final boolean isSuccess() {
        return this.isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit() {
        try {
            SaveCommittingDocumentsVetoerKt.vetoDocumentSaving(this.getProject(), (Collection<? extends Change>)this.getChanges(), (Function0<Unit>)((Function0)() -> LocalChangesCommitter.commit$lambda$0(this)));
            this.isSuccess = this.getCommitErrors().isEmpty();
        }
        finally {
            this.refreshChanges();
        }
    }

    private final Set<AbstractVcs> commitChanges() {
        Set committedVcses = new LinkedHashSet();
        ChangesUtil.processChangesByVcs((Project)this.getProject(), (Collection)this.getChanges(), (arg_0, arg_1) -> LocalChangesCommitter.commitChanges$lambda$0(committedVcses, this, arg_0, arg_1));
        return committedVcses;
    }

    /*
     * WARNING - void declaration
     */
    private final void commitWithoutChanges(Set<? extends AbstractVcs> committedVcses) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = LocalChangesCommitterKt.getCommitWithoutChangesRoots(this.getCommitContext());
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            AbstractVcs it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            VcsRoot it = (VcsRoot)element$iv;
            boolean bl2 = false;
            if (it.getVcs() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set commitWithoutChangesVcses = (Set)destination$iv;
        Iterable $this$forEach$iv = SetsKt.minus((Set)commitWithoutChangesVcses, (Iterable)committedVcses);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractVcs it = (AbstractVcs)element$iv;
            boolean bl = false;
            this.vcsCommit(it, CollectionsKt.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshChanges() {
        try {
            LocalHistoryAction refreshAction = (LocalHistoryAction)ActionsKt.runReadAction(() -> LocalChangesCommitter.refreshChanges$lambda$0(this));
            List toRefresh = new ArrayList();
            List additionalPathsToRefresh = new ArrayList();
            ChangesUtil.processChangesByVcs((Project)this.getProject(), (Collection)this.getChanges(), (arg_0, arg_1) -> LocalChangesCommitter.refreshChanges$lambda$1(toRefresh, additionalPathsToRefresh, this, arg_0, arg_1));
            if (!((Collection)toRefresh).isEmpty()) {
                String string = VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.progress$intellij_platform_vcs_impl(string);
                RefreshVFsSynchronously.updateChanges(toRefresh);
            }
            refreshAction.finish();
            List allPathsToRefresh = CollectionsKt.plus((Collection)this.getPathsToRefresh(), (Iterable)additionalPathsToRefresh);
            if (!((Collection)allPathsToRefresh).isEmpty()) {
                ChangeListManagerImpl.getInstanceImpl(this.getProject()).showLocalChangesInvalidated();
            }
            VcsDirtyScopeManager.getInstance((Project)this.getProject()).filePathsDirty((Collection)allPathsToRefresh, null);
            LocalHistory.Companion.getInstance().putEventLabel(this.getProject(), LocalChangesCommitterKt.getLocalHistoryEventName(this.getCommitContext(), this.getCommitMessage()), VcsActivity.Commit);
        }
        finally {
            ChangeListManager.getInstance((Project)this.getProject()).invokeAfterUpdate(true, () -> LocalChangesCommitter.refreshChanges$lambda$2(this));
        }
    }

    private static final Unit commit$lambda$0(LocalChangesCommitter this$0) {
        Set<AbstractVcs> committedVcses = this$0.commitChanges();
        this$0.commitWithoutChanges(committedVcses);
        return Unit.INSTANCE;
    }

    private static final void commitChanges$lambda$0(Set $committedVcses, LocalChangesCommitter this$0, AbstractVcs vcs, List vcsChanges) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)vcsChanges, (String)"vcsChanges");
        ((Collection)$committedVcses).add(vcs);
        this$0.vcsCommit(vcs, vcsChanges);
    }

    private static final LocalHistoryAction refreshChanges$lambda$0(LocalChangesCommitter this$0) {
        return LocalHistory.Companion.getInstance().startAction(this$0.localHistoryActionName);
    }

    private static final void refreshChanges$lambda$1(List $toRefresh, List $additionalPathsToRefresh, LocalChangesCommitter this$0, AbstractVcs vcs, List changes) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment != null && environment.isRefreshAfterCommitNeeded()) {
            $toRefresh.addAll(changes);
        }
        $additionalPathsToRefresh.addAll(VcsPathsToRefreshProvider.Companion.collectPathsToRefreshForVcs(this$0.getProject(), vcs));
    }

    private static final void refreshChanges$lambda$2(LocalChangesCommitter this$0) {
        this$0.fireAfterRefresh();
    }
}

