/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.vcs.commit.AbstractCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0004R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/commit/VcsCommitter;", "Lcom/intellij/vcs/commit/AbstractCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "Lcom/intellij/openapi/util/NlsSafe;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "useCustomPostRefresh", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/CommitContext;Z)V", "getChanges", "()Ljava/util/List;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "_feedback", "", "_failedToCommitChanges", "", "_pathsToRefresh", "Lcom/intellij/openapi/vcs/FilePath;", "failedToCommitChanges", "getFailedToCommitChanges", "pathsToRefresh", "getPathsToRefresh", "feedback", "", "getFeedback", "()Ljava/util/Set;", "vcsCommit", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsCommitter.kt\ncom/intellij/vcs/commit/VcsCommitter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n13#2:44\n1915#3,2:45\n*S KotlinDebug\n*F\n+ 1 VcsCommitter.kt\ncom/intellij/vcs/commit/VcsCommitter\n*L\n32#1:44\n39#1:45,2\n*E\n"})
public abstract class VcsCommitter
extends AbstractCommitter {
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final CommitContext commitContext;
    @NotNull
    private final Set<String> _feedback;
    @NotNull
    private final List<Change> _failedToCommitChanges;
    @NotNull
    private final List<FilePath> _pathsToRefresh;

    public VcsCommitter(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, boolean useCustomPostRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        super(project, commitMessage, useCustomPostRefresh);
        this.changes = changes;
        this.commitContext = commitContext;
        this._feedback = new LinkedHashSet();
        this._failedToCommitChanges = new ArrayList();
        this._pathsToRefresh = new ArrayList();
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    @NotNull
    public final CommitContext getCommitContext() {
        return this.commitContext;
    }

    @NotNull
    public final List<Change> getFailedToCommitChanges() {
        return CollectionsKt.toList((Iterable)this._failedToCommitChanges);
    }

    @NotNull
    public final List<FilePath> getPathsToRefresh() {
        return CollectionsKt.toList((Iterable)this._pathsToRefresh);
    }

    @NotNull
    public final Set<String> getFeedback() {
        return CollectionsKt.toSet((Iterable)this._feedback);
    }

    protected final void vcsCommit(@NotNull AbstractVcs vcs, @NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(VcsCommitter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Skipping commit for " + vcs.getName() + " - not implemented");
            return;
        }
        List list = ChangesUtil.getPaths((Collection)changes);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPaths(...)");
        this._pathsToRefresh.addAll(list);
        List exceptions = environment.commit(changes, this.getCommitMessage(), this.commitContext, this._feedback);
        Collection collection = exceptions;
        if (!(collection == null || collection.isEmpty())) {
            Iterable $this$forEach$iv = exceptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsException it = (VcsException)((Object)element$iv);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)((Object)it));
                this.addException(it);
            }
            this._failedToCommitChanges.addAll((Collection<Change>)changes);
        }
    }
}

