/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.core.filter;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/flyway/core/filter/FlywayStatusFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "myPattern", "Ljava/util/regex/Pattern;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.flyway.core"})
public final class FlywayStatusFilter
implements Filter {
    @NotNull
    private final Pattern myPattern;

    public FlywayStatusFilter() {
        Pattern pattern = Pattern.compile("\\|\\s+?(Success|Pending|Failed|Ignored|Deleted)\\s+?\\|", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.myPattern = pattern;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = this.myPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String status = matcher.group(1);
        Intrinsics.checkNotNull((Object)status);
        if (StringsKt.contains((CharSequence)status, (CharSequence)"Success", (boolean)true)) {
            color = (Color)new JBColor(new Color(98, 150, 85), new Color(98, 150, 85));
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Pending", (boolean)true)) {
            color = (Color)new JBColor(new Color(138, 138, 0), new Color(138, 138, 0));
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Failed", (boolean)true)) {
            color = (Color)new JBColor(new Color(255, 100, 100), DarculaColors.RED);
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Ignored", (boolean)true)) {
            JBColor jBColor = JBColor.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
            color = (Color)jBColor;
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Deleted", (boolean)true)) {
            JBColor jBColor = JBColor.ORANGE;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"ORANGE");
            color = (Color)jBColor;
        } else {
            return null;
        }
        Color color2 = color;
        int startLineIdx = entireLength - line.length();
        int highlightStartOffset = startLineIdx + matcher.start(1);
        int highlightEndOffset = startLineIdx + matcher.end(1);
        return new Filter.Result(highlightStartOffset, highlightEndOffset, null, new TextAttributes(color2, null, null, null, 1));
    }
}

